/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.osgi;

import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import org.apache.commons.lang.StringUtils;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.osgi.BundleUtils;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.templates.ModuleVersion;
import org.jahia.settings.SettingsBean;
import org.osgi.framework.Bundle;

class JahiaBundleTemplatesPackageHandler {
    JahiaBundleTemplatesPackageHandler() {
    }

    static JahiaTemplatesPackage build(Bundle bundle) {
        String depends;
        File sources;
        if (bundle == null) {
            throw new IllegalArgumentException("Provided bundle is null");
        }
        String moduleType = JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Jahia-Module-Type");
        if (StringUtils.isEmpty((String)moduleType)) {
            return null;
        }
        JahiaTemplatesPackage pkg = new JahiaTemplatesPackage(bundle);
        pkg.setModuleType(moduleType);
        pkg.setModulePriority(Integer.parseInt(StringUtils.defaultString((String)JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Jahia-Module-Priority"), (String)"0")));
        pkg.setEditModeBlocked(Boolean.parseBoolean(StringUtils.defaultString((String)JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Jahia-Block-Edit-Mode"), (String)"false")));
        pkg.setAutoDeployOnSite(StringUtils.defaultString((String)JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Jahia-Deploy-On-Site")));
        pkg.setName(StringUtils.defaultString((String)JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Implementation-Title", "Bundle-Name"), (String)bundle.getSymbolicName()));
        pkg.setVersion(new ModuleVersion(StringUtils.defaultIfBlank((String)JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Implementation-Version"), (String)bundle.getVersion().toString())));
        pkg.setId(bundle.getSymbolicName());
        pkg.setDescription(JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Bundle-Description"));
        JahiaBundleTemplatesPackageHandler.detectResourceBundle(bundle, pkg);
        String srcFolder = JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Jahia-Source-Folders");
        if (srcFolder != null && (sources = new File(srcFolder)).exists()) {
            ServicesRegistry.getInstance().getJahiaTemplateManagerService().setSourcesFolderInPackage(pkg, sources);
        }
        if (pkg.getScmURI() == null) {
            String scmUri = JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Jahia-Source-Control-Connection");
            pkg.setScmURI(scmUri);
        }
        Boolean isSourcesDownloadable = Boolean.TRUE;
        String downloadSourcesHeader = JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Jahia-Download-Sources-Available");
        if (downloadSourcesHeader != null) {
            isSourcesDownloadable = Boolean.valueOf(downloadSourcesHeader);
        }
        pkg.setSourcesDownloadable(SettingsBean.getInstance().isMavenExecutableSet() && isSourcesDownloadable != false);
        URL rootEntry = bundle.getEntry("/");
        if (rootEntry != null) {
            pkg.setFilePath(rootEntry.getPath());
        }
        if (StringUtils.isNotBlank((String)(depends = JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Jahia-Depends")))) {
            String[] dependencies;
            for (String dependency : dependencies = StringUtils.split((String)depends, (String)",")) {
                pkg.setDepends(dependency.trim());
            }
        }
        pkg.setProvider(StringUtils.defaultString((String)JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Implementation-Vendor"), (String)"Jahia Solutions Group SA"));
        pkg.setClassLoader(BundleUtils.createBundleClassLoader(bundle));
        pkg.setForgeUrl(JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Jahia-Private-App-Store"));
        pkg.setGroupId(JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Jahia-GroupId"));
        return pkg;
    }

    private static void detectResourceBundle(Bundle bundle, JahiaTemplatesPackage pkg) {
        String resourceBundle = JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Jahia-Resource-Bundle");
        if (StringUtils.isNotBlank((String)resourceBundle)) {
            pkg.setResourceBundleName(resourceBundle.trim());
            return;
        }
        String rbName = pkg.getId();
        if (JahiaBundleTemplatesPackageHandler.hasResourceBundle(bundle, rbName)) {
            pkg.setResourceBundleName("resources." + rbName);
            return;
        }
        rbName = StringUtils.replace((String)pkg.getName(), (String)" ", (String)"");
        if (JahiaBundleTemplatesPackageHandler.hasResourceBundle(bundle, rbName)) {
            pkg.setResourceBundleName("resources." + rbName);
            return;
        }
        rbName = StringUtils.replace((String)pkg.getName(), (String)" ", (String)"_");
        if (JahiaBundleTemplatesPackageHandler.hasResourceBundle(bundle, rbName)) {
            pkg.setResourceBundleName("resources." + rbName);
        }
    }

    private static boolean hasResourceBundle(Bundle bundle, String resourceBundleName) {
        Enumeration entries;
        boolean found = false;
        found = bundle.getEntry("/resources/" + resourceBundleName + ".properties") != null ? true : (entries = bundle.findEntries("/resources", resourceBundleName + "_*.properties", false)) != null && entries.hasMoreElements();
        return found;
    }

    private static String getHeader(Bundle bundle, String ... headerNamesToLookup) {
        String val = null;
        for (String headerName : headerNamesToLookup) {
            val = (String)bundle.getHeaders().get(headerName);
            if (val != null) break;
        }
        return val;
    }
}

