/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.osgi;

import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.ServletContext;
import org.jahia.services.SpringContextSingleton;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProvisionActivator
implements BundleActivator {
    private static Logger logger = LoggerFactory.getLogger(ProvisionActivator.class);
    private final ServletContext servletContext;
    private BundleContext bundleContext;
    private static ProvisionActivator instance = null;
    private List<ServiceRegistration> serviceRegistrations = new ArrayList<ServiceRegistration>();

    public ProvisionActivator(ServletContext servletContext) {
        this.servletContext = servletContext;
        instance = this;
    }

    public static ProvisionActivator getInstance() {
        return instance;
    }

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.servletContext.setAttribute(BundleContext.class.getName(), (Object)context);
        ArrayList<Bundle> installed = new ArrayList<Bundle>();
        for (URL url : this.findBundles()) {
            logger.info("Installing bundle [{}]", (Object)url);
            Bundle bundle = context.installBundle(url.toExternalForm());
            installed.add(bundle);
        }
        ServiceTracker st = new ServiceTracker(context, StartLevel.class.getName(), null);
        st.open();
        StartLevel sl = (StartLevel)st.getService();
        for (Bundle bundle : installed) {
            if (bundle.getSymbolicName().equals("org.apache.felix.fileinstall")) {
                sl.setBundleStartLevel(bundle, 2);
            }
            if (bundle.getHeaders().get("Fragment-Host") != null) continue;
            bundle.start();
        }
    }

    private void exposeBeansAsServices(BundleContext context) {
        String[] beanNames;
        long timer = System.currentTimeMillis();
        int registered = 0;
        for (String beanName : beanNames = SpringContextSingleton.getInstance().getContext().getBeanNamesForType(null, false, false)) {
            try {
                Object bean = SpringContextSingleton.getInstance().getContext().getBean(beanName);
                ArrayList<String> classNames = new ArrayList<String>();
                if (!this.classNameAccessible(bean.getClass().getName())) continue;
                classNames.add(bean.getClass().getName());
                for (Class<?> classInterface : bean.getClass().getInterfaces()) {
                    if (!this.classNameAccessible(classInterface.getName())) continue;
                    classNames.add(classInterface.getName());
                }
                Hashtable<String, String> serviceProperties = new Hashtable<String, String>(1);
                serviceProperties.put("org.jahia.spring.bean.name", beanName);
                this.serviceRegistrations.add(context.registerService(classNames.toArray(new String[classNames.size()]), bean, serviceProperties));
                ++registered;
                logger.debug("Registered bean {} as OSGi service under names: {}", (Object)beanName, classNames);
            }
            catch (Exception t) {
                logger.warn("Couldn't register bean " + beanName + " since it couldn't be retrieved: " + t.getMessage());
            }
        }
        logger.info("Registered {} Spring beans as OSGi services in {} ms", (Object)registered, (Object)(System.currentTimeMillis() - timer));
    }

    private boolean classNameAccessible(String classOrInterfaceName) {
        if (classOrInterfaceName.startsWith("java.")) {
            return false;
        }
        return !classOrInterfaceName.startsWith("org.apache.felix.framework.");
    }

    public void stop(BundleContext context) throws Exception {
        this.bundleContext = null;
        for (ServiceRegistration serviceRegistration : this.serviceRegistrations) {
            serviceRegistration.unregister();
        }
        this.servletContext.removeAttribute(BundleContext.class.getName());
        instance = null;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    private List<URL> findBundles() throws Exception {
        ArrayList<URL> list = new ArrayList<URL>();
        for (Object o : this.servletContext.getResourcePaths("/WEB-INF/bundles/")) {
            URL url;
            String name = (String)o;
            if (!name.endsWith(".jar") || (url = this.servletContext.getResource(name)) == null) continue;
            list.add(url);
        }
        return list;
    }
}

