/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.params.valves;

import java.security.Principal;
import java.security.SecureRandom;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.jahia.params.valves.AuthValveContext;
import org.jahia.params.valves.BaseAuthValve;
import org.jahia.params.valves.CookieAuthConfig;
import org.jahia.pipelines.PipelineException;
import org.jahia.pipelines.valves.ValveContext;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.usermanager.JahiaUser;

public class CookieAuthValveImpl
extends BaseAuthValve {
    private CookieAuthConfig cookieAuthConfig;

    @Override
    public void invoke(Object context, ValveContext valveContext) throws PipelineException {
        Cookie[] cookies;
        if (!this.isEnabled()) {
            valveContext.invokeNext(context);
            return;
        }
        AuthValveContext authContext = (AuthValveContext)context;
        JahiaUser jahiaUser = null;
        Cookie[] cookieArray = cookies = this.cookieAuthConfig.isActivated() ? authContext.getRequest().getCookies() : null;
        if (cookies == null) {
            valveContext.invokeNext(context);
            return;
        }
        Cookie authCookie = null;
        for (int i = 0; i < cookies.length; ++i) {
            Cookie curCookie = cookies[i];
            if (!this.cookieAuthConfig.getCookieName().equals(curCookie.getName())) continue;
            authCookie = curCookie;
            break;
        }
        if (authCookie != null) {
            Properties searchCriterias = new Properties();
            String userPropertyName = this.cookieAuthConfig.getUserPropertyName();
            searchCriterias.setProperty(userPropertyName, authCookie.getValue());
            Set<Principal> foundUsers = ServicesRegistry.getInstance().getJahiaUserManagerService().searchUsers(searchCriterias);
            if (foundUsers.size() == 1) {
                jahiaUser = (JahiaUser)foundUsers.iterator().next();
                if (jahiaUser.isAccountLocked()) {
                    jahiaUser = null;
                } else {
                    HttpSession session = authContext.getRequest().getSession(false);
                    if (session != null) {
                        session.setAttribute("org.jahia.usermanager.jahiauser", (Object)jahiaUser);
                    }
                    if (this.cookieAuthConfig.isRenewalActivated()) {
                        String cookieUserKey = null;
                        while (cookieUserKey == null) {
                            cookieUserKey = CookieAuthValveImpl.generateRandomString(this.cookieAuthConfig.getIdLength());
                            searchCriterias = new Properties();
                            searchCriterias.setProperty(userPropertyName, cookieUserKey);
                            Set<Principal> usersWithKey = ServicesRegistry.getInstance().getJahiaUserManagerService().searchUsers(searchCriterias);
                            if (usersWithKey.size() <= 0) continue;
                            cookieUserKey = null;
                        }
                        jahiaUser.setProperty(userPropertyName, cookieUserKey);
                        authCookie.setValue(cookieUserKey);
                        authCookie.setPath(StringUtils.isNotEmpty((String)authContext.getRequest().getContextPath()) ? authContext.getRequest().getContextPath() : "/");
                        authCookie.setMaxAge(this.cookieAuthConfig.getMaxAgeInSeconds());
                        authCookie.setHttpOnly(this.cookieAuthConfig.isHttpOnly());
                        authCookie.setSecure(this.cookieAuthConfig.isSecure());
                        HttpServletResponse realResponse = authContext.getResponse();
                        realResponse.addCookie(authCookie);
                    }
                }
            }
        }
        if (jahiaUser == null) {
            valveContext.invokeNext(context);
        } else {
            if (authContext.getRequest().getSession(false) != null) {
                authContext.getRequest().getSession().invalidate();
            }
            authContext.getSessionFactory().setCurrentUser(jahiaUser);
            this.enforcePasswordPolicy(jahiaUser, authContext);
            jahiaUser.setProperty("lastLoginDate", String.valueOf(System.currentTimeMillis()));
        }
    }

    private void enforcePasswordPolicy(JahiaUser theUser, AuthValveContext authContext) {
    }

    public void setCookieAuthConfig(CookieAuthConfig config) {
        this.cookieAuthConfig = config;
    }

    public static String generateRandomString(int length) {
        SecureRandom randomGen = new SecureRandom();
        StringBuffer result = new StringBuffer();
        for (int count = 0; count < length; ++count) {
            int randomSel = randomGen.nextInt(3);
            int randomInt = randomGen.nextInt(26);
            char randomChar = '0';
            switch (randomSel) {
                case 0: {
                    randomChar = (char)(65 + randomInt);
                    break;
                }
                case 1: {
                    randomChar = (char)(97 + randomInt);
                    break;
                }
                case 2: {
                    randomChar = (char)(48 + randomInt % 10);
                }
            }
            result.append(randomChar);
        }
        return result.toString();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.setEnabled(this.cookieAuthConfig.isActivated());
    }
}

