/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.params.valves;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.jahia.params.valves.AuthValveContext;
import org.jahia.params.valves.BaseAuthValve;
import org.jahia.pipelines.PipelineException;
import org.jahia.pipelines.valves.ValveContext;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.usermanager.JahiaUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBasicAuthValveImpl
extends BaseAuthValve {
    private static final transient Logger logger = LoggerFactory.getLogger(HttpBasicAuthValveImpl.class);

    @Override
    public void invoke(Object context, ValveContext valveContext) throws PipelineException {
        block10: {
            if (!this.isEnabled()) {
                valveContext.invokeNext(context);
                return;
            }
            AuthValveContext authContext = (AuthValveContext)context;
            HttpServletRequest request = authContext.getRequest();
            String auth = request.getHeader("Authorization");
            if (auth != null) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Header found : " + auth);
                    }
                    auth = auth.substring(6).trim();
                    Base64 decoder = new Base64();
                    String cred = new String(decoder.decode(auth.getBytes("UTF-8")));
                    int colonInd = cred.indexOf(58);
                    String user = cred.substring(0, colonInd);
                    String pass = cred.substring(colonInd + 1);
                    JahiaUser jahiaUser = ServicesRegistry.getInstance().getJahiaUserManagerService().lookupUser(user);
                    if (jahiaUser != null) {
                        if (jahiaUser.verifyPassword(pass)) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("User " + user + " authenticated.");
                            }
                            if (jahiaUser.isAccountLocked()) {
                                logger.debug("Login failed. Account is locked for user " + user);
                                return;
                            }
                            authContext.getSessionFactory().setCurrentUser(jahiaUser);
                            return;
                        }
                        logger.debug("User found but incorrect password : " + user);
                        break block10;
                    }
                    logger.debug("User not found : " + user);
                }
                catch (Exception e) {
                    logger.debug("Exception thrown", (Throwable)e);
                }
            } else {
                logger.debug("No authorization header found");
            }
        }
        valveContext.invokeNext(context);
    }
}

