/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.params.valves;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.params.valves.LoginUrlProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationListener;

public class LoginConfig
implements ApplicationListener<JahiaContextLoaderListener.RootContextInitializedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(LoginConfig.class);
    private LoginUrlProvider loginUrlProvider;

    private LoginConfig() {
    }

    public static LoginConfig getInstance() {
        return Holder.INSTANCE;
    }

    public String getCustomLoginUrl(HttpServletRequest request) {
        return this.loginUrlProvider != null ? this.loginUrlProvider.getLoginUrl(request) : null;
    }

    public void onApplicationEvent(JahiaContextLoaderListener.RootContextInitializedEvent event) {
        Map beansOfType = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)event.getContext(), LoginUrlProvider.class);
        if (!beansOfType.isEmpty()) {
            for (LoginUrlProvider provider : beansOfType.values()) {
                if (!provider.hasCustomLoginUrl()) continue;
                logger.info("Using login URL provider {}", (Object)provider);
                this.loginUrlProvider = provider;
                return;
            }
        }
    }

    private static class Holder {
        static final LoginConfig INSTANCE = new LoginConfig();

        private Holder() {
        }
    }
}

