/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.params.valves;

import java.security.Principal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.Login;
import org.jahia.params.valves.AuthValveContext;
import org.jahia.params.valves.BaseAuthValve;
import org.jahia.params.valves.CookieAuthConfig;
import org.jahia.params.valves.CookieAuthValveImpl;
import org.jahia.pipelines.PipelineException;
import org.jahia.pipelines.valves.ValveContext;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.preferences.user.UserPreferencesHelper;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.LanguageCodeConverters;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;

public class LoginEngineAuthValveImpl
extends BaseAuthValve {
    public static final String ACCOUNT_LOCKED = "account_locked";
    public static final String BAD_PASSWORD = "bad_password";
    private static final transient Logger logger = LoggerFactory.getLogger(LoginEngineAuthValveImpl.class);
    public static final String LOGIN_TAG_PARAMETER = "doLogin";
    public static final String OK = "ok";
    public static final String UNKNOWN_USER = "unknown_user";
    public static final String USE_COOKIE = "useCookie";
    public static final String VALVE_RESULT = "login_valve_result";
    private CookieAuthConfig cookieAuthConfig;
    private boolean fireLoginEvent = false;
    private String preserveSessionAttributes = null;

    public void setFireLoginEvent(boolean fireLoginEvent) {
        this.fireLoginEvent = fireLoginEvent;
    }

    public void setPreserveSessionAttributes(String preserveSessionAttributes) {
        this.preserveSessionAttributes = preserveSessionAttributes;
    }

    private void enforcePasswordPolicy(JahiaUser theUser) {
    }

    @Override
    public void invoke(Object context, ValveContext valveContext) throws PipelineException {
        if (!this.isEnabled()) {
            valveContext.invokeNext(context);
            return;
        }
        AuthValveContext authContext = (AuthValveContext)context;
        HttpServletRequest httpServletRequest = authContext.getRequest();
        JahiaUser theUser = null;
        boolean ok = false;
        if (this.isLoginRequested(httpServletRequest)) {
            JahiaUserManagerService theService;
            ServicesRegistry theRegistry;
            String username = httpServletRequest.getParameter("username");
            String password = httpServletRequest.getParameter("password");
            if (username != null && password != null && (theRegistry = ServicesRegistry.getInstance()) != null && (theService = theRegistry.getJahiaUserManagerService()) != null) {
                theUser = ServicesRegistry.getInstance().getJahiaUserManagerService().lookupUser(username);
                if (theUser != null) {
                    if (theUser.verifyPassword(password)) {
                        if (!theUser.isAccountLocked()) {
                            ok = true;
                        } else {
                            logger.warn("Login failed: account for user " + theUser.getUsername() + " is locked.");
                            httpServletRequest.setAttribute(VALVE_RESULT, (Object)ACCOUNT_LOCKED);
                        }
                    } else {
                        logger.warn("Login failed: user " + theUser.getUsername() + " provided bad password.");
                        httpServletRequest.setAttribute(VALVE_RESULT, (Object)BAD_PASSWORD);
                    }
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Login failed. Unknown username " + username + ".");
                    }
                    httpServletRequest.setAttribute(VALVE_RESULT, (Object)UNKNOWN_USER);
                }
            }
        }
        if (ok) {
            String useCookie;
            if (logger.isDebugEnabled()) {
                logger.debug("User " + theUser + " logged in.");
            }
            Map<String, Object> savedSessionAttributes = this.preserveSessionAttributes(httpServletRequest);
            if (httpServletRequest.getSession(false) != null) {
                httpServletRequest.getSession().invalidate();
            }
            this.restoreSessionAttributes(httpServletRequest, savedSessionAttributes);
            httpServletRequest.setAttribute(VALVE_RESULT, (Object)OK);
            authContext.getSessionFactory().setCurrentUser(theUser);
            if (SettingsBean.getInstance().isConsiderPreferredLanguageAfterLogin()) {
                Locale preferredUserLocale = UserPreferencesHelper.getPreferredLocale(theUser, LanguageCodeConverters.resolveLocaleForGuest(httpServletRequest));
                httpServletRequest.getSession().setAttribute("org.jahia.services.multilang.currentlocale", (Object)preferredUserLocale);
            }
            if ((useCookie = httpServletRequest.getParameter(USE_COOKIE)) != null && "on".equals(useCookie)) {
                String cookieUserKey = null;
                while (cookieUserKey == null) {
                    cookieUserKey = CookieAuthValveImpl.generateRandomString(this.cookieAuthConfig.getIdLength());
                    Properties searchCriterias = new Properties();
                    searchCriterias.setProperty(this.cookieAuthConfig.getUserPropertyName(), cookieUserKey);
                    Set<Principal> foundUsers = ServicesRegistry.getInstance().getJahiaUserManagerService().searchUsers(searchCriterias);
                    if (foundUsers.size() <= 0) continue;
                    cookieUserKey = null;
                }
                theUser.setProperty(this.cookieAuthConfig.getUserPropertyName(), cookieUserKey);
                Cookie authCookie = new Cookie(this.cookieAuthConfig.getCookieName(), cookieUserKey);
                authCookie.setPath(StringUtils.isNotEmpty((String)httpServletRequest.getContextPath()) ? httpServletRequest.getContextPath() : "/");
                authCookie.setMaxAge(this.cookieAuthConfig.getMaxAgeInSeconds());
                authCookie.setHttpOnly(this.cookieAuthConfig.isHttpOnly());
                authCookie.setSecure(this.cookieAuthConfig.isSecure());
                authContext.getResponse().addCookie(authCookie);
            }
            this.enforcePasswordPolicy(theUser);
            if (this.fireLoginEvent) {
                SpringContextSingleton.getInstance().publishEvent(new LoginEvent(this, theUser, authContext));
            }
        } else {
            valveContext.invokeNext(context);
        }
    }

    private Map<String, Object> preserveSessionAttributes(HttpServletRequest httpServletRequest) {
        HashMap<String, Object> savedSessionAttributes = new HashMap<String, Object>();
        if (this.preserveSessionAttributes != null && httpServletRequest.getSession(false) != null && this.preserveSessionAttributes.length() > 0) {
            String[] sessionAttributeNames = Patterns.TRIPLE_HASH.split(this.preserveSessionAttributes);
            HttpSession session = httpServletRequest.getSession(false);
            for (String sessionAttributeName : sessionAttributeNames) {
                Object attributeValue = session.getAttribute(sessionAttributeName);
                if (attributeValue == null) continue;
                savedSessionAttributes.put(sessionAttributeName, attributeValue);
            }
        }
        return savedSessionAttributes;
    }

    private void restoreSessionAttributes(HttpServletRequest httpServletRequest, Map<String, Object> savedSessionAttributes) {
        if (savedSessionAttributes.size() > 0) {
            HttpSession session = httpServletRequest.getSession();
            for (Map.Entry<String, Object> savedSessionAttribute : savedSessionAttributes.entrySet()) {
                session.setAttribute(savedSessionAttribute.getKey(), savedSessionAttribute.getValue());
            }
        }
    }

    protected boolean isLoginRequested(HttpServletRequest request) {
        String doLogin = request.getParameter(LOGIN_TAG_PARAMETER);
        if (doLogin != null) {
            return Boolean.valueOf(doLogin) != false || "1".equals(doLogin);
        }
        if ("/cms".equals(request.getServletPath())) {
            return Login.getMapping().equals(request.getPathInfo());
        }
        return false;
    }

    public void setCookieAuthConfig(CookieAuthConfig cookieAuthConfig) {
        this.cookieAuthConfig = cookieAuthConfig;
    }

    public class LoginEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = -7356560804745397662L;
        private JahiaUser jahiaUser;
        private AuthValveContext authValveContext;

        public LoginEvent(Object source, JahiaUser jahiaUser, AuthValveContext authValveContext) {
            super(source);
            this.jahiaUser = jahiaUser;
            this.authValveContext = authValveContext;
        }

        public JahiaUser getJahiaUser() {
            return this.jahiaUser;
        }

        public AuthValveContext getAuthValveContext() {
            return this.authValveContext;
        }
    }
}

