/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.params.valves;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.params.valves.LogoutUrlProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationListener;

public class LogoutConfig
implements ApplicationListener<JahiaContextLoaderListener.RootContextInitializedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(LogoutConfig.class);
    private LogoutUrlProvider logoutUrlProvider;

    public static LogoutConfig getInstance() {
        return Holder.INSTANCE;
    }

    private LogoutConfig() {
    }

    public String getCustomLogoutUrl(HttpServletRequest request) {
        return this.logoutUrlProvider != null ? this.logoutUrlProvider.getLogoutUrl(request) : null;
    }

    public void onApplicationEvent(JahiaContextLoaderListener.RootContextInitializedEvent event) {
        Map beansOfType = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)event.getContext(), LogoutUrlProvider.class);
        if (!beansOfType.isEmpty()) {
            for (LogoutUrlProvider provider : beansOfType.values()) {
                if (!provider.hasCustomLogoutUrl()) continue;
                logger.info("Using logout URL provider {}", (Object)provider);
                this.logoutUrlProvider = provider;
                return;
            }
        }
    }

    private static class Holder {
        static final LogoutConfig INSTANCE = new LogoutConfig();

        private Holder() {
        }
    }
}

