/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.pipelines.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.jahia.pipelines.Pipeline;
import org.jahia.pipelines.PipelineException;
import org.jahia.pipelines.valves.Valve;
import org.jahia.pipelines.valves.ValveContext;

public class GenericPipeline
implements Pipeline,
ValveContext {
    protected String name;
    private Valve[] valves = new Valve[0];
    private static final Object valvesLock = new Object();
    protected ThreadLocal<Integer> state = new ThreadLocal();
    protected Map<String, Object> environment = new HashMap<String, Object>();

    @Override
    public Map<String, Object> getEnvironment() {
        return this.environment;
    }

    @Override
    public void setEnvironment(Map<String, Object> environment) {
        this.environment = environment;
    }

    @Override
    public void initialize() throws PipelineException {
        for (Valve valve : this.valves) {
            valve.initialize();
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Valve[] getValves() {
        Valve[] results = new Valve[this.valves.length];
        System.arraycopy(this.valves, 0, results, 0, this.valves.length);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValves(Valve[] valves) {
        Object object = valvesLock;
        synchronized (object) {
            this.valves = valves;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addValve(Valve valve) {
        Object object = valvesLock;
        synchronized (object) {
            Valve[] results = new Valve[this.valves.length + 1];
            System.arraycopy(this.valves, 0, results, 0, this.valves.length);
            results[this.valves.length] = valve;
            this.valves = results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValve(int position, Valve valve) {
        Object object = valvesLock;
        synchronized (object) {
            Valve[] results = new Valve[this.valves.length + 1];
            if (position == -1 || position >= this.valves.length) {
                System.arraycopy(this.valves, 0, results, 0, this.valves.length);
                results[this.valves.length] = valve;
            } else {
                results = (Valve[])ArrayUtils.add((Object[])this.valves, (int)position, (Object)valve);
            }
            this.valves = results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeValve(Valve valve) {
        Object object = valvesLock;
        synchronized (object) {
            int index = -1;
            for (int i = 0; i < this.valves.length; ++i) {
                if (!valve.equals(this.valves[i])) continue;
                index = i;
                break;
            }
            if (index < 0) {
                return;
            }
            Valve[] results = new Valve[this.valves.length - 1];
            int n = 0;
            for (int i = 0; i < this.valves.length; ++i) {
                if (i == index) continue;
                results[n++] = this.valves[i];
            }
            this.valves = results;
        }
    }

    @Override
    public void invoke(Object context) throws PipelineException {
        this.state.set(0);
        this.invokeNext(context);
    }

    @Override
    public void invokeNext(Object context) throws PipelineException {
        int valvePos = this.state.get();
        if (valvePos < this.valves.length) {
            this.state.set(valvePos + 1);
            this.valves[valvePos].invoke(context, this);
        }
    }

    @Override
    public boolean hasValveOfClass(Class<Valve> c) {
        return this.getFirstValveOfClass(c) != null;
    }

    @Override
    public Valve getFirstValveOfClass(Class<Valve> c) {
        for (Valve valve : this.valves) {
            if (!c.isInstance(valve)) continue;
            return valve;
        }
        return null;
    }

    public int indexOf(Valve valve) {
        return ArrayUtils.indexOf((Object[])this.valves, (Object)valve);
    }
}

