/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class SpringContextSingleton
implements ApplicationContextAware,
ApplicationListener<JahiaTemplateManagerService.TemplatePackageRedeployedEvent> {
    private static transient Logger logger = LoggerFactory.getLogger(SpringContextSingleton.class);
    private static SpringContextSingleton ourInstance = new SpringContextSingleton();
    private Map<String, Resource[]> resourcesCache = new HashMap<String, Resource[]>(2);
    private ApplicationContext context;
    private boolean initialized;

    public static Object getBean(String beanId) {
        try {
            return SpringContextSingleton.getInstance().getContext().getBean(beanId);
        }
        catch (BeansException e) {
            return SpringContextSingleton.getBeanInModulesContext(beanId);
        }
    }

    public static Object getBeanInModulesContext(String beanId) {
        for (JahiaTemplatesPackage aPackage : ServicesRegistry.getInstance().getJahiaTemplateManagerService().getAvailableTemplatePackages()) {
            if (aPackage.getContext() == null || !aPackage.getContext().containsBean(beanId)) continue;
            return aPackage.getContext().getBean(beanId);
        }
        throw new NoSuchBeanDefinitionException(beanId);
    }

    public static SpringContextSingleton getInstance() {
        return ourInstance;
    }

    private SpringContextSingleton() {
    }

    public ApplicationContext getContext() {
        if (!this.initialized) {
            logger.warn("Trying to access Spring context before it is available ! Please refactor code to avoid this !");
        }
        return this.context;
    }

    public void publishEvent(ApplicationEvent event) {
        this.publishEvent(event, true);
    }

    public void publishEvent(ApplicationEvent event, boolean propagateToModules) {
        this.getContext().publishEvent(event);
        for (JahiaTemplatesPackage aPackage : ServicesRegistry.getInstance().getJahiaTemplateManagerService().getAvailableTemplatePackages()) {
            if (aPackage.getContext() == null) continue;
            this.multicastEvent(event, aPackage.getContext());
        }
    }

    private void multicastEvent(ApplicationEvent event, AbstractApplicationContext ctx) {
        if (!ctx.isActive()) {
            return;
        }
        if (ctx.containsBean("applicationEventMulticaster")) {
            ((ApplicationEventMulticaster)ctx.getBean("applicationEventMulticaster")).multicastEvent(event);
        } else {
            ctx.publishEvent(event);
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void onApplicationEvent(JahiaTemplateManagerService.TemplatePackageRedeployedEvent event) {
        this.resourcesCache.clear();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
        this.initialized = true;
    }

    public Resource[] getResources(String locationPatterns) throws IOException {
        return this.getResources(locationPatterns, true);
    }

    public Resource[] getResources(String locationPatterns, boolean useCache) throws IOException {
        Object[] allResources;
        Object[] objectArray = allResources = useCache ? this.resourcesCache.get(locationPatterns) : null;
        if (allResources == null) {
            allResources = new Resource[]{};
            for (String location : StringUtils.tokenizeToStringArray((String)locationPatterns, (String)",; \t\n")) {
                try {
                    allResources = (Resource[])ArrayUtils.addAll((Object[])allResources, (Object[])this.context.getResources(location.trim()));
                }
                catch (FileNotFoundException e) {
                    logger.debug("Cannot find resources", (Throwable)e);
                }
            }
            if (useCache) {
                this.resourcesCache.put(locationPatterns, (Resource[])allResources);
            }
        }
        return allResources;
    }
}

