/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.applications.pluto;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.driver.PlutoServices;
import org.apache.pluto.container.driver.PortletRegistryService;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.driver.core.PortalRequestContext;
import org.apache.pluto.driver.core.PortletWindowImpl;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.apache.pluto.driver.url.PortalURL;
import org.jahia.data.applications.ApplicationBean;
import org.jahia.data.applications.EntryPointDefinition;
import org.jahia.data.applications.EntryPointInstance;
import org.jahia.data.applications.PortletEntryPointDefinition;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.services.applications.ApplicationsManagerProvider;
import org.jahia.services.applications.pluto.JahiaContextRequest;
import org.jahia.services.usermanager.JahiaUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationsManagerPlutoProvider
implements ApplicationsManagerProvider {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationsManagerPlutoProvider.class);

    @Override
    public EntryPointInstance createEntryPointInstance(EntryPointDefinition entryPointDefinition) throws JahiaException {
        EntryPointInstance instance = new EntryPointInstance(null, entryPointDefinition.getContext(), entryPointDefinition.getName());
        if (entryPointDefinition instanceof PortletEntryPointDefinition) {
            PortletEntryPointDefinition portletEntryPointDefinition = (PortletEntryPointDefinition)entryPointDefinition;
            instance.setExpirationTime(portletEntryPointDefinition.getExpirationCache());
            instance.setCacheScope(portletEntryPointDefinition.getCacheScope());
        }
        return instance;
    }

    @Override
    public PortletWindow getPortletWindow(EntryPointInstance entryPointInstance, String windowID, JahiaUser jahiaUser, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServletContext servletContext, String workspaceName) throws JahiaException {
        JahiaContextRequest jahiaContextRequest = new JahiaContextRequest(jahiaUser, httpServletRequest, workspaceName);
        new PortalRequestContext(servletContext, (HttpServletRequest)jahiaContextRequest, httpServletResponse);
        PortletWindowConfig windowConfig = PortletWindowConfig.fromId((String)(entryPointInstance.getContextName() + "." + entryPointInstance.getDefName() + "!" + windowID));
        windowConfig.setContextPath(entryPointInstance.getContextName());
        PortalRequestContext portalEnv = PortalRequestContext.getContext((HttpServletRequest)jahiaContextRequest);
        PortalURL portalURL = portalEnv.getRequestedPortalURL();
        PortletWindowImpl window = new PortletWindowImpl(null, windowConfig, portalURL);
        return window;
    }

    @Override
    public List<EntryPointDefinition> getAppEntryPointDefinitions(ApplicationBean appBean) throws JahiaException {
        PortletRegistryService portletRegistryService = PlutoServices.getServices().getPortletRegistryService();
        ArrayList<EntryPointDefinition> result = new ArrayList<EntryPointDefinition>();
        try {
            List portletList = portletRegistryService.getPortletApplication(appBean.getContext()).getPortlets();
            for (PortletDefinition portlet : portletList) {
                PortletEntryPointDefinition portletEntryPointDefinition = new PortletEntryPointDefinition(appBean.getID(), appBean.getContext(), portlet);
                result.add(portletEntryPointDefinition);
            }
        }
        catch (PortletContainerException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    public void start() throws JahiaInitializationException {
    }

    @Override
    public void stop() {
    }
}

