/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.applications.pluto;

import javax.jcr.RepositoryException;
import org.jahia.data.applications.EntryPointInstance;
import org.jahia.services.content.decorator.JCRPortletNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletWindowConfig {
    private static final Logger logger = LoggerFactory.getLogger(PortletWindowConfig.class);

    public static String fromId(EntryPointInstance entryPointInstance) {
        String defName = entryPointInstance.getDefName();
        String windowID = entryPointInstance.getID();
        return (defName.startsWith(".") ? "/" : "") + defName + "!" + windowID;
    }

    public static String fromId(JCRPortletNode nodeWrapper) {
        try {
            EntryPointInstance entryPointInstance = new EntryPointInstance(nodeWrapper.getUUID(), nodeWrapper.getContextName(), nodeWrapper.getDefinitionName(), nodeWrapper.getName());
            return PortletWindowConfig.fromId(entryPointInstance);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

