/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.atmosphere.rules;

import org.drools.core.spi.KnowledgeHelper;
import org.jahia.services.atmosphere.service.PublisherSubscriberService;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.rules.AddedNodeFact;

public class SitePublisherSubscriberRuleService {
    private PublisherSubscriberService publisherSubscriberService;

    public void setPublisherSubscriberService(PublisherSubscriberService publisherSubscriberService) {
        this.publisherSubscriberService = publisherSubscriberService;
    }

    public void sendSiteMessage(AddedNodeFact nodeFact, Object[] params, KnowledgeHelper drools) {
        this.publisherSubscriberService.publishToSite(nodeFact.getNode(), params[0].toString());
    }

    public void sendAbsoluteMessage(String absolute, Object[] params, KnowledgeHelper drools) {
        this.publisherSubscriberService.publishToAbsoluteChannel(absolute, params[0].toString());
    }

    public void sendNodeMessage(AddedNodeFact nodeFact, Object[] params, KnowledgeHelper drools) {
        JCRNodeWrapper parentOfType = JCRContentUtils.getParentOfType(nodeFact.getNode(), "jnt:page");
        if (parentOfType != null) {
            this.publisherSubscriberService.publishToNodeChannel(parentOfType, params[0].toString());
        }
    }
}

