/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.cache;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;

public class GroupCacheKey
implements Serializable,
Comparable<GroupCacheKey> {
    private static final long serialVersionUID = 9006071384859530347L;
    private static String groupSeparator = "#$#G_";
    private static String keyGroupSeparator = "$$$";
    private final Object key;
    private final Set<String> groups;

    public GroupCacheKey(Set<String> groups) {
        this.key = groups.toString();
        this.groups = groups;
    }

    public GroupCacheKey(Object key, Set<String> groups) {
        this.key = key;
        this.groups = groups;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public String[] getGroupArray() {
        return this.groups.toArray(new String[this.groups.size()]);
    }

    public boolean containsGroup(Object group) {
        return this.groups.contains(group);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GroupCacheKey)) {
            return false;
        }
        GroupCacheKey groupCacheKey = (GroupCacheKey)o;
        return this.key.equals(groupCacheKey.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.groups.size() * 5);
        result.append(this.key);
        result.append(keyGroupSeparator);
        result.append(groupSeparator);
        Iterator<String> keyIter = this.groups.iterator();
        while (keyIter.hasNext()) {
            result.append(keyIter.next());
            if (!keyIter.hasNext()) continue;
            result.append(groupSeparator);
        }
        return result.toString();
    }

    @Override
    public int compareTo(GroupCacheKey otherKey) {
        return this.toString().compareTo(otherKey.toString());
    }

    public static String getKeyGroupSeparator() {
        return keyGroupSeparator;
    }

    public static void setKeyGroupSeparator(String keyGroupSeparator) {
        GroupCacheKey.keyGroupSeparator = keyGroupSeparator;
    }

    public static String getGroupSeparator() {
        return groupSeparator;
    }

    public static void setGroupSeparator(String groupSeparator) {
        GroupCacheKey.groupSeparator = groupSeparator;
    }

    public Object getKey() {
        return this.key;
    }
}

