/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.channels.filters;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.channels.Channel;
import org.jahia.services.channels.ChannelService;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.URLGenerator;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelPreviewFilter
extends AbstractFilter {
    private static Logger logger = LoggerFactory.getLogger(ChannelPreviewFilter.class);
    public static final String ACTIVE_VARIANT_QUERY_PARAMETER = "variant";
    private ChannelService channelService;

    @Override
    public String prepare(RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        if (StringUtils.isEmpty((String)renderContext.getRequest().getParameter("channel")) || renderContext.getRequest().getParameter("noembed") != null) {
            return null;
        }
        Channel channel = this.channelService.getChannel(renderContext.getRequest().getParameter("channel"));
        if (channel.isGeneric()) {
            return null;
        }
        Map<String, String> capabilities = channel.getCapabilities();
        if (capabilities != null && capabilities.containsKey("variants") && capabilities.containsKey("decorator-image-sizes") && capabilities.containsKey("decorator-images") && capabilities.containsKey("decorator-screen-positions") && capabilities.containsKey("usable-resolutions")) {
            String[] variants = capabilities.get("variants").split(",");
            String variant = renderContext.getRequest().getParameter(ACTIVE_VARIANT_QUERY_PARAMETER);
            int variantIndex = 0;
            for (int i = 0; i < variants.length; ++i) {
                if (!variants[i].equals(variant)) continue;
                variantIndex = i;
                break;
            }
            String[] imageSize = capabilities.get("decorator-image-sizes").split(",")[variantIndex].split("x");
            String imageUrl = renderContext.getRequest().getContextPath() + capabilities.get("decorator-images").split(",")[variantIndex];
            String[] position = capabilities.get("decorator-screen-positions").split(",")[variantIndex].split("x");
            String[] dimension = capabilities.get("usable-resolutions").split(",")[variantIndex].split("x");
            String start = "<div style=\"width:" + imageSize[0] + "px; height:" + imageSize[1] + "px;";
            start = start + " background-image:url(" + imageUrl + "); background-repeat:no-repeat;\">\n";
            start = start + "<div style=\"position:absolute; left:" + (Integer.parseInt(position[0]) + 8) + "px; top:" + (Integer.parseInt(position[1]) + 7) + "px;";
            String url = renderContext.getRequest().getContextPath();
            url = url + new URLGenerator(renderContext, resource).getCurrent();
            url = url + "?";
            if (renderContext.getRequest().getQueryString() != null) {
                url = url + renderContext.getRequest().getQueryString();
                url = url + "&";
            }
            url = url + "channel=" + channel.getIdentifier() + "&noembed=true&variant=" + variant;
            start = start + " width:" + (Integer.parseInt(dimension[0]) + 15) + "px; height:" + dimension[1] + "px; overflow:hidden;\">" + "<div>\n" + "<iframe height=\"" + dimension[1] + "\" width=\"" + dimension[0] + "\" src=\"" + url + "\"" + " frameborder=\"0\" />\n" + "</div>\n";
            return start;
        }
        return null;
    }

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }
}

