/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.channels.filters;

import java.util.ArrayList;
import javax.servlet.http.Cookie;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.channels.Channel;
import org.jahia.services.channels.ChannelService;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelResolutionFilter
extends AbstractFilter {
    private static Logger logger = LoggerFactory.getLogger(ChannelResolutionFilter.class);
    public static final String ACTIVE_CHANNEL_COOKIE_NAME = "org.jahia.channels.activeChannel";
    public static final String ACTIVE_CHANNEL_QUERY_PARAMETER = "channel";
    private ChannelService channelService;

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    @Override
    public String prepare(RenderContext context, Resource resource, RenderChain chain) throws Exception {
        Cookie[] cookies = context.getRequest().getCookies();
        if (context.getChannel() != null) {
            return null;
        }
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                Channel resolvedChannel;
                if (!ACTIVE_CHANNEL_COOKIE_NAME.equals(cookie.getName()) || (resolvedChannel = this.channelService.getChannel(cookie.getValue())) == null) continue;
                context.setChannel(resolvedChannel);
                return null;
            }
        }
        if (!StringUtils.isEmpty((String)context.getRequest().getParameter(ACTIVE_CHANNEL_QUERY_PARAMETER))) {
            String activeChannel = context.getRequest().getParameter(ACTIVE_CHANNEL_QUERY_PARAMETER);
            Channel resolvedChannel = this.channelService.getChannel(activeChannel);
            if (resolvedChannel != null) {
                context.setChannel(resolvedChannel);
            } else {
                context.setChannel(this.channelService.getChannel("generic"));
            }
        }
        if (context.getChannel() == null) {
            Channel resolvedChannel = this.channelService.resolveChannel(context.getRequest());
            if (resolvedChannel != null) {
                context.setChannel(resolvedChannel);
                ArrayList<String> l = (ArrayList<String>)context.getRequest().getAttribute("module.cache.additional.key");
                if (l == null) {
                    l = new ArrayList<String>();
                    context.getRequest().setAttribute("module.cache.additional.key", l);
                }
                l.add(resolvedChannel.getIdentifier());
            } else {
                context.setChannel(this.channelService.getChannel("generic"));
            }
        }
        return null;
    }
}

