/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.channels.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.jahia.services.channels.Channel;
import org.jahia.services.channels.ChannelProvider;
import org.jahia.services.channels.ChannelService;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;

public class UserAgentChannelProvider
implements ChannelProvider,
InitializingBean,
BeanNameAware {
    public static final String USER_AGENT_HEADER_NAME = "user-agent";
    private int priority;
    private String beanName;
    private Map<String, Channel> channels = new HashMap<String, Channel>();
    private Map<Pattern, Channel> userAgentChannels = new HashMap<Pattern, Channel>();
    List<Channel> channelList = new ArrayList<Channel>();
    private ChannelService channelService;

    public void setChannelList(List<Channel> channelList) {
        this.channelList = channelList;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    public void afterPropertiesSet() throws Exception {
        for (Channel channel : this.channelList) {
            this.channels.put(channel.getIdentifier(), channel);
            if (!channel.hasCapabilityValue("userAgentPattern")) continue;
            Pattern curPattern = Pattern.compile(channel.getCapability("userAgentPattern"));
            this.userAgentChannels.put(curPattern, channel);
        }
        this.channelService.addProvider(this);
    }

    @Override
    public Map<String, String> getChannelCapabilities(String identifier) {
        if (this.channels.containsKey(identifier)) {
            return this.channels.get(identifier).getCapabilities();
        }
        return null;
    }

    @Override
    public String resolveChannel(HttpServletRequest request) {
        String userAgent = request.getHeader(USER_AGENT_HEADER_NAME);
        if (userAgent != null) {
            for (Map.Entry<Pattern, Channel> entry : this.userAgentChannels.entrySet()) {
                Pattern curPattern = entry.getKey();
                Matcher m = curPattern.matcher(userAgent);
                if (!m.matches()) continue;
                return entry.getValue().getIdentifier();
            }
        }
        return null;
    }

    @Override
    public List<String> getAllChannels() {
        return Collections.unmodifiableList(new ArrayList<String>(this.channels.keySet()));
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    @Override
    public String getFallBack(String identifier) {
        return this.channels.get(identifier).getFallBack();
    }

    @Override
    public boolean isVisible(String identifier) {
        return this.channels.get(identifier).isVisible();
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (!(obj instanceof UserAgentChannelProvider)) {
            return false;
        }
        return ((UserAgentChannelProvider)obj).getBeanName().equals(this.beanName);
    }

    public int hashCode() {
        return this.beanName != null ? this.beanName.hashCode() : 0;
    }
}

