/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRNodePropertiesELResolver
extends ELResolver {
    private static transient Logger logger = LoggerFactory.getLogger(JCRNodePropertiesELResolver.class);

    public Object getValue(ELContext elContext, Object base, Object property) {
        if (elContext == null) {
            throw new NullPointerException();
        }
        if (base != null && base instanceof JCRNodeWrapper) {
            JCRNodeWrapper nodeWrapper = (JCRNodeWrapper)base;
            try {
                try {
                    nodeWrapper.getClass().getMethod("get" + StringUtils.capitalize((String)property.toString()), new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    JCRPropertyWrapper jcrPropertyWrapper = nodeWrapper.getProperty(Patterns.UNDERSCORE.matcher(property.toString()).replaceAll(":"));
                    if (jcrPropertyWrapper != null) {
                        elContext.setPropertyResolved(true);
                        return jcrPropertyWrapper;
                    }
                }
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public Class<?> getType(ELContext elContext, Object base, Object property) {
        if (elContext == null) {
            throw new NullPointerException();
        }
        if (base != null && base instanceof JCRNodeWrapper) {
            JCRNodeWrapper nodeWrapper = (JCRNodeWrapper)base;
            try {
                try {
                    nodeWrapper.getClass().getMethod("get" + StringUtils.capitalize((String)property.toString()), new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    if (nodeWrapper.getProperty(Patterns.UNDERSCORE.matcher(property.toString()).replaceAll(":")) != null) {
                        elContext.setPropertyResolved(true);
                        return JCRPropertyWrapper.class;
                    }
                }
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public void setValue(ELContext elContext, Object base, Object property, Object value) {
    }

    public boolean isReadOnly(ELContext elContext, Object base, Object property) {
        return true;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext elContext, Object base) {
        if (elContext == null) {
            throw new NullPointerException();
        }
        if (base != null && base instanceof JCRNodeWrapper) {
            JCRNodeWrapper nodeWrapper = (JCRNodeWrapper)base;
            ArrayList<FeatureDescriptor> descriptors = new ArrayList<FeatureDescriptor>();
            try {
                Set<String> propertyNames = nodeWrapper.getPropertiesAsString().keySet();
                for (String propertyName : propertyNames) {
                    FeatureDescriptor descriptor = new FeatureDescriptor();
                    descriptor.setDisplayName(propertyName);
                    descriptor.setName(propertyName);
                    descriptor.setShortDescription("");
                    descriptor.setExpert(false);
                    descriptor.setHidden(false);
                    descriptor.setPreferred(true);
                    descriptor.setValue("type", String.class);
                    descriptors.add(descriptor);
                }
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            return descriptors.iterator();
        }
        return null;
    }

    public Class<?> getCommonPropertyType(ELContext elContext, Object base) {
        return String.class;
    }
}

