/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.ArrayList;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.apache.jackrabbit.core.observation.EventImpl;
import org.apache.jackrabbit.core.observation.SynchronousEventListener;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRObservationManager;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.JCRTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRObservationManagerDispatcher
implements SynchronousEventListener {
    private static final Logger logger = LoggerFactory.getLogger(JCRObservationManagerDispatcher.class);
    private JCRStoreProvider provider;
    private String workspace;

    public void setProvider(JCRStoreProvider provider) {
        this.provider = provider;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public void onEvent(EventIterator events) {
        ArrayList<EventImpl> external = null;
        while (events.hasNext()) {
            EventImpl event = (EventImpl)events.next();
            if (!event.isExternal()) {
                JCRObservationManager.addEvent((Event)event);
                continue;
            }
            if (external == null) {
                external = new ArrayList<EventImpl>();
            }
            external.add(event);
        }
        if (external != null) {
            final ArrayList<EventImpl> fexternal = external;
            try {
                JCRTemplate.getInstance().doExecuteWithSystemSession(null, this.workspace, new JCRCallback<Object>(){

                    @Override
                    public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                        ArrayList<JCRObservationManager.EventWrapper> eventWrappers = new ArrayList<JCRObservationManager.EventWrapper>();
                        for (Event event : fexternal) {
                            eventWrappers.add(JCRObservationManager.getEventWrapper(event, session));
                        }
                        JCRObservationManager.consume(eventWrappers, session, 12, 12);
                        return null;
                    }
                });
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

