/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.ServletContext;
import org.apache.commons.collections.map.UnmodifiableMap;
import org.apache.jackrabbit.core.security.JahiaLoginModule;
import org.jahia.jaas.JahiaPrincipal;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.NamespaceRegistryWrapper;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.services.usermanager.jcr.JCRUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.web.context.ServletContextAware;

public class JCRSessionFactory
implements Repository,
ServletContextAware {
    private static final Comparator<String> invertedStringComparator = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            return s2.compareTo(s1);
        }
    };
    public static final String DEFAULT_PROVIDER_KEY = "default";
    private static transient Logger logger = LoggerFactory.getLogger(JCRSessionFactory.class);
    protected ThreadLocal<Map<String, Map<String, JCRSessionWrapper>>> userSession = new ThreadLocal();
    protected ThreadLocal<Map<String, Map<String, JCRSessionWrapper>>> systemSession = new ThreadLocal();
    private NamespaceRegistryWrapper namespaceRegistry;
    private Map<String, String> descriptors = new HashMap<String, String>();
    private JahiaUserManagerService userService;
    private Map<String, JCRStoreProvider> providers = new HashMap<String, JCRStoreProvider>();
    private List<JCRStoreProvider> providerList = new LinkedList<JCRStoreProvider>();
    private SortedMap<String, JCRStoreProvider> mountPoints;
    private String servletContextAttributeName;
    private ServletContext servletContext;
    private ThreadLocal<JahiaUser> currentUser = new ThreadLocal();
    private ThreadLocal<Locale> currentLocale = new ThreadLocal();
    private ThreadLocal<Locale> fallbackLocale = new ThreadLocal();
    private ThreadLocal<JahiaUser> currentAliasedUser = new ThreadLocal();
    private ThreadLocal<String> currentServletPath = new ThreadLocal();
    private ThreadLocal<Calendar> currentPreviewDate = new ThreadLocal();
    private LocalValidatorFactoryBean validatorFactoryBean;

    private JCRSessionFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        JCRSessionFactory jCRSessionFactory = this;
        synchronized (jCRSessionFactory) {
            this.mountPoints = new TreeMap<String, JCRStoreProvider>(invertedStringComparator);
        }
        this.namespaceRegistry = new NamespaceRegistryWrapper();
        if (this.servletContextAttributeName != null && this.servletContext != null) {
            this.servletContext.setAttribute(this.servletContextAttributeName, (Object)this);
        }
    }

    public void setServletContextAttributeName(String servletContextAttributeName) {
        this.servletContextAttributeName = servletContextAttributeName;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setDescriptors(Map<String, String> descriptors) {
        this.descriptors = descriptors;
    }

    public void setUserService(JahiaUserManagerService userService) {
        this.userService = userService;
    }

    public JCRSessionWrapper getCurrentUserSession() throws RepositoryException {
        return this.getCurrentUserSession(null);
    }

    public JCRSessionWrapper getCurrentUserSession(String workspace) throws RepositoryException {
        return this.getCurrentUserSession(workspace, null);
    }

    public JCRSessionWrapper getCurrentUserSession(String workspace, Locale locale) throws RepositoryException {
        return this.getCurrentUserSession(workspace, locale, locale != null ? this.getFallbackLocale() : null);
    }

    public JCRSessionWrapper getCurrentUserSession(String workspace, Locale locale, Locale fallbackLocale) throws RepositoryException {
        return this.getCurrentSession(workspace, locale, fallbackLocale, false);
    }

    public JCRSessionWrapper getCurrentSystemSession(String workspace, Locale locale, Locale fallbackLocale) throws RepositoryException {
        return this.getCurrentSession(workspace, locale, fallbackLocale, true);
    }

    public JCRSessionWrapper getCurrentSession(String workspace, Locale locale, Locale fallbackLocale, boolean system) throws RepositoryException {
        ThreadLocal<Map<String, Map<String, JCRSessionWrapper>>> sessionThreadLocal = system ? this.systemSession : this.userSession;
        Map<String, Map<String, JCRSessionWrapper>> smap = sessionThreadLocal.get();
        if (smap == null) {
            smap = new HashMap<String, Map<String, JCRSessionWrapper>>();
        }
        sessionThreadLocal.set(smap);
        if (!system && this.getCurrentUser() == null) {
            logger.error("Null thread user");
            throw new RepositoryException("Null thread user");
        }
        JahiaUser user = this.getCurrentUser();
        String username = system ? null : (JahiaUserManagerService.isGuest(user) ? " guest " : user.getUsername());
        Map<String, JCRSessionWrapper> wsMap = smap.get(username);
        if (wsMap == null) {
            wsMap = new HashMap<String, JCRSessionWrapper>();
            smap.put(username, wsMap);
        }
        if (workspace == null) {
            workspace = DEFAULT_PROVIDER_KEY;
        }
        String localeString = locale != null ? locale.toString() : DEFAULT_PROVIDER_KEY;
        String key = workspace + "-" + localeString + "-" + fallbackLocale;
        JCRSessionWrapper s = wsMap.get(key);
        if (s == null || !s.isLive()) {
            if (system) {
                s = this.login(JahiaLoginModule.getSystemCredentials(username), workspace, locale, fallbackLocale);
                wsMap.put(key, s);
            } else {
                if (!" guest ".equals(username)) {
                    s = this.login(JahiaLoginModule.getCredentials(username), workspace, locale, fallbackLocale);
                    if (!(user instanceof JCRUser)) {
                        ((JCRStoreProvider)this.mountPoints.get("/")).deployExternalUser(user);
                    }
                } else {
                    s = this.login(JahiaLoginModule.getGuestCredentials(), workspace, locale, fallbackLocale);
                }
                s.setCurrentUserSession(true);
                wsMap.put(key, s);
            }
        }
        return s;
    }

    protected JCRSessionWrapper getSystemSession() throws RepositoryException {
        return this.login(JahiaLoginModule.getSystemCredentials());
    }

    protected JCRSessionWrapper getSystemSession(String username) throws RepositoryException {
        return this.login(JahiaLoginModule.getSystemCredentials(username));
    }

    protected JCRSessionWrapper getSystemSession(String username, String workspace) throws RepositoryException {
        return this.login(JahiaLoginModule.getSystemCredentials(username), workspace);
    }

    protected JCRSessionWrapper getSystemSession(String username, String workspace, Locale locale) throws RepositoryException {
        return this.login(JahiaLoginModule.getSystemCredentials(username), workspace, locale, locale != null ? this.getFallbackLocale() : null);
    }

    protected JCRSessionWrapper getUserSession(String username, String workspace) throws RepositoryException {
        return this.login(JahiaLoginModule.getCredentials(username), workspace);
    }

    protected JCRSessionWrapper getUserSession(String username, String workspace, Locale locale) throws RepositoryException {
        return this.login(JahiaLoginModule.getCredentials(username), workspace, locale, locale != null ? this.getFallbackLocale() : null);
    }

    public String[] getDescriptorKeys() {
        return this.descriptors.keySet().toArray(new String[this.descriptors.size()]);
    }

    public String getDescriptor(String s) {
        return this.descriptors.get(s);
    }

    public Session findSameSession(JCRStoreProvider provider, String userID, String ws) throws RepositoryException {
        Session s;
        block1: {
            Map<String, Map<String, JCRSessionWrapper>> smap;
            s = null;
            if (this.userSession == null || (smap = this.userSession.get()) == null || !smap.containsKey(userID)) break block1;
            Map<String, JCRSessionWrapper> wsMap = smap.get(userID);
            for (String key : wsMap.keySet()) {
                if (key.startsWith(ws) && (s = wsMap.get(key).getProviderSession(provider, false)) != null) break;
            }
        }
        return s;
    }

    public JCRSessionWrapper login(Credentials credentials, String workspace) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.login(credentials, workspace, null, null);
    }

    private JCRSessionWrapper login(Credentials credentials, String workspace, Locale locale, Locale fallbackLocale) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        if (!(credentials instanceof SimpleCredentials)) {
            throw new LoginException("Only SimpleCredentials supported in this implementation");
        }
        final SimpleCredentials simpleCreds = (SimpleCredentials)credentials;
        JahiaLoginModule m = new JahiaLoginModule();
        Subject s = new Subject();
        HashMap sharedState = new HashMap();
        HashMap options = new HashMap();
        m.initialize(s, new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        ((NameCallback)callback).setName(simpleCreds.getUserID());
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        ((PasswordCallback)callback).setPassword(simpleCreds.getPassword());
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback);
                }
            }
        }, (Map)sharedState, (Map)options);
        try {
            JahiaLoginModule.Token t = JahiaLoginModule.getToken(simpleCreds.getUserID(), new String(simpleCreds.getPassword()));
            m.login();
            m.commit();
            credentials = JahiaLoginModule.getCredentials(simpleCreds.getUserID(), t != null ? t.deniedPath : null);
        }
        catch (javax.security.auth.login.LoginException e) {
            throw new LoginException((Throwable)e);
        }
        Set<JahiaPrincipal> p = s.getPrincipals(JahiaPrincipal.class);
        Iterator<JahiaPrincipal> i$ = p.iterator();
        if (i$.hasNext()) {
            JahiaPrincipal jahiaPrincipal = i$.next();
            JahiaUser user = null;
            if (!jahiaPrincipal.getName().startsWith(" system ")) {
                user = jahiaPrincipal.isGuest() ? this.userService.lookupUser("guest") : this.userService.lookupUser(jahiaPrincipal.getName());
            }
            return new JCRSessionWrapper(user, credentials, jahiaPrincipal.isSystem(), workspace, locale, this, fallbackLocale);
        }
        throw new LoginException("Can't login");
    }

    public JCRSessionWrapper login(Credentials credentials) throws LoginException, RepositoryException {
        return this.login(credentials, null);
    }

    public JCRSessionWrapper login(String workspace) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.login(JahiaLoginModule.getGuestCredentials(), workspace);
    }

    public JCRSessionWrapper login() throws LoginException, RepositoryException {
        return this.login(null, null);
    }

    public boolean isStandardDescriptor(String key) {
        return false;
    }

    public boolean isSingleValueDescriptor(String key) {
        return false;
    }

    public Value getDescriptorValue(String key) {
        return null;
    }

    public Value[] getDescriptorValues(String key) {
        return new Value[0];
    }

    public Map<String, JCRStoreProvider> getMountPoints() {
        return this.mountPoints;
    }

    public Map<String, JCRStoreProvider> getProviders() {
        return this.providers;
    }

    public JCRStoreProvider getDefaultProvider() {
        return this.getProviders().get(DEFAULT_PROVIDER_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProvider(JCRStoreProvider p) {
        String key = p.getKey();
        String mountPoint = p.getMountPoint();
        JCRSessionFactory jCRSessionFactory = this;
        synchronized (jCRSessionFactory) {
            for (JCRSessionWrapper wrapper : JCRSessionWrapper.getActiveSessionsObjects().values()) {
                try {
                    wrapper.removeFromCache(mountPoint);
                }
                catch (RepositoryException e) {
                    logger.warn("Cannot flush cache", (Throwable)e);
                }
            }
            ArrayList<JCRStoreProvider> newList = new ArrayList<JCRStoreProvider>(this.providerList);
            newList.add(p);
            Collections.sort(newList);
            this.providerList = Collections.unmodifiableList(newList);
            this.initProviders();
            if (mountPoint != null) {
                TreeMap<String, JCRStoreProvider> newMountPoints = new TreeMap<String, JCRStoreProvider>(this.mountPoints);
                newMountPoints.put(mountPoint, p);
                this.mountPoints = Collections.unmodifiableSortedMap(newMountPoints);
            }
        }
        logger.info("Added provider " + key + " at mount point " + mountPoint + " using implementation " + p.getClass().getName());
    }

    @Deprecated
    public void addProvider(String key, String mountPoint, JCRStoreProvider p) {
        this.addProvider(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProvider(String key) {
        JCRStoreProvider p = this.getProviders().get(key);
        if (p == null) {
            return;
        }
        JCRSessionFactory jCRSessionFactory = this;
        synchronized (jCRSessionFactory) {
            for (JCRSessionWrapper wrapper : JCRSessionWrapper.getActiveSessionsObjects().values()) {
                try {
                    wrapper.removeFromCache(p.getMountPoint());
                }
                catch (RepositoryException e) {
                    logger.warn("Cannot flush cache", (Throwable)e);
                }
            }
            ArrayList<JCRStoreProvider> newList = new ArrayList<JCRStoreProvider>(this.providerList);
            newList.remove(p);
            this.providerList = Collections.unmodifiableList(newList);
            this.initProviders();
            if (p.getMountPoint() != null) {
                TreeMap<String, JCRStoreProvider> newMountPoints = new TreeMap<String, JCRStoreProvider>(this.mountPoints);
                newMountPoints.remove(p.getMountPoint());
                this.mountPoints = Collections.unmodifiableSortedMap(newMountPoints);
            }
        }
        logger.info("Removed provider " + key + " at mount point " + p.getMountPoint() + " using implementation " + p.getClass().getName());
    }

    private void initProviders() {
        LinkedHashMap<String, JCRStoreProvider> providerMap = new LinkedHashMap<String, JCRStoreProvider>(this.providerList.size());
        for (JCRStoreProvider p : this.providerList) {
            providerMap.put(p.getKey(), p);
        }
        this.providers = UnmodifiableMap.decorate(providerMap);
    }

    public List<JCRStoreProvider> getProviderList() {
        return this.providerList;
    }

    public static JCRSessionFactory getInstance() {
        return Holder.INSTANCE;
    }

    public void closeAllSessions() {
        this.closeAllSessions(this.userSession);
        this.closeAllSessions(this.systemSession);
    }

    private void closeAllSessions(ThreadLocal<Map<String, Map<String, JCRSessionWrapper>>> mapThreadLocal) {
        Map<String, Map<String, JCRSessionWrapper>> smap = mapThreadLocal.get();
        if (smap != null) {
            for (Map<String, JCRSessionWrapper> wsMap : smap.values()) {
                for (JCRSessionWrapper s : wsMap.values()) {
                    if (!s.isLive()) continue;
                    s.logout();
                }
            }
            this.userSession.set(null);
        }
    }

    public JCRStoreProvider getProvider(String path) {
        Map<String, JCRStoreProvider> currentMountPoints = this.getMountPoints();
        for (String mp : currentMountPoints.keySet()) {
            if (!mp.equals("/") && !path.equals(mp) && !path.startsWith(mp + "/")) continue;
            return currentMountPoints.get(mp);
        }
        return null;
    }

    public boolean unmount(JCRStoreProvider p) {
        if (p != null && p.isDynamicallyMounted()) {
            p.stop();
            return true;
        }
        return false;
    }

    public NamespaceRegistry getNamespaceRegistry() throws RepositoryException {
        return this.namespaceRegistry;
    }

    public JahiaUser getCurrentUser() {
        return this.currentUser.get();
    }

    public void setCurrentUser(JahiaUser user) {
        this.currentUser.set(user);
    }

    public Locale getCurrentLocale() {
        return this.currentLocale.get();
    }

    public void setCurrentLocale(Locale locale) {
        this.currentLocale.set(locale);
    }

    public Locale getFallbackLocale() {
        return this.fallbackLocale.get();
    }

    public void setFallbackLocale(Locale locale) {
        this.fallbackLocale.set(locale);
    }

    public JahiaUser getCurrentAliasedUser() {
        return this.currentAliasedUser.get();
    }

    public void setCurrentAliasedUser(JahiaUser user) {
        this.currentAliasedUser.set(user);
    }

    public String getCurrentServletPath() {
        return this.currentServletPath.get();
    }

    public void setCurrentServletPath(String path) {
        this.currentServletPath.set(path);
    }

    public void setCurrentPreviewDate(Calendar previewDate) {
        this.currentPreviewDate.set(previewDate);
    }

    public Calendar getCurrentPreviewDate() {
        return this.currentPreviewDate.get();
    }

    public LocalValidatorFactoryBean getValidatorFactoryBean() {
        return this.validatorFactoryBean;
    }

    public void setValidatorFactoryBean(LocalValidatorFactoryBean validatorFactoryBean) {
        this.validatorFactoryBean = validatorFactoryBean;
    }

    private static class Holder {
        static final JCRSessionFactory INSTANCE = new JCRSessionFactory();

        private Holder() {
        }
    }
}

