/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.rmi.Naming;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.servlet.ServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.query.JahiaQueryObjectModelImpl;
import org.apache.jackrabbit.core.query.lucene.JahiaLuceneQueryFactoryImpl;
import org.apache.jackrabbit.core.security.JahiaLoginModule;
import org.apache.jackrabbit.core.security.JahiaPrivilegeRegistry;
import org.apache.jackrabbit.rmi.server.ServerAdapterFactory;
import org.apache.jackrabbit.util.ISO9075;
import org.jahia.bin.Jahia;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRItemWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRNodeWrapperImpl;
import org.jahia.services.content.JCRObservationManagerDispatcher;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRPropertyWrapperImpl;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreService;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRFrozenNodeAsRegular;
import org.jahia.services.content.decorator.JCRMountPointNode;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.JahiaCndWriter;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.content.nodetypes.NodeTypesDBServiceImpl;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.services.usermanager.JahiaGroup;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.services.usermanager.jcr.JCRGroupManagerProvider;
import org.jahia.settings.SettingsBean;
import org.jahia.tools.patches.GroovyPatcher;
import org.jahia.utils.LuceneUtils;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class JCRStoreProvider
implements Comparable<JCRStoreProvider> {
    private static Logger logger = LoggerFactory.getLogger(JCRStoreProvider.class);
    private static String httpPath;
    private boolean defaultProvider;
    private String key;
    private String mountPoint;
    private String webdavPath;
    private String relativeRoot = "";
    private String repositoryName;
    private String factory;
    private String url;
    protected String systemUser;
    protected String systemPassword;
    protected String guestUser;
    protected String guestPassword;
    protected String authenticationType = null;
    protected String rmibind;
    private JahiaUserManagerService userManagerService;
    private JahiaGroupManagerService groupManagerService;
    private JahiaSitesService sitesService;
    private JCRStoreService service;
    protected JCRSessionFactory sessionFactory;
    protected volatile Repository repo = null;
    private boolean mainStorage = false;
    private boolean isDynamicallyMounted = false;
    private boolean initialized = false;
    private boolean providesDynamicMountPoints;
    private Boolean versioningAvailable = null;
    private Boolean lockingAvailable = null;
    private Boolean searchAvailable = null;
    private Boolean updateMixinAvailable = null;
    private Boolean slowConnection = false;
    private final Object syncRepoInit = new Object();
    private GroovyPatcher groovyPatcher;
    private NodeTypesDBServiceImpl nodeTypesDBService;

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getMountPoint() {
        return this.mountPoint;
    }

    public void setMountPoint(String mountPoint) {
        this.mountPoint = mountPoint;
        this.defaultProvider = "/".equals(mountPoint);
    }

    public String getWebdavPath() {
        return this.webdavPath;
    }

    public String getRelativeRoot() {
        return this.relativeRoot;
    }

    public void setRelativeRoot(String relativeRoot) {
        this.relativeRoot = relativeRoot;
    }

    public int getDepth() {
        if (this.defaultProvider) {
            return 0;
        }
        return Patterns.SLASH.split(this.mountPoint).length - 1;
    }

    public void setWebdavPath(String webdavPath) {
        this.webdavPath = webdavPath;
    }

    public String getHttpPath() {
        if (httpPath == null) {
            httpPath = Jahia.getContextPath() + "/files";
        }
        return httpPath;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getFactory() {
        return this.factory;
    }

    public void setFactory(String factory) {
        this.factory = factory;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setSystemUser(String user) {
        this.systemUser = user;
        if (this.authenticationType == null) {
            this.authenticationType = "shared";
        }
    }

    public void setSystemPassword(String password) {
        this.systemPassword = password;
    }

    public void setGuestUser(String user) {
        this.guestUser = user;
    }

    public void setGuestPassword(String password) {
        this.guestPassword = password;
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
    }

    public String getRmibind() {
        return this.rmibind;
    }

    public void setRmibind(String rmibind) {
        this.rmibind = rmibind;
    }

    public JahiaUserManagerService getUserManagerService() {
        return this.userManagerService;
    }

    public void setUserManagerService(JahiaUserManagerService userManagerService) {
        this.userManagerService = userManagerService;
    }

    public JahiaGroupManagerService getGroupManagerService() {
        return this.groupManagerService;
    }

    public void setGroupManagerService(JahiaGroupManagerService groupManagerService) {
        this.groupManagerService = groupManagerService;
    }

    public JahiaSitesService getSitesService() {
        return this.sitesService;
    }

    public void setSitesService(JahiaSitesService sitesService) {
        this.sitesService = sitesService;
    }

    public JCRStoreService getService() {
        return this.service;
    }

    public void setService(JCRStoreService service) {
        this.service = service;
    }

    public JCRSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(JCRSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Deprecated
    public void setSessionKeepAliveCheckInterval(long sessionKeepAliveCheckInterval) {
    }

    public GroovyPatcher getGroovyPatcher() {
        return this.groovyPatcher;
    }

    public void setGroovyPatcher(GroovyPatcher groovyPatcher) {
        this.groovyPatcher = groovyPatcher;
    }

    public void start() throws JahiaInitializationException {
        try {
            String tmpAuthenticationType = this.authenticationType;
            this.authenticationType = "shared";
            this.getSessionFactory().addProvider(this);
            boolean isProcessingServer = SettingsBean.getInstance().isProcessingServer();
            if (isProcessingServer) {
                this.initNodeTypes();
            }
            this.initObservers();
            this.initialized = true;
            this.initContent();
            this.initDynamicMountPoints();
            this.authenticationType = tmpAuthenticationType;
            if (this.groovyPatcher != null && isProcessingServer) {
                this.groovyPatcher.executeScripts("jcrStoreProviderStarted");
            }
        }
        catch (Exception e) {
            logger.error("Repository init error", (Throwable)e);
            throw new JahiaInitializationException("Repository init error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initNodeTypes() throws RepositoryException, IOException {
        if (this.canRegisterCustomNodeTypes()) {
            Properties p = NodeTypeRegistry.getInstance().getDeploymentProperties();
            JCRSessionWrapper session = this.getSystemSession();
            try {
                Workspace workspace = session.getProviderSession(this).getWorkspace();
                workspace.getNodeTypeManager().getNodeType("jmix:droppableContent");
            }
            catch (RepositoryException e) {
            }
            finally {
                session.logout();
            }
            boolean needUpdate = false;
            List<String> systemIds = NodeTypeRegistry.getInstance().getSystemIds();
            for (String systemId : systemIds) {
                needUpdate |= this.deployDefinitions(systemId, p);
            }
            if (needUpdate) {
                NodeTypeRegistry.getInstance().saveProperties();
            }
        }
    }

    protected void initObservers() throws RepositoryException {
        Set<String> workspaces = this.service.getListeners().keySet();
        for (String ws : workspaces) {
            JCRSessionWrapper session = this.getSystemSession(null, ws);
            Workspace workspace = session.getProviderSession(this).getWorkspace();
            ObservationManager observationManager = workspace.getObservationManager();
            JCRObservationManagerDispatcher listener = new JCRObservationManagerDispatcher();
            listener.setWorkspace(workspace.getName());
            observationManager.addEventListener((EventListener)listener, 63, "/", true, null, null, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initContent() throws RepositoryException, IOException {
        if (this.defaultProvider) {
            JCRSessionWrapper session = this.service.getSessionFactory().getSystemSession();
            try {
                JCRNodeWrapper rootNode = session.getRootNode();
                if (!rootNode.hasNode("sites")) {
                    rootNode.addMixin("mix:referenceable");
                    JCRContentUtils.importSkeletons("WEB-INF/etc/repository/root.xml,WEB-INF/etc/repository/root-*.xml", "/", session, 3, null);
                    JahiaPrivilegeRegistry.init(session);
                    Node userNode = (Node)session.getItem("/users");
                    NodeIterator nodeIterator = userNode.getNodes();
                    while (nodeIterator.hasNext()) {
                        JCRNodeWrapper node = (JCRNodeWrapper)nodeIterator.next();
                        if ("guest".equals(node.getName())) continue;
                        node.grantRoles("u:" + node.getName(), Collections.singleton("owner"));
                    }
                    session.save();
                } else {
                    JahiaPrivilegeRegistry.init(session);
                }
            }
            finally {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDynamicMountPoints() {
        if (!this.providesDynamicMountPoints) {
            return;
        }
        JCRSessionWrapper session = null;
        try {
            session = this.sessionFactory.getSystemSession();
            List<JCRNodeWrapper> result = this.queryFolders(session, "select * from [jnt:mountPoint]");
            for (JCRNodeWrapper mountPointNode : result) {
                if (!(mountPointNode instanceof JCRMountPointNode)) continue;
                try {
                    if (((JCRMountPointNode)mountPointNode).checkValidity()) {
                        logger.info("Registered mount point: " + mountPointNode.getPath());
                        continue;
                    }
                    throw new RepositoryException("Couldn't mount dynamic mount point " + mountPointNode.getPath());
                }
                catch (Exception e) {
                    logger.error("Unable to register dynamic mount point for path " + mountPointNode.getPath(), (Throwable)e);
                }
            }
        }
        catch (RepositoryException e) {
            logger.error("Unable to register dynamic mount points", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public void stop() {
        this.getSessionFactory().removeProvider(this.key);
        this.rmiUnbind();
    }

    protected void rmiUnbind() {
        if (this.rmibind != null) {
            try {
                Naming.unbind(this.rmibind);
            }
            catch (Exception e) {
                logger.warn("Unable to unbind the JCR repository in RMI");
            }
        }
    }

    @Deprecated
    public boolean isRunning() {
        return false;
    }

    public void deployDefinitions(String systemId) {
        try {
            if (this.deployDefinitions(systemId, NodeTypeRegistry.getInstance().getDeploymentProperties())) {
                NodeTypeRegistry.getInstance().saveProperties();
            }
        }
        catch (IOException e) {
            logger.error("Cannot save definitions timestamps", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deployDefinitions(String systemId, Properties p) {
        List<Resource> files = NodeTypeRegistry.getInstance().getFiles(systemId);
        boolean needUpdate = false;
        for (Resource file : files) {
            try {
                String propKey = file.getURL().toString() + ".lastRegistered." + this.key;
                if (!file.exists() || p.getProperty(propKey) != null && Long.parseLong(p.getProperty(propKey)) == file.lastModified()) continue;
                if (!systemId.startsWith("system-")) {
                    try {
                        StringWriter out = new StringWriter();
                        new JahiaCndWriter(NodeTypeRegistry.getInstance().getNodeTypes(systemId), NodeTypeRegistry.getInstance().getNamespaces(), out);
                        this.nodeTypesDBService.saveCndFile(systemId + ".cnd", out.toString());
                        NodeTypeRegistry.deployDefinitionsFileToProviderNodeTypeRegistry(new StringReader(out.toString()), systemId + ".cnd");
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                needUpdate = true;
                p.setProperty(propKey, Long.toString(file.lastModified()));
            }
            catch (IOException e) {
                logger.error("Couldn't retrieve last modification date for file " + file + " will force updating !", (Throwable)e);
                needUpdate = true;
            }
        }
        if (needUpdate) {
            try {
                this.getRepository();
                JCRSessionWrapper session = this.sessionFactory.getSystemSession();
                try {
                    Workspace workspace = session.getProviderSession(this).getWorkspace();
                    try {
                        this.registerCustomNodeTypes(systemId, workspace);
                    }
                    catch (RepositoryException e) {
                        logger.error("Cannot register nodetypes", (Throwable)e);
                    }
                    session.save();
                }
                finally {
                    session.logout();
                }
            }
            catch (Exception e) {
                logger.error("Repository init error", (Throwable)e);
            }
        }
        return needUpdate;
    }

    public void undeployDefinitions(String systemId) {
        try {
            if (this.undeployDefinitions(systemId, NodeTypeRegistry.getInstance().getDeploymentProperties())) {
                NodeTypeRegistry.getInstance().saveProperties();
            }
        }
        catch (IOException e) {
            logger.error("Cannot save definitions timestamps", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean undeployDefinitions(String systemId, Properties p) {
        List<Resource> files = NodeTypeRegistry.getInstance().getFiles(systemId);
        boolean needUpdate = false;
        try {
            this.getRepository();
            JCRSessionWrapper session = this.sessionFactory.getSystemSession();
            try {
                Workspace workspace = session.getProviderSession(this).getWorkspace();
                try {
                    this.unregisterCustomNodeTypes(systemId, workspace);
                }
                catch (RepositoryException e) {
                    logger.error("Cannot register nodetypes", (Throwable)e);
                }
                session.save();
            }
            finally {
                session.logout();
            }
        }
        catch (Exception e) {
            logger.error("Repository init error", (Throwable)e);
        }
        if (files != null) {
            for (Resource file : files) {
                try {
                    String propKey = file.getURL().toString() + ".lastRegistered." + this.key;
                    p.remove(propKey);
                    try {
                        this.nodeTypesDBService.saveCndFile(systemId + ".cnd", null);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    needUpdate = true;
                    NodeTypeRegistry.getProviderNodeTypeRegistry().unregisterNodeTypes(systemId);
                }
                catch (IOException e) {
                    logger.error("Couldn't retrieve last modification date for file " + file + " will force updating !", (Throwable)e);
                    needUpdate = true;
                }
            }
        }
        return needUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository getRepository() {
        Repository result = this.repo;
        if (result == null) {
            JCRStoreProvider jCRStoreProvider = this;
            synchronized (jCRStoreProvider) {
                result = this.repo;
                if (result == null) {
                    this.repo = result = this.createRepository();
                    this.rmiBind();
                }
            }
        }
        return result;
    }

    protected void rmiBind() {
        if (this.rmibind != null && this.repo != null) {
            try {
                Naming.rebind(this.rmibind, (Remote)new ServerAdapterFactory().getRemoteRepository(this.repo));
            }
            catch (Exception e) {
                logger.warn("Unable to bind remote JCR repository to RMI using " + this.rmibind, (Throwable)e);
            }
        }
    }

    protected Repository createRepository() {
        Repository instance = null;
        if (this.repositoryName != null) {
            instance = this.getRepositoryByJNDI();
        } else if (this.factory != null && this.url != null) {
            instance = this.getRepositoryByRMI();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRepository(Repository repo) {
        Object object = this.syncRepoInit;
        synchronized (object) {
            this.repo = repo;
        }
    }

    protected Repository getRepositoryByJNDI() {
        Repository instance = null;
        try {
            Hashtable env = new Hashtable();
            InitialContext initctx = new InitialContext(env);
            instance = (Repository)initctx.lookup(this.repositoryName);
            logger.info("Repository {} acquired via JNDI", (Object)this.getKey());
        }
        catch (NamingException e) {
            logger.error("Cannot get by JNDI", (Throwable)e);
        }
        return instance;
    }

    protected Repository getRepositoryByRMI() {
        Repository instance = null;
        try {
            Class<ObjectFactory> factoryClass = Class.forName(this.factory).asSubclass(ObjectFactory.class);
            ObjectFactory factory = factoryClass.newInstance();
            instance = (Repository)factory.getObjectInstance(new Reference(Repository.class.getName(), new StringRefAddr("url", this.url)), null, null, null);
            logger.info("Repository {} acquired via RMI", (Object)this.getKey());
        }
        catch (Exception e) {
            logger.error("Cannot get by RMI", (Throwable)e);
        }
        return instance;
    }

    public Session getSession(Credentials credentials, String workspace) throws RepositoryException {
        if (credentials instanceof SimpleCredentials) {
            String username = ((SimpleCredentials)credentials).getUserID();
            if ("shared".equals(this.authenticationType)) {
                credentials = this.guestUser == null || username.startsWith(" system ") ? JahiaLoginModule.getSystemCredentials() : JahiaLoginModule.getGuestCredentials();
                username = ((SimpleCredentials)credentials).getUserID();
            }
            if (this.systemUser != null && username.startsWith(" system ")) {
                credentials = this.systemPassword != null ? new SimpleCredentials(this.systemUser, this.systemPassword.toCharArray()) : JahiaLoginModule.getCredentials(this.systemUser);
            } else if (this.guestUser != null && username.startsWith(" guest ")) {
                credentials = this.guestPassword != null ? new SimpleCredentials(this.guestUser, this.guestPassword.toCharArray()) : JahiaLoginModule.getCredentials(this.guestUser);
            } else if ("storedPasswords".equals(this.authenticationType)) {
                String pass;
                JahiaUser user = this.userManagerService.lookupUser(username);
                if (user.getProperty("storedUsername_" + this.getKey()) != null) {
                    username = user.getProperty("storedUsername_" + this.getKey());
                }
                credentials = (pass = user.getProperty("storedPassword_" + this.getKey())) != null ? new SimpleCredentials(username, pass.toCharArray()) : (this.guestPassword != null ? new SimpleCredentials(this.guestUser, this.guestPassword.toCharArray()) : JahiaLoginModule.getCredentials(this.guestUser));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Login for {} as {}", (Object)this.getKey(), (Object)((SimpleCredentials)credentials).getUserID());
            }
        }
        Session s = this.getRepository().login(credentials, workspace);
        return s;
    }

    public JCRItemWrapper getItemWrapper(Item item, JCRSessionWrapper session) throws RepositoryException {
        if (item.isNode()) {
            return this.getNodeWrapper((Node)item, session);
        }
        return this.getPropertyWrapper((Property)item, session);
    }

    public JCRNodeWrapper getNodeWrapper(Node objectNode, JCRSessionWrapper session) throws RepositoryException {
        return this.getNodeWrapper(objectNode, null, null, session);
    }

    public JCRNodeWrapper getNodeWrapper(final Node objectNode, String path, JCRNodeWrapper parent, JCRSessionWrapper session) throws RepositoryException {
        if (session.getUser() != null && this.sessionFactory.getCurrentAliasedUser() != null && !this.sessionFactory.getCurrentAliasedUser().equals(session.getUser())) {
            JCRTemplate.getInstance().doExecuteWithUserSession(this.sessionFactory.getCurrentAliasedUser().getUsername(), session.getWorkspace().getName(), session.getLocale(), new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    try {
                        return session.getNodeByUUID(objectNode.getIdentifier());
                    }
                    catch (ItemNotFoundException e) {
                        throw new PathNotFoundException();
                    }
                }
            });
        }
        return this.createWrapper(objectNode, path, parent, session);
    }

    private JCRNodeWrapper createWrapper(Node objectNode, String path, JCRNodeWrapper parent, JCRSessionWrapper session) throws RepositoryException {
        if (path == null || !path.contains("@/")) {
            JCRNodeWrapper wrapper;
            JCRNodeWrapper jCRNodeWrapper = wrapper = objectNode != null ? session.getCachedNode(objectNode.getIdentifier()) : null;
            if (wrapper != null) {
                return wrapper;
            }
        }
        JCRNodeWrapperImpl w = null;
        if (session.getVersionDate() != null || session.getVersionLabel() != null) {
            try {
                if (objectNode.isNodeType("nt:frozenNode")) {
                    w = new JCRFrozenNodeAsRegular(objectNode, path, parent, session, this, session.getVersionDate(), session.getVersionLabel());
                }
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (w == null) {
            w = new JCRNodeWrapperImpl(objectNode, path, parent, session, this);
        }
        if (objectNode.isNew() || w.checkValidity()) {
            return this.service.decorate(w);
        }
        throw new PathNotFoundException("This node doesn't exist in this language " + objectNode.getPath());
    }

    public JCRPropertyWrapper getPropertyWrapper(Property prop, JCRSessionWrapper session) throws RepositoryException {
        PropertyDefinition def = prop.getDefinition();
        if (def == null) {
            throw new RepositoryException("Couldn't retrieve property definition for property " + prop.getPath());
        }
        if (def.getDeclaringNodeType().isNodeType("jnt:translation")) {
            Node parent = prop.getParent();
            JCRNodeWrapper jcrNode = this.getNodeWrapper(parent.getParent(), session);
            String name = prop.getName();
            ExtendedPropertyDefinition epd = jcrNode.getApplicablePropertyDefinition(name);
            return new JCRPropertyWrapperImpl(this.getNodeWrapper(session.getLocale() != null ? prop.getParent().getParent() : prop.getParent(), null, null, session), prop, session, this, epd, name);
        }
        JCRNodeWrapper jcrNode = this.getNodeWrapper(prop.getParent(), session);
        ExtendedPropertyDefinition epd = jcrNode.getApplicablePropertyDefinition(prop.getName());
        return new JCRPropertyWrapperImpl(this.getNodeWrapper(prop.getParent(), null, null, session), prop, session, this, epd);
    }

    protected boolean canRegisterCustomNodeTypes() {
        return false;
    }

    protected void registerCustomNodeTypes(String systemId, Workspace ws) throws IOException, RepositoryException {
    }

    protected void unregisterCustomNodeTypes(String systemId, Workspace ws) throws IOException, RepositoryException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployExternalUser(JahiaUser jahiaUser) throws RepositoryException {
        String username = jahiaUser.getUsername();
        JCRSessionWrapper session = this.sessionFactory.getSystemSession(username, null);
        try {
            String[] jcrUsernamePath = Patterns.SLASH.split(StringUtils.substringAfter((String)jahiaUser.getLocalPath(), (String)"/"));
            try {
                JCRNodeWrapper startNode;
                JCRNodeWrapper usersFolderNode = startNode = session.getNode("/" + jcrUsernamePath[0]);
                int length = jcrUsernamePath.length;
                for (int i = 1; i < length; ++i) {
                    try {
                        startNode = startNode.getNode(jcrUsernamePath[i]);
                        continue;
                    }
                    catch (PathNotFoundException e) {
                        try {
                            if (i == length - 1) {
                                Node userNode = startNode.addNode(jcrUsernamePath[i], "jnt:user");
                                if (usersFolderNode.hasProperty("j:usersFolderSkeleton")) {
                                    String skeletons = usersFolderNode.getProperty("j:usersFolderSkeleton").getString();
                                    try {
                                        JCRContentUtils.importSkeletons(skeletons, startNode.getPath() + "/" + jcrUsernamePath[i], session, new HashMap<String, String>());
                                    }
                                    catch (Exception importEx) {
                                        logger.error("Unable to import data using user skeletons " + skeletons, (Throwable)importEx);
                                    }
                                }
                                userNode.setProperty("j:external", true);
                                userNode.setProperty("j:externalSource", jahiaUser.getProviderName());
                                ValueFactory valueFactory = session.getValueFactory();
                                ArrayList<Value> properties = new ArrayList<Value>();
                                for (Object o : jahiaUser.getProperties().keySet()) {
                                    properties.add(valueFactory.createValue((String)o));
                                }
                                userNode.setProperty("j:publicProperties", properties.toArray(new Value[properties.size()]));
                                ((JCRNodeWrapper)userNode).grantRoles("u:" + username, Collections.singleton("owner"));
                            } else {
                                startNode = startNode.addNode(jcrUsernamePath[i], "jnt:usersFolder");
                            }
                            session.save();
                            continue;
                        }
                        catch (RepositoryException e1) {
                            logger.error("Cannot save", (Throwable)e1);
                        }
                    }
                }
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
        }
        finally {
            session.logout();
        }
    }

    public void deployExternalGroup(JahiaGroup group) {
        Properties properties = new Properties();
        properties.put("j:external", Boolean.TRUE);
        properties.put("j:externalSource", group.getProviderName());
        JCRGroupManagerProvider groupManager = (JCRGroupManagerProvider)SpringContextSingleton.getInstance().getContext().getBean("JCRGroupManagerProvider");
        if (groupManager.lookupExternalGroup(group.getName()) == null) {
            this.groupManagerService.createGroup(null, group.getName(), properties, true);
        }
    }

    public JCRNodeWrapper getUserFolder(JahiaUser user) throws RepositoryException {
        String username = ISO9075.encode((String)user.getUsername());
        String sql = "select * from [jnt:user] as user where localname(user) = '" + username + "'";
        List<JCRNodeWrapper> results = this.queryFolders(this.sessionFactory.getCurrentUserSession(), sql);
        if (results.isEmpty()) {
            throw new ItemNotFoundException();
        }
        return results.get(0);
    }

    public List<JCRNodeWrapper> getImportDropBoxes(String site, JahiaUser user) throws RepositoryException {
        String username = ISO9075.encode((String)user.getUsername());
        String sql = "select imp.* from [jnt:importDropBox] as imp right outer join [jnt:user] as user on ischildnode(imp,user) where localname(user)= '" + username + "'";
        if (site != null) {
            site = ISO9075.encode((String)site);
            sql = "select imp.* from jnt:importDropBox as imp right outer join [jnt:user] as user on ischildnode(imp,user) right outer join [jnt:virtualsite] as site on isdescendantnode(imp,site) where localname(user)= '" + username + "' and localname(site) = '" + site + "'";
        }
        List<JCRNodeWrapper> results = this.queryFolders(this.sessionFactory.getCurrentUserSession(), sql);
        if (site != null) {
            results.addAll(this.getImportDropBoxes(null, user));
        }
        return results;
    }

    public JCRNodeWrapper getSiteFolder(String site) throws RepositoryException {
        site = ISO9075.encode((String)site);
        String xp = "select * from [jnt:virtualsite] as site where localname(site) = '" + site + "'";
        List<JCRNodeWrapper> list = this.queryFolders(this.sessionFactory.getCurrentUserSession(), xp);
        if (list.isEmpty()) {
            throw new ItemNotFoundException();
        }
        return list.get(0);
    }

    private List<JCRNodeWrapper> queryFolders(JCRSessionWrapper session, String sql) throws RepositoryException {
        ArrayList<JCRNodeWrapper> results = new ArrayList<JCRNodeWrapper>();
        QueryManager queryManager = session.getProviderSession(this).getWorkspace().getQueryManager();
        if (queryManager != null) {
            Query q = queryManager.createQuery(sql, "JCR-SQL2");
            if (q instanceof JahiaQueryObjectModelImpl) {
                JahiaLuceneQueryFactoryImpl lqf = (JahiaLuceneQueryFactoryImpl)((JahiaQueryObjectModelImpl)q).getLuceneQueryFactory();
                lqf.setQueryLanguageAndLocale(LuceneUtils.extractLanguageOrNullFromStatement(sql), session.getLocale());
            }
            QueryResult qr = q.execute();
            NodeIterator ni = qr.getNodes();
            while (ni.hasNext()) {
                Node folder = ni.nextNode();
                results.add(this.getNodeWrapper(folder, session));
            }
        }
        return results;
    }

    public String getAbsoluteContextPath(ServletRequest request) {
        StringBuilder serverUrlBuffer = new StringBuilder(request.getScheme());
        serverUrlBuffer.append("://");
        serverUrlBuffer.append(request.getServerName());
        if (request.getServerPort() != 80 && request.getServerPort() != 443) {
            serverUrlBuffer.append(":");
            serverUrlBuffer.append(request.getServerPort());
        }
        return serverUrlBuffer.toString();
    }

    public boolean isMainStorage() {
        return this.mainStorage;
    }

    public void setMainStorage(boolean mainStorage) {
        this.mainStorage = mainStorage;
    }

    public boolean isDynamicallyMounted() {
        return this.isDynamicallyMounted;
    }

    public void setDynamicallyMounted(boolean dynamicallyMounted) {
        this.isDynamicallyMounted = dynamicallyMounted;
    }

    public boolean isExportable() {
        return true;
    }

    public boolean isDefault() {
        return this.defaultProvider;
    }

    protected void dump(Node n) throws RepositoryException {
        System.out.println(n.getPath());
        PropertyIterator pit = n.getProperties();
        while (pit.hasNext()) {
            Property p = pit.nextProperty();
            System.out.print(p.getPath() + "=");
            if (p.getDefinition().isMultiple()) {
                Value[] values = p.getValues();
                for (int i = 0; i < values.length; ++i) {
                    Value value = values[i];
                    System.out.print(value + ",");
                }
                System.out.println("");
                continue;
            }
            System.out.println(p.getValue());
        }
        NodeIterator nit = n.getNodes();
        while (nit.hasNext()) {
            Node cn = nit.nextNode();
            if (cn.getName().startsWith("jcr:")) continue;
            this.dump(cn);
        }
    }

    public QueryManager getQueryManager(JCRSessionWrapper session) throws RepositoryException {
        return session.getProviderSession(this).getWorkspace().getQueryManager();
    }

    public JCRSessionWrapper getSystemSession() throws RepositoryException {
        return this.sessionFactory.getSystemSession();
    }

    public JCRSessionWrapper getSystemSession(String user, String workspace) throws RepositoryException {
        return this.sessionFactory.getSystemSession(user, workspace);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setProvidesDynamicMountPoints(boolean providesDynamicMountPoints) {
        this.providesDynamicMountPoints = providesDynamicMountPoints;
    }

    public boolean isVersioningAvailable() {
        if (this.versioningAvailable != null) {
            return this.versioningAvailable;
        }
        Repository repository = this.getRepository();
        Value versioningOptionValue = repository.getDescriptorValue("option.versioning.supported");
        if (versioningOptionValue == null) {
            this.versioningAvailable = Boolean.FALSE;
            return false;
        }
        Value simpleVersioningOptionValue = repository.getDescriptorValue("option.simple.versioning.supported");
        if (simpleVersioningOptionValue == null) {
            this.versioningAvailable = Boolean.FALSE;
            return false;
        }
        try {
            this.versioningAvailable = versioningOptionValue.getBoolean() & simpleVersioningOptionValue.getBoolean();
        }
        catch (RepositoryException e) {
            logger.warn("Error while trying to check for versioning support", (Throwable)e);
            this.versioningAvailable = Boolean.FALSE;
            return false;
        }
        return this.versioningAvailable;
    }

    public boolean isLockingAvailable() {
        if (this.lockingAvailable != null) {
            return this.lockingAvailable;
        }
        Repository repository = this.getRepository();
        Value lockingOptionValue = repository.getDescriptorValue("option.locking.supported");
        if (lockingOptionValue == null) {
            this.lockingAvailable = Boolean.FALSE;
            return false;
        }
        try {
            this.lockingAvailable = lockingOptionValue.getBoolean();
        }
        catch (RepositoryException e) {
            logger.warn("Error while trying to check for locking support", (Throwable)e);
            this.lockingAvailable = Boolean.FALSE;
        }
        return this.lockingAvailable;
    }

    public boolean isSearchAvailable() {
        if (this.searchAvailable != null) {
            return this.searchAvailable;
        }
        Repository repository = this.getRepository();
        Value[] queryLanguageValues = repository.getDescriptorValues("query.languages");
        if (queryLanguageValues == null) {
            this.searchAvailable = Boolean.FALSE;
            return false;
        }
        this.searchAvailable = queryLanguageValues.length == 0 ? Boolean.FALSE : Boolean.TRUE;
        return this.searchAvailable;
    }

    public boolean isUpdateMixinAvailable() {
        if (this.updateMixinAvailable != null) {
            return this.updateMixinAvailable;
        }
        Repository repository = this.getRepository();
        Value updateMixinOptionValue = repository.getDescriptorValue("option.update.mixin.node.types.supported");
        if (updateMixinOptionValue == null) {
            this.updateMixinAvailable = Boolean.FALSE;
            return false;
        }
        try {
            this.updateMixinAvailable = updateMixinOptionValue.getBoolean();
        }
        catch (RepositoryException e) {
            logger.warn("Error while trying to check for mixin updates support", (Throwable)e);
            this.updateMixinAvailable = Boolean.FALSE;
        }
        return this.updateMixinAvailable;
    }

    public boolean isSlowConnection() {
        if (this.slowConnection != null) {
            return this.slowConnection;
        }
        Repository repository = this.getRepository();
        Value[] slowConnectionValues = repository.getDescriptorValues("jahia.provider.slowConnection");
        if (slowConnectionValues == null) {
            this.slowConnection = Boolean.FALSE;
            return false;
        }
        this.slowConnection = slowConnectionValues.length == 0 ? Boolean.FALSE : Boolean.TRUE;
        return this.slowConnection;
    }

    public void setSlowConnection(boolean slowConnection) {
        this.slowConnection = slowConnection;
    }

    public PropertyIterator getWeakReferences(JCRNodeWrapper node, String propertyName, Session session) throws RepositoryException {
        return null;
    }

    @Override
    public int compareTo(JCRStoreProvider o) {
        if (this == o) {
            return 0;
        }
        if (o == null) {
            return 1;
        }
        return StringUtils.defaultString((String)this.getMountPoint()).compareTo(StringUtils.defaultString((String)o.getMountPoint()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JCRStoreProvider that = (JCRStoreProvider)o;
        return StringUtils.defaultString((String)this.getMountPoint()).equals(that.getMountPoint());
    }

    public int hashCode() {
        return this.getMountPoint() != null ? this.getMountPoint().hashCode() : 0;
    }

    public Map<String, Constructor<?>> getValidators() {
        return this.service.getValidators();
    }

    public void setNodeTypesDBService(NodeTypesDBServiceImpl nodeTypesDBService) {
        this.nodeTypesDBService = nodeTypesDBService;
    }
}

