/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.QueryResult;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.JahiaAfterInitializationService;
import org.jahia.services.JahiaService;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.ProviderFactory;
import org.jahia.services.content.decorator.JCRMountPointNode;
import org.jahia.services.content.decorator.JCRNodeDecorator;
import org.jahia.services.content.decorator.validation.JCRNodeValidator;
import org.jahia.services.content.interceptor.InterceptorChain;
import org.jahia.services.content.interceptor.PropertyInterceptor;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.usermanager.JahiaUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRStoreService
extends JahiaService
implements JahiaAfterInitializationService {
    private static Logger logger = LoggerFactory.getLogger(JCRStoreService.class);
    private Map<String, Class<? extends JCRNodeDecorator>> decorators = new ConcurrentHashMap<String, Class<? extends JCRNodeDecorator>>();
    private Map<String, Constructor<?>> decoratorCreators = new ConcurrentHashMap();
    private InterceptorChain interceptorChain;
    private Map<String, ProviderFactory> providerFactories = new ConcurrentHashMap<String, ProviderFactory>();
    private List<PropertyInterceptor> interceptors = new LinkedList<PropertyInterceptor>();
    private Set<String> noValidityCheckTypes = new HashSet<String>();
    private Set<String> noLanguageValidityCheckTypes = new HashSet<String>();
    private Map<String, Class<? extends JCRNodeValidator>> validators = new ConcurrentHashMap<String, Class<? extends JCRNodeValidator>>();
    private Map<String, Constructor<?>> validatorCreators = new ConcurrentHashMap();
    private Map<String, List<DefaultEventListener>> listeners;
    private JCRSessionFactory sessionFactory;

    public static JCRStoreService getInstance() {
        return Holder.INSTANCE;
    }

    private JCRStoreService() {
    }

    public void addInterceptor(int index, PropertyInterceptor interceptor) {
        this.interceptors.add(index, interceptor);
        this.interceptorChain = null;
    }

    public void addInterceptor(PropertyInterceptor interceptor) {
        this.interceptors.add(interceptor);
        this.interceptorChain = null;
    }

    public void addProviderFactory(String nodeType, final ProviderFactory externalProviderFactory) {
        this.providerFactories.put(nodeType, externalProviderFactory);
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    QueryWrapper query = session.getWorkspace().getQueryManager().createQuery("select * from [" + externalProviderFactory.getNodeTypeName() + "] as mount", "JCR-SQL2");
                    QueryResult queryResult = query.execute();
                    NodeIterator queryResultNodes = queryResult.getNodes();
                    while (queryResultNodes.hasNext()) {
                        JCRMountPointNode mountPointNode;
                        JCRNodeWrapper mountPointNodeWrapper = (JCRNodeWrapper)queryResultNodes.next();
                        if (mountPointNodeWrapper instanceof JCRMountPointNode && !(mountPointNode = (JCRMountPointNode)mountPointNodeWrapper).checkMountPointValidity()) {
                            logger.warn("Issue while trying to mount an external provider (" + mountPointNodeWrapper.getPath() + ") upon startup, all references " + "to file coming from this mount won't be available until it is fixed. If you migrating from Jahia 6.6 this might be normal until the migration scripts have been completed.");
                            continue;
                        }
                        try {
                            mountPointNodeWrapper.getNodes();
                        }
                        catch (RepositoryException e) {
                            logger.warn("Issue while trying to mount an external provider (" + mountPointNodeWrapper.getPath() + ") upon startup, all references " + "to file coming from this mount won't be available until it is fixed. If you migrating from Jahia 6.6 this might be normal until the migration scripts have been completed", (Throwable)e);
                        }
                    }
                    return null;
                }
            });
        }
        catch (RepositoryException e) {
            logger.error("Cannot mount provider " + nodeType, (Throwable)e);
        }
    }

    public void removeProviderFactory(String nodeType, final ProviderFactory externalProviderFactory) {
        if (this.providerFactories.get(nodeType) == externalProviderFactory) {
            try {
                JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Object>(){

                    @Override
                    public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                        QueryWrapper query = session.getWorkspace().getQueryManager().createQuery("select * from [" + externalProviderFactory.getNodeTypeName() + "] as mount", "JCR-SQL2");
                        QueryResult queryResult = query.execute();
                        NodeIterator queryResultNodes = queryResult.getNodes();
                        while (queryResultNodes.hasNext()) {
                            JCRNodeWrapper mountPointNodeWrapper = (JCRNodeWrapper)queryResultNodes.next();
                            JCRStoreProvider provider = JCRSessionFactory.getInstance().getMountPoints().get(mountPointNodeWrapper.getPath());
                            if (provider == null || !provider.isDynamicallyMounted()) continue;
                            provider.stop();
                        }
                        return null;
                    }
                });
            }
            catch (RepositoryException e) {
                logger.error("Cannot unmount provider " + nodeType, (Throwable)e);
            }
            this.providerFactories.remove(nodeType);
        }
    }

    public JCRNodeWrapper decorate(JCRNodeWrapper w) {
        try {
            Constructor<?> creator = this.decoratorCreators.get(w.getPrimaryNodeTypeName());
            if (creator == null) {
                for (String type : this.decoratorCreators.keySet()) {
                    if (!w.isNodeType(type)) continue;
                    creator = this.decoratorCreators.get(type);
                    break;
                }
            }
            if (creator != null) {
                try {
                    return (JCRNodeWrapper)creator.newInstance(w);
                }
                catch (Exception e) {
                    logger.error("Cannot decorate node", (Throwable)e);
                }
            }
        }
        catch (RepositoryException e) {
            logger.error("Error while decorating node", (Throwable)e);
        }
        return w;
    }

    public void deployDefinitions(String systemId) {
        for (JCRStoreProvider provider : this.sessionFactory.getProviders().values()) {
            if (!provider.canRegisterCustomNodeTypes()) continue;
            provider.deployDefinitions(systemId);
        }
    }

    public void undeployDefinitions(String systemId) {
        for (JCRStoreProvider provider : this.sessionFactory.getProviders().values()) {
            if (!provider.canRegisterCustomNodeTypes()) continue;
            provider.undeployDefinitions(systemId);
        }
    }

    public void deployExternalUser(JahiaUser jahiaUser) throws RepositoryException {
        JCRStoreProvider provider = this.sessionFactory.getMountPoints().get("/");
        provider.deployExternalUser(jahiaUser);
        ServicesRegistry.getInstance().getJahiaUserManagerService().updateCache(jahiaUser);
    }

    public Map<String, Class<? extends JCRNodeDecorator>> getDecorators() {
        return this.decorators;
    }

    public List<JCRNodeWrapper> getImportDropBoxes(String site, JahiaUser user) {
        ArrayList<JCRNodeWrapper> r = new ArrayList<JCRNodeWrapper>();
        for (JCRStoreProvider storeProvider : this.sessionFactory.getMountPoints().values()) {
            try {
                r.addAll(storeProvider.getImportDropBoxes(site, user));
            }
            catch (RepositoryException e) {
                logger.warn("Error when querying repository", (Throwable)e);
            }
        }
        return r;
    }

    public InterceptorChain getInterceptorChain() {
        if (this.interceptorChain == null) {
            this.interceptorChain = new InterceptorChain();
            this.interceptorChain.setInterceptors(this.interceptors);
        }
        return this.interceptorChain;
    }

    public Map<String, List<DefaultEventListener>> getListeners() {
        return this.listeners;
    }

    public JCRSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public JCRNodeWrapper getUserFolder(JahiaUser user) throws RepositoryException {
        return this.sessionFactory.getMountPoints().get("/").getUserFolder(user);
    }

    @Override
    public void initAfterAllServicesAreStarted() throws JahiaInitializationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initObservers(Map<String, List<DefaultEventListener>> listeners) throws RepositoryException {
        if (listeners != null) {
            for (String ws : listeners.keySet()) {
                List<DefaultEventListener> l = listeners.get(ws);
                JCRSessionWrapper session = this.getSessionFactory().getSystemSession(null, ws);
                try {
                    Workspace workspace = session.getWorkspace();
                    ObservationManager observationManager = workspace.getObservationManager();
                    for (DefaultEventListener listener : l) {
                        if (listener.getEventTypes() > 0) {
                            listener.setWorkspace(ws);
                            observationManager.addEventListener((EventListener)listener, listener.getEventTypes(), listener.getPath(), listener.isDeep(), listener.getUuids(), listener.getNodeTypes(), false);
                            continue;
                        }
                        logger.info("Skipping listener {} as it has no event types configured.", (Object)listener.getClass().getName());
                    }
                }
                finally {
                    session.logout();
                }
            }
        }
    }

    public void removeInterceptor(PropertyInterceptor interceptor) {
        if (this.interceptors.remove(interceptor)) {
            this.interceptorChain = null;
        }
    }

    public void setDecorators(Map<String, String> decorators) {
        if (!this.decorators.isEmpty()) {
            throw new RuntimeException("setDecorators should not be called after initialization of system, use addDecorator instead");
        }
        if (decorators != null) {
            for (Map.Entry<String, String> decorator : decorators.entrySet()) {
                try {
                    this.decorators.put(decorator.getKey(), Class.forName(decorator.getValue()));
                    this.decoratorCreators.put(decorator.getKey(), Class.forName(decorator.getValue()).getConstructor(JCRNodeWrapper.class));
                }
                catch (Exception e) {
                    logger.error("Unable to instantiate decorator: " + decorator.getValue(), (Throwable)e);
                }
            }
        }
    }

    public void addDecorator(String nodeType, Class<? extends JCRNodeDecorator> decoratorClass) {
        try {
            if (!NodeTypeRegistry.getInstance().getNodeType(nodeType).isMixin()) {
                if (this.decorators == null) {
                    this.decorators = new ConcurrentHashMap<String, Class<? extends JCRNodeDecorator>>();
                }
                this.decorators.put(nodeType, decoratorClass);
                try {
                    this.decoratorCreators.put(nodeType, decoratorClass.getConstructor(JCRNodeWrapper.class));
                }
                catch (Exception e) {
                    logger.error("Unable to instantiate decorator: " + decoratorClass, (Throwable)e);
                }
            } else {
                logger.error("It is impossible to decorate a mixin (" + nodeType + "), only primary node type can be decorated");
            }
        }
        catch (NoSuchNodeTypeException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void removeDecorator(String nodeType) {
        this.decorators.remove(nodeType);
        this.decoratorCreators.remove(nodeType);
    }

    public void setInterceptors(List<PropertyInterceptor> interceptors) {
        this.interceptors.addAll(interceptors);
        this.interceptorChain = null;
    }

    public Map<String, ProviderFactory> getProviderFactories() {
        return this.providerFactories;
    }

    public void setProviderFactories(Map<String, ProviderFactory> providerFactories) {
        this.providerFactories = providerFactories;
    }

    public void setListeners(Map<String, List<DefaultEventListener>> listeners) {
        this.listeners = listeners;
    }

    public void setSessionFactory(JCRSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public void start() throws JahiaInitializationException {
        try {
            NamespaceRegistry nsRegistry = this.sessionFactory.getNamespaceRegistry();
            NodeTypeRegistry ntRegistry = NodeTypeRegistry.getInstance();
            ImmutableSet prefixes = ImmutableSet.copyOf((Object[])nsRegistry.getPrefixes());
            for (Map.Entry<String, String> namespaceEntry : ntRegistry.getNamespaces().entrySet()) {
                if (prefixes.contains(namespaceEntry.getKey())) continue;
                nsRegistry.registerNamespace(namespaceEntry.getKey(), namespaceEntry.getValue());
            }
            this.initObservers(this.listeners);
        }
        catch (Exception e) {
            logger.error("Repository init error", (Throwable)e);
        }
    }

    @Override
    public void stop() throws JahiaException {
    }

    public Set<String> getNoValidityCheckTypes() {
        return this.noValidityCheckTypes;
    }

    public void setNoValidityCheckTypes(Set<String> noValidityCheckTypes) {
        this.noValidityCheckTypes = noValidityCheckTypes;
    }

    public Set<String> getNoLanguageValidityCheckTypes() {
        return this.noLanguageValidityCheckTypes;
    }

    public void setNoLanguageValidityCheckTypes(Set<String> noLanguageValidityCheckTypes) {
        this.noLanguageValidityCheckTypes = noLanguageValidityCheckTypes;
    }

    public void addValidator(String nodeType, Class<? extends JCRNodeValidator> validatorClass) {
        if (this.validators == null) {
            this.validators = new ConcurrentHashMap<String, Class<? extends JCRNodeValidator>>();
        }
        this.validators.put(nodeType, validatorClass);
        try {
            this.validatorCreators.put(nodeType, validatorClass.getConstructor(JCRNodeWrapper.class));
        }
        catch (Exception e) {
            logger.error("Unable to instantiate decorator: " + validatorClass, (Throwable)e);
        }
    }

    public void removeValidator(String nodeType) {
        if (this.validators == null) {
            this.validators = new ConcurrentHashMap<String, Class<? extends JCRNodeValidator>>();
        }
        this.validators.remove(nodeType);
        this.validatorCreators.remove(nodeType);
    }

    public Map<String, Constructor<?>> getValidators() {
        return this.validatorCreators;
    }

    private static class Holder {
        static final JCRStoreService INSTANCE = new JCRStoreService();

        private Holder() {
        }
    }
}

