/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.Locale;
import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;

public class JCRTemplate {
    private JCRSessionFactory sessionFactory;
    private static JCRTemplate instance;

    private JCRTemplate() {
    }

    public void setSessionFactory(JCRSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public JCRSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public <X> X doExecuteWithSystemSessionInSameWorkspaceAndLocale(JCRCallback<X> callback) throws RepositoryException {
        JCRSessionWrapper session = this.getSessionFactory().getCurrentUserSession();
        if (session == null) {
            throw new RepositoryException("Trying to execute as a system session using current workspace and locale when no current user session exists !");
        }
        return this.doExecuteWithSystemSession(null, session.getWorkspace().getName(), session.getLocale(), callback);
    }

    public <X> X doExecuteWithSystemSession(JCRCallback<X> callback) throws RepositoryException {
        return this.doExecuteWithSystemSession(null, null, null, callback);
    }

    public <X> X doExecuteWithSystemSession(String username, JCRCallback<X> callback) throws RepositoryException {
        return this.doExecuteWithSystemSession(username, null, null, callback);
    }

    public <X> X doExecuteWithSystemSession(String username, String workspace, JCRCallback<X> callback) throws RepositoryException {
        return this.doExecuteWithSystemSession(username, workspace, null, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <X> X doExecuteWithSystemSession(String username, String workspace, Locale locale, JCRCallback<X> callback) throws RepositoryException {
        JCRSessionWrapper session = null;
        try {
            if (username != null && username.startsWith(" system ")) {
                throw new IllegalArgumentException("the username cannot start by \" system \"");
            }
            session = this.sessionFactory.getSystemSession(username, workspace, locale);
            X x = callback.doInJCR(session);
            return x;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <X> X doExecuteWithUserSession(String username, String workspace, JCRCallback<X> callback) throws RepositoryException {
        JCRSessionWrapper session = null;
        try {
            session = this.sessionFactory.getUserSession(username, workspace);
            X x = callback.doInJCR(session);
            return x;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <X> X doExecuteWithUserSession(String username, String workspace, Locale locale, JCRCallback<X> callback) throws RepositoryException {
        JCRSessionWrapper session = null;
        try {
            session = this.sessionFactory.getUserSession(username, workspace, locale);
            X x = callback.doInJCR(session);
            return x;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public <X> X doExecute(boolean useSystemSession, String username, String workspace, Locale locale, JCRCallback<X> callback) throws RepositoryException {
        if (useSystemSession) {
            return this.doExecuteWithSystemSession(username, workspace, locale, callback);
        }
        return this.doExecuteWithUserSession(username, workspace, locale, callback);
    }

    public <X> X doExecute(boolean useSystemSession, String username, String workspace, JCRCallback<X> callback) throws RepositoryException {
        if (useSystemSession) {
            return this.doExecuteWithSystemSession(username, workspace, callback);
        }
        return this.doExecuteWithUserSession(username, workspace, callback);
    }

    public static JCRTemplate getInstance() {
        if (instance == null) {
            instance = new JCRTemplate();
        }
        return instance;
    }

    public JCRStoreProvider getProvider(String path) {
        return this.sessionFactory.getProvider(path);
    }
}

