/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.apache.commons.lang.StringUtils;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCREventIterator;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.usermanager.JahiaUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRUserPropertyModificationListener
extends DefaultEventListener {
    private static transient Logger logger = LoggerFactory.getLogger(JCRUserPropertyModificationListener.class);

    @Override
    public int getEventTypes() {
        return 28;
    }

    @Override
    public String[] getNodeTypes() {
        return new String[]{"jnt:user"};
    }

    public void onEvent(final EventIterator events) {
        String userId = ((JCREventIterator)events).getSession().getUserID();
        if (userId.startsWith(" system ")) {
            userId = userId.substring(" system ".length());
        }
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession(userId, this.workspace, new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    while (events.hasNext()) {
                        String path;
                        Event event = events.nextEvent();
                        if (JCRUserPropertyModificationListener.this.isExternal(event) || (path = event.getPath()).startsWith("/jcr:system/") || (event.getType() & 0x1C) != 0 && JCRUserPropertyModificationListener.this.propertiesToIgnore.contains(StringUtils.substringAfterLast((String)path, (String)"/"))) continue;
                        String username = StringUtils.substringAfterLast((String)StringUtils.substringBeforeLast((String)path, (String)"/"), (String)"/");
                        JahiaUser jahiaUser = ServicesRegistry.getInstance().getJahiaUserManagerService().lookupUser(username);
                        if (jahiaUser == null) continue;
                        ServicesRegistry.getInstance().getJahiaUserManagerService().updateCache(jahiaUser);
                    }
                    return null;
                }
            });
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

