/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCREventIterator;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LastModifiedListener
extends DefaultEventListener {
    private static Logger logger = LoggerFactory.getLogger(LastModifiedListener.class);
    private JCRPublicationService publicationService;

    @Override
    public int getEventTypes() {
        return 63;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(final EventIterator eventIterator) {
        block7: {
            try {
                String userId = ((JCREventIterator)eventIterator).getSession().getUserID();
                final int type = ((JCREventIterator)eventIterator).getOperationType();
                if (type == 7 || type == 6) {
                    return;
                }
                if (userId.startsWith(" system ")) {
                    userId = userId.substring(" system ".length());
                }
                final String finalUserId = userId;
                final HashSet sessions = new HashSet();
                final HashSet nodes = new HashSet();
                final HashSet addedNodes = new HashSet();
                final HashSet reorderedNodes = new HashSet();
                final ArrayList<String> autoPublishedIds = this.workspace.equals("default") ? new ArrayList<String>() : null;
                JCRTemplate.getInstance().doExecuteWithSystemSession(finalUserId, this.workspace, new JCRCallback<Object>(){

                    @Override
                    public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                        Calendar c = GregorianCalendar.getInstance();
                        while (eventIterator.hasNext()) {
                            String path;
                            Event event = eventIterator.nextEvent();
                            if (LastModifiedListener.this.isExternal(event) || (path = event.getPath()).startsWith("/jcr:system/") || (event.getType() & 0x1C) != 0 && LastModifiedListener.this.propertiesToIgnore.contains(StringUtils.substringAfterLast((String)path, (String)"/"))) continue;
                            if (logger.isDebugEnabled()) {
                                logger.debug("Receiving event for lastModified date for : " + path);
                            }
                            if (event.getType() == 1) {
                                addedNodes.add(path);
                                continue;
                            }
                            if (32 == event.getType()) {
                                if (event.getInfo().get("srcChildRelPath") != null) {
                                    reorderedNodes.add(path);
                                }
                                nodes.add(StringUtils.substringBeforeLast((String)path, (String)"/"));
                                continue;
                            }
                            nodes.add(StringUtils.substringBeforeLast((String)path, (String)"/"));
                        }
                        if (reorderedNodes.size() > 0) {
                            addedNodes.removeAll(reorderedNodes);
                        }
                        if (addedNodes.size() > 0) {
                            nodes.removeAll(addedNodes);
                        }
                        if (!nodes.isEmpty() || !addedNodes.isEmpty()) {
                            JCRNodeWrapper n;
                            if (logger.isDebugEnabled()) {
                                logger.debug("Updating lastModified date for existing nodes : " + Arrays.deepToString(nodes.toArray(new String[nodes.size()])));
                                logger.debug("Updating lastModified date for added nodes : " + Arrays.deepToString(addedNodes.toArray(new String[addedNodes.size()])));
                            }
                            for (String node : nodes) {
                                try {
                                    n = session.getNode(node);
                                    sessions.add(n.getRealNode().getSession());
                                    LastModifiedListener.this.updateProperty(n, c, finalUserId, autoPublishedIds, type);
                                }
                                catch (UnsupportedRepositoryOperationException e) {
                                }
                                catch (PathNotFoundException e) {}
                            }
                            for (String addedNode : addedNodes) {
                                try {
                                    n = session.getNode(addedNode);
                                    sessions.add(n.getRealNode().getSession());
                                    if (!n.hasProperty("j:originWS") && n.isNodeType("jmix:originWS")) {
                                        n.setProperty("j:originWS", LastModifiedListener.this.workspace);
                                    }
                                    LastModifiedListener.this.updateProperty(n, c, finalUserId, autoPublishedIds, type);
                                }
                                catch (UnsupportedRepositoryOperationException e) {
                                }
                                catch (PathNotFoundException e) {}
                            }
                            for (Session jcrsession : sessions) {
                                try {
                                    jcrsession.save();
                                }
                                catch (RepositoryException e) {
                                    logger.debug("Cannot update lastModification properties");
                                }
                            }
                        }
                        return null;
                    }
                });
                if (autoPublishedIds == null || autoPublishedIds.isEmpty()) break block7;
                LastModifiedListener lastModifiedListener = this;
                synchronized (lastModifiedListener) {
                    this.publicationService.publish(autoPublishedIds, "default", "live", false, null);
                }
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void updateProperty(JCRNodeWrapper n, Calendar c, String userId, List<String> autoPublished, int type) throws RepositoryException {
        while (!n.isNodeType("mix:lastModified")) {
            this.addAutoPublish(n, autoPublished);
            try {
                n = n.getParent();
            }
            catch (ItemNotFoundException e) {
                return;
            }
        }
        boolean isAutoPublished = this.addAutoPublish(n, autoPublished);
        if (type != 13 || isAutoPublished) {
            JCRNodeWrapper parent;
            n.getSession().checkout(n);
            n.setProperty("jcr:lastModified", c);
            n.setProperty("jcr:lastModifiedBy", userId);
            if (n.isNodeType("nt:resource") && (parent = n.getParent()).isNodeType("mix:lastModified")) {
                parent.setProperty("jcr:lastModified", c);
                parent.setProperty("jcr:lastModifiedBy", userId);
            }
        }
    }

    private boolean addAutoPublish(JCRNodeWrapper n, List<String> autoPublished) throws RepositoryException {
        if (autoPublished != null && !n.getPath().startsWith("/modules")) {
            if (!autoPublished.contains(n.getIdentifier()) && n.isNodeType("jmix:autoPublish")) {
                autoPublished.add(n.getIdentifier());
                return true;
            }
            if (!autoPublished.contains(n.getIdentifier()) && n.isNodeType("jnt:translation") && n.getParent().isNodeType("jmix:autoPublish")) {
                autoPublished.add(n.getIdentifier());
                return true;
            }
        }
        return false;
    }

    public synchronized void setPublicationService(JCRPublicationService publicationService) {
        this.publicationService = publicationService;
    }
}

