/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.jahia.services.content.EmptyPropertyIterator;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRPropertyWrapperImpl;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;

public class LazyPropertyIterator
implements PropertyIterator,
Map {
    protected JCRNodeWrapper node;
    protected Locale locale;
    protected String singlePattern = null;
    protected String[] patternArray = null;
    protected PropertyIterator propertyIterator;
    protected PropertyIterator i18nPropertyIterator;
    protected Property tempNext = null;
    protected String fallbackLocale;

    public LazyPropertyIterator(JCRNodeWrapper node) {
        this.node = node;
    }

    public LazyPropertyIterator(JCRNodeWrapper node, Locale locale) {
        this.node = node;
        this.locale = locale;
    }

    public LazyPropertyIterator(JCRNodeWrapper node, Locale locale, String singlePattern) {
        this.node = node;
        this.locale = locale;
        this.singlePattern = singlePattern;
    }

    public LazyPropertyIterator(JCRNodeWrapper node, Locale locale, String[] patternArray) {
        this.node = node;
        this.locale = locale;
        this.patternArray = patternArray;
    }

    @Override
    public int size() {
        return (int)(this.getPropertiesIterator().getSize() + this.getI18NPropertyIterator().getSize());
    }

    protected PropertyIterator getPropertiesIterator() {
        if (this.propertyIterator == null) {
            try {
                this.propertyIterator = this.patternArray != null ? this.node.getRealNode().getProperties(this.patternArray) : (this.singlePattern == null ? this.node.getRealNode().getProperties() : this.node.getRealNode().getProperties(this.singlePattern));
            }
            catch (RepositoryException e) {
                throw new RuntimeException("getI18NPropertyIterator", e);
            }
        }
        return this.propertyIterator;
    }

    protected PropertyIterator getI18NPropertyIterator() {
        if (this.i18nPropertyIterator == null) {
            try {
                if (this.locale != null) {
                    Node localizedNode = this.node.getI18N(this.locale);
                    this.fallbackLocale = localizedNode.getProperty("jcr:language").getString();
                    this.i18nPropertyIterator = this.patternArray != null ? localizedNode.getProperties(this.patternArray) : (this.singlePattern == null ? localizedNode.getProperties() : localizedNode.getProperties(this.singlePattern));
                } else {
                    this.i18nPropertyIterator = new EmptyPropertyIterator();
                }
            }
            catch (ItemNotFoundException e) {
                this.i18nPropertyIterator = new EmptyPropertyIterator();
            }
            catch (RepositoryException e) {
                throw new RuntimeException("getI18NPropertyIterator", e);
            }
        }
        return this.i18nPropertyIterator;
    }

    @Override
    public boolean isEmpty() {
        return this.getPropertiesIterator().getSize() == 0L && this.getI18NPropertyIterator().getSize() == 0L;
    }

    public Property nextProperty() {
        try {
            if (this.tempNext != null) {
                Property res = this.tempNext;
                this.tempNext = null;
                return res;
            }
            if (this.getPropertiesIterator().hasNext()) {
                Property property = this.getPropertiesIterator().nextProperty();
                ExtendedPropertyDefinition epd = this.node.getApplicablePropertyDefinition(property.getName());
                if (epd == null) {
                    return this.nextProperty();
                }
                return new JCRPropertyWrapperImpl(this.node, property, this.node.getSession(), this.node.getProvider(), epd);
            }
            if (this.getI18NPropertyIterator().hasNext()) {
                Property property;
                String name;
                ExtendedPropertyDefinition def;
                while ((def = this.node.getApplicablePropertyDefinition(name = (property = this.getI18NPropertyIterator().nextProperty()).getName())) == null || !def.isInternationalized()) {
                }
                return new JCRPropertyWrapperImpl(this.node, property, this.node.getSession(), this.node.getProvider(), def, name);
            }
            return null;
        }
        catch (ConstraintViolationException e) {
            return this.nextProperty();
        }
        catch (RepositoryException e) {
            throw new RuntimeException("nextProperty", e);
        }
    }

    public void skip(long skipNum) {
        int i = 0;
        while ((long)i < skipNum) {
            if (this.getPropertiesIterator().hasNext()) {
                this.getPropertiesIterator().skip(1L);
            } else if (this.getI18NPropertyIterator().hasNext()) {
                this.getI18NPropertyIterator().skip(1L);
            }
            ++i;
        }
    }

    public long getSize() {
        return this.size();
    }

    public long getPosition() {
        return this.getPropertiesIterator().getPosition() + this.getI18NPropertyIterator().getPosition();
    }

    public boolean hasNext() {
        if (this.tempNext != null) {
            return true;
        }
        try {
            if (this.getPropertiesIterator().hasNext()) {
                Property property = this.getPropertiesIterator().nextProperty();
                ExtendedPropertyDefinition epd = this.node.getApplicablePropertyDefinition(property.getName(), property.getType(), property.isMultiple());
                if (epd == null) {
                    return this.hasNext();
                }
                this.tempNext = new JCRPropertyWrapperImpl(this.node, property, this.node.getSession(), this.node.getProvider(), epd);
                return true;
            }
            if (this.getI18NPropertyIterator().hasNext()) {
                Property property;
                String name;
                ExtendedPropertyDefinition def;
                while ((def = this.node.getApplicablePropertyDefinition(name = (property = this.getI18NPropertyIterator().nextProperty()).getName())) == null || !def.isInternationalized()) {
                }
                this.tempNext = new JCRPropertyWrapperImpl(this.node, property, this.node.getSession(), this.node.getProvider(), def, name);
                return true;
            }
            return false;
        }
        catch (ConstraintViolationException e) {
            return this.hasNext();
        }
        catch (NoSuchElementException e) {
            return false;
        }
        catch (RepositoryException e) {
            throw new RuntimeException("nextProperty", e);
        }
    }

    public Object next() {
        return this.nextProperty();
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public boolean containsKey(Object o) {
        try {
            return this.node.hasProperty((String)o);
        }
        catch (ConstraintViolationException e) {
            return false;
        }
        catch (RepositoryException e) {
            throw new RuntimeException("containsKey", e);
        }
    }

    @Override
    public boolean containsValue(Object o) {
        throw new UnsupportedOperationException("containsValue");
    }

    public Object get(Object o) {
        try {
            if (!this.node.hasProperty((String)o)) {
                return null;
            }
            JCRPropertyWrapper p = this.node.getProperty((String)o);
            if (p.isMultiple()) {
                return p.getValues();
            }
            return p.getValue();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (ConstraintViolationException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new RuntimeException("get", e);
        }
    }

    public Object put(Object o, Object o1) {
        throw new UnsupportedOperationException("put");
    }

    public Object remove(Object o) {
        throw new UnsupportedOperationException("remove");
    }

    public void putAll(Map map) {
        throw new UnsupportedOperationException("putAll");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("clear");
    }

    public Set keySet() {
        throw new UnsupportedOperationException("keySet");
    }

    public Collection values() {
        throw new UnsupportedOperationException("values");
    }

    public Set entrySet() {
        throw new UnsupportedOperationException("entrySet");
    }
}

