/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyIteratorImpl
implements PropertyIterator {
    private static Logger logger = LoggerFactory.getLogger(PropertyIteratorImpl.class);
    private PropertyIterator iterator;
    private JCRSessionWrapper session;
    private JCRStoreProvider jcrStoreProvider;

    public PropertyIteratorImpl(PropertyIterator iterator, JCRSessionWrapper session, JCRStoreProvider jcrStoreProvider) {
        this.iterator = iterator;
        this.session = session;
        this.jcrStoreProvider = jcrStoreProvider;
    }

    public Property nextProperty() {
        try {
            return this.jcrStoreProvider.getPropertyWrapper(this.iterator.nextProperty(), this.session);
        }
        catch (RepositoryException e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    public void skip(long skipNum) {
        this.iterator.skip(skipNum);
    }

    public long getSize() {
        return this.iterator.getSize();
    }

    public long getPosition() {
        return this.iterator.getPosition();
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public Object next() {
        return this.nextProperty();
    }

    public void remove() {
        this.iterator.remove();
    }
}

