/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.decorator;

import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.log4j.Logger;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.JCRStoreService;
import org.jahia.services.content.ProviderFactory;
import org.jahia.services.content.decorator.JCRNodeDecorator;

public class JCRMountPointNode
extends JCRNodeDecorator {
    private static transient Logger logger = Logger.getLogger(JCRMountPointNode.class);

    public JCRMountPointNode(JCRNodeWrapper node) {
        super(node);
    }

    public boolean checkMountPointValidity() {
        JCRStoreProvider provider;
        try {
            provider = this.getMountProvider();
        }
        catch (Exception e) {
            logger.error((Object)"Couldn't retrieve provider", (Throwable)e);
            return false;
        }
        try {
            this.getRootNodeFrom(provider);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"Couldn't retrieve root node", (Throwable)e);
            if (provider != null) {
                this.getProvider().getSessionFactory().removeProvider(provider.getKey());
            }
            return false;
        }
    }

    private JCRNodeWrapper getRootNodeFrom(JCRStoreProvider provider) throws RepositoryException {
        if (provider != null) {
            JCRSessionWrapper sessionWrapper = this.getSession();
            return provider.getNodeWrapper(sessionWrapper.getProviderSession(provider).getRootNode(), sessionWrapper);
        }
        throw new RepositoryException("No provider found for mount point " + this.getPath() + " of type " + this.getPrimaryNodeTypeName());
    }

    private JCRStoreProvider getMountProvider() throws RepositoryException {
        JCRStoreProvider provider;
        Map<String, JCRStoreProvider> mountPoints = this.getProvider().getSessionFactory().getMountPoints();
        if (mountPoints == null || !mountPoints.containsKey(this.getPath())) {
            ProviderFactory providerFactory = JCRStoreService.getInstance().getProviderFactories().get(this.getPrimaryNodeTypeName());
            if (providerFactory == null) {
                logger.warn((Object)("Couldn't find a provider factory for type " + this.getPrimaryNodeTypeName() + ". Please make sure a factory is deployed and active for this node type before the mount can be performed."));
                return null;
            }
            provider = providerFactory.mountProvider(this);
        } else {
            provider = mountPoints.get(this.getPath());
        }
        return provider;
    }

    @Override
    public void remove() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        try {
            this.getProvider().getSessionFactory().unmount(this.getMountProvider());
        }
        catch (RepositoryException e) {
            logger.warn((Object)("unable to unmount provider " + this.getProvider().getKey() + " at " + this.getPath() + " but node will be deleted anyway"), (Throwable)e);
        }
        super.remove();
    }
}

