/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.decorator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.jahia.bin.Jahia;
import org.jahia.data.applications.ApplicationBean;
import org.jahia.data.applications.EntryPointDefinition;
import org.jahia.exceptions.JahiaException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRNodeDecorator;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRPortletNode
extends JCRNodeDecorator {
    private static final Logger logger = LoggerFactory.getLogger(JCRPortletNode.class);

    public JCRPortletNode(JCRNodeWrapper node) {
        super(node);
    }

    public String getContextName() throws RepositoryException {
        String context;
        try {
            context = this.getProperty("j:applicationRef").getNode().getProperty("j:context").getString();
        }
        catch (RepositoryException e) {
            final String[] strings = Patterns.EXCLAMATION_MARK.split(this.getProperty("j:application").getString());
            context = strings[0];
            if (context.startsWith("$context")) {
                context = Jahia.getContextPath() + context.substring("$context".length());
            }
            final String finalContext = context;
            final String uuid = this.getUUID();
            JCRTemplate.getInstance().doExecuteWithSystemSession(null, this.getSession().getWorkspace().getName(), this.getSession().getLocale(), new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    try {
                        ApplicationBean applicationByContext = ServicesRegistry.getInstance().getApplicationsManagerService().getApplicationByContext(finalContext);
                        if (applicationByContext != null) {
                            JCRNodeWrapper nodeByUUID = session.getNodeByUUID(uuid);
                            session.checkout(nodeByUUID);
                            nodeByUUID.setProperty("j:applicationRef", applicationByContext.getID());
                            nodeByUUID.setProperty("j:definition", strings[1]);
                            session.save();
                        }
                    }
                    catch (JahiaException e1) {
                        logger.error(e1.getMessage(), (Throwable)e1);
                    }
                    return null;
                }
            });
        }
        return context;
    }

    public String getDefinitionName() throws RepositoryException {
        return this.getProperty("j:definition").getString();
    }

    public void setApplication(String appId, String defName) throws RepositoryException {
        this.setProperty("j:applicationRef", appId);
        this.setProperty("j:definition", defName);
        try {
            ApplicationBean applicationBean = ServicesRegistry.getInstance().getApplicationsManagerService().getApplication(appId);
            String contextName = applicationBean.getContext();
            String prefix = Jahia.getContextPath();
            if (prefix.equals("/")) {
                prefix = "";
            }
            if (contextName.startsWith(prefix)) {
                contextName = "$context" + contextName.substring(prefix.length());
            }
            String app = contextName + "!" + defName;
            this.setProperty("j:application", app);
        }
        catch (JahiaException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public String getCacheScope() throws RepositoryException {
        return this.getProperty("j:cacheScope").getString();
    }

    public int getExpirationTime() throws RepositoryException {
        return (int)this.getProperty("j:expirationTime").getLong();
    }

    public EntryPointDefinition getEntryPointDefinition() throws JahiaException, RepositoryException {
        return ServicesRegistry.getInstance().getApplicationsManagerService().getApplicationByContext(this.getContextName()).getEntryPointDefinitionByName(this.getDefinitionName());
    }

    @Override
    public Map<String, List<JCRNodeWrapper>> getAvailableRoles() throws RepositoryException {
        HashMap<String, List<JCRNodeWrapper>> results = new HashMap<String, List<JCRNodeWrapper>>(super.getAvailableRoles());
        try {
            results.putAll(JCRPortletNode.getAvailablePermissions(this.getContextName(), this.getDefinitionName()));
        }
        catch (JahiaException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    public static Map<String, List<JCRNodeWrapper>> getAvailablePermissions(String contextName, String definitionName) throws JahiaException {
        HashMap<String, List<JCRNodeWrapper>> results = new HashMap<String, List<JCRNodeWrapper>>();
        return results;
    }
}

