/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.decorator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.collections.list.UnmodifiableList;
import org.apache.commons.collections.set.UnmodifiableSet;
import org.apache.commons.lang.StringUtils;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.decorator.JCRNodeDecorator;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.templates.TemplatePackageRegistry;
import org.jahia.utils.LanguageCodeConverters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRSiteNode
extends JCRNodeDecorator
implements JahiaSite {
    private static final Logger logger = LoggerFactory.getLogger(JCRSiteNode.class);
    private Set<String> inactiveLiveLanguages;
    private Set<String> inactiveLanguages;
    private String defaultLanguage;
    private JCRNodeWrapper home;
    private int id = -2;
    private Set<String> languages;
    private List<Locale> languagesAsLocales;
    private Set<String> mandatoryLanguages;
    private Boolean mixLanguagesActive;
    private Boolean allowsUnlistedLanguages;
    private String templateFolder;
    private String serverName;
    private Map<String, String> modules;
    private JahiaTemplatesPackage templatePackage;

    public JCRSiteNode(JCRNodeWrapper node) {
        super(node);
    }

    @Override
    public Set<String> getInactiveLiveLanguages() {
        return this.getInactiveLanguages(this.inactiveLiveLanguages, "j:inactiveLiveLanguages");
    }

    @Override
    public Set<String> getInactiveLanguages() {
        return this.getInactiveLanguages(this.inactiveLanguages, "j:inactiveLanguages");
    }

    private Set<String> getInactiveLanguages(Set<String> languages, String propertyName) {
        if (languages == null) {
            HashSet<String> langs = new HashSet<String>();
            try {
                if (this.hasProperty(propertyName)) {
                    JCRValueWrapper[] values;
                    for (JCRValueWrapper value : values = this.getProperty(propertyName).getValues()) {
                        langs.add(value.getString());
                    }
                }
                languages = UnmodifiableSet.decorate(langs);
            }
            catch (RepositoryException e) {
                logger.error("Cannot get site property", (Throwable)e);
                return null;
            }
        }
        return languages;
    }

    @Deprecated
    public List<Locale> getActiveLanguagesAsLocales() {
        return this.getActiveLiveLanguagesAsLocales();
    }

    @Deprecated
    public Set<String> getActiveLanguages() {
        return this.getActiveLiveLanguages();
    }

    public Set<String> getActiveLiveLanguages() {
        HashSet<String> langs = new HashSet<String>(this.getLanguages());
        langs.removeAll(this.getInactiveLiveLanguages());
        return langs;
    }

    public List<Locale> getActiveLiveLanguagesAsLocales() {
        return this.getLanguagesAsLocales(this.getActiveLiveLanguages());
    }

    public List<Locale> getInactiveLanguagesAsLocales() {
        return this.getLanguagesAsLocales(this.getInactiveLiveLanguages());
    }

    private List<Locale> getLanguagesAsLocales(Set<String> languages) {
        ArrayList<Locale> localeList = new ArrayList<Locale>();
        if (languages != null) {
            for (String language : languages) {
                Locale tempLocale = LanguageCodeConverters.languageCodeToLocale(language);
                localeList.add(tempLocale);
            }
        }
        return UnmodifiableList.decorate(localeList);
    }

    @Override
    public String getDefaultLanguage() {
        if (this.defaultLanguage == null) {
            try {
                if (this.hasProperty("j:defaultLanguage")) {
                    this.defaultLanguage = this.getProperty("j:defaultLanguage").getString();
                }
            }
            catch (RepositoryException e) {
                logger.error("Cannot get site property", (Throwable)e);
            }
        }
        return this.defaultLanguage;
    }

    public String getDescr() {
        return this.getDescription();
    }

    public JCRNodeWrapper getHome() throws RepositoryException {
        if (this.home == null) {
            JCRNodeIteratorWrapper ni = this.getNodes();
            while (ni.hasNext()) {
                JCRNodeWrapper next = (JCRNodeWrapper)ni.next();
                if (!next.hasProperty("j:isHomePage") || !next.getProperty("j:isHomePage").getBoolean()) continue;
                this.home = next;
                return this.home;
            }
            if (this.hasNode("home")) {
                this.home = this.getNode("home");
            }
        }
        return this.home;
    }

    public String getHtmlMarkupFilteringTags() {
        try {
            if (this.hasProperty("j:filteredTags")) {
                return this.getProperty("j:filteredTags").getString();
            }
        }
        catch (RepositoryException e) {
            logger.error("Cannot get site property j:filteredTags", (Throwable)e);
        }
        return null;
    }

    @Override
    public int getID() {
        if (this.id == -2) {
            try {
                this.id = (int)this.getProperty("j:siteId").getLong();
            }
            catch (PathNotFoundException e) {
                this.id = 0;
            }
            catch (RepositoryException e) {
                logger.error("Cannot get site property", (Throwable)e);
                this.id = -1;
            }
        }
        return this.id;
    }

    @Override
    public Set<String> getLanguages() {
        if (this.languages == null) {
            HashSet<String> langs = new HashSet<String>();
            try {
                if (this.hasProperty("j:languages")) {
                    JCRValueWrapper[] values;
                    for (JCRValueWrapper value : values = this.getProperty("j:languages").getValues()) {
                        langs.add(value.getString());
                    }
                }
                this.languages = UnmodifiableSet.decorate(langs);
            }
            catch (RepositoryException e) {
                logger.error("Cannot get site property", (Throwable)e);
                return null;
            }
        }
        return this.languages;
    }

    @Override
    public List<Locale> getLanguagesAsLocales() {
        if (this.languagesAsLocales == null) {
            Set<String> languages = this.getLanguages();
            ArrayList<Locale> localeList = new ArrayList<Locale>();
            if (languages != null) {
                for (String language : languages) {
                    Locale tempLocale = LanguageCodeConverters.languageCodeToLocale(language);
                    localeList.add(tempLocale);
                }
            }
            this.languagesAsLocales = localeList;
        }
        return this.languagesAsLocales;
    }

    @Override
    public Set<String> getMandatoryLanguages() {
        if (this.mandatoryLanguages == null) {
            HashSet<String> langs = new HashSet<String>();
            try {
                if (this.hasProperty("j:mandatoryLanguages")) {
                    JCRValueWrapper[] values;
                    for (JCRValueWrapper value : values = this.getProperty("j:mandatoryLanguages").getValues()) {
                        langs.add(value.getString());
                    }
                }
                this.mandatoryLanguages = UnmodifiableSet.decorate(langs);
            }
            catch (RepositoryException e) {
                logger.error("Cannot get site property", (Throwable)e);
                return null;
            }
        }
        return this.mandatoryLanguages;
    }

    @Override
    public JCRSiteNode getResolveSite() throws RepositoryException {
        return this;
    }

    @Override
    public String getServerName() {
        if (this.serverName == null) {
            try {
                if (this.hasProperty("j:serverName")) {
                    this.serverName = this.getProperty("j:serverName").getString();
                }
            }
            catch (RepositoryException e) {
                logger.error("Cannot get site property", (Throwable)e);
                return null;
            }
        }
        return this.serverName;
    }

    @Override
    public String getSiteKey() {
        return this.getName();
    }

    @Override
    public String getTemplateFolder() {
        if (this.templateFolder == null) {
            if (this.getPath().startsWith("/modules")) {
                this.templateFolder = this.getName();
            } else {
                try {
                    if (this.hasProperty("j:installedModules")) {
                        this.templateFolder = this.getProperty("j:installedModules").getValues()[0].getString();
                    }
                }
                catch (RepositoryException e) {
                    logger.error("Cannot get site property", (Throwable)e);
                }
            }
        }
        return StringUtils.substringBefore((String)this.templateFolder, (String)":");
    }

    @Override
    public List<String> getInstalledModules() {
        ArrayList<String> modules = new ArrayList<String>();
        try {
            if (this.getPath().startsWith("/modules")) {
                modules.add(this.getName());
            } else if (this.hasProperty("j:installedModules")) {
                JCRValueWrapper[] v = this.getProperty("j:installedModules").getValues();
                for (int i = 0; i < v.length; ++i) {
                    JCRValueWrapper value = v[i];
                    modules.add(StringUtils.substringBefore((String)value.getString(), (String)":"));
                }
            }
        }
        catch (RepositoryException e) {
            logger.error("Cannot get site property", (Throwable)e);
        }
        return modules;
    }

    public Set<String> getInstalledModulesWithAllDependencies() {
        LinkedHashSet<String> modules = new LinkedHashSet<String>(this.getInstalledModules());
        ArrayList<String> keys = new ArrayList<String>(modules);
        TemplatePackageRegistry reg = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageRegistry();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            JahiaTemplatesPackage aPackage = reg.lookupById(key);
            if (aPackage != null) {
                for (JahiaTemplatesPackage depend : aPackage.getDependencies()) {
                    if (modules.contains(depend.getId())) continue;
                    modules.add(depend.getId());
                    keys.add(depend.getId());
                }
                continue;
            }
            logger.warn("Couldn't find module '" + key + "' which is a direct or transitive dependency of the site '" + this.getName() + "'");
        }
        return modules;
    }

    public List<String> getAllInstalledModules() {
        ArrayList<String> modules = new ArrayList<String>();
        try {
            JahiaTemplatesPackage templatePackage;
            if (this.hasProperty("j:installedModules")) {
                JCRValueWrapper[] v = this.getProperty("j:installedModules").getValues();
                for (int i = 0; i < v.length; ++i) {
                    JCRValueWrapper value = v[i];
                    modules.add(StringUtils.substringBefore((String)value.getString(), (String)":"));
                }
            }
            if (this.hasProperty("j:templatesSet") && (templatePackage = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(this.getProperty("j:templatesSet").getString())) != null) {
                for (JahiaTemplatesPackage dependency : templatePackage.getDependencies()) {
                    if (modules.contains(dependency.getId())) continue;
                    modules.add(dependency.getId());
                }
            }
        }
        catch (RepositoryException e) {
            logger.error("Cannot get site property", (Throwable)e);
        }
        return modules;
    }

    public Map<String, String> getInstalledModulesWithVersions() {
        if (this.modules == null) {
            this.modules = new LinkedHashMap<String, String>();
            try {
                if (this.hasProperty("j:installedModules")) {
                    JCRValueWrapper[] v = this.getProperty("j:installedModules").getValues();
                    for (int i = 0; i < v.length; ++i) {
                        JCRValueWrapper value = v[i];
                        this.modules.put(StringUtils.substringBefore((String)value.getString(), (String)":"), StringUtils.substringAfter((String)value.getString(), (String)":"));
                    }
                }
            }
            catch (RepositoryException e) {
                logger.error("Cannot get site property", (Throwable)e);
            }
        }
        return this.modules;
    }

    @Override
    public String getTemplatePackageName() {
        JahiaTemplatesPackage pkg = this.getTemplatePackage();
        return pkg != null ? pkg.getName() : null;
    }

    public JahiaTemplatesPackage getTemplatePackage() {
        if (this.templatePackage == null) {
            this.templatePackage = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(this.getTemplateFolder());
        }
        return this.templatePackage;
    }

    @Override
    public String getTitle() {
        try {
            return this.getProperty("j:title").getString();
        }
        catch (RepositoryException e) {
            logger.error("Cannot get site property", (Throwable)e);
            return null;
        }
    }

    public boolean isHtmlMarkupFilteringEnabled() {
        try {
            if (this.hasProperty("j:doTagFiltering")) {
                return this.getProperty("j:doTagFiltering").getBoolean();
            }
        }
        catch (RepositoryException e) {
            logger.error("Cannot get site property j:doTagFiltering", (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean isMixLanguagesActive() {
        if (this.mixLanguagesActive == null) {
            this.mixLanguagesActive = false;
            try {
                if (this.hasProperty("j:mixLanguage")) {
                    this.mixLanguagesActive = this.getProperty("j:mixLanguage").getBoolean();
                }
            }
            catch (RepositoryException e) {
                logger.error("Cannot get site property", (Throwable)e);
            }
        }
        return this.mixLanguagesActive;
    }

    @Override
    public boolean isAllowsUnlistedLanguages() {
        if (this.allowsUnlistedLanguages == null) {
            this.allowsUnlistedLanguages = false;
            try {
                if (this.hasProperty("j:allowsUnlistedLanguages")) {
                    this.allowsUnlistedLanguages = this.getProperty("j:allowsUnlistedLanguages").getBoolean();
                }
            }
            catch (RepositoryException e) {
                logger.error("Cannot get site property", (Throwable)e);
            }
        }
        return this.allowsUnlistedLanguages;
    }

    public boolean isWCAGComplianceCheckEnabled() {
        try {
            if (this.hasProperty("j:wcagCompliance")) {
                return this.getProperty("j:wcagCompliance").getBoolean();
            }
        }
        catch (RepositoryException e) {
            logger.error("Cannot get site property j:wcagCompliance", (Throwable)e);
        }
        return false;
    }

    @Override
    public void setDefaultLanguage(String defaultLanguage) {
        try {
            if (this.getSession().getWorkspace().getName().equals("live")) {
                throw new UnsupportedOperationException("Get site in default workspace");
            }
            this.setProperty("j:defaultLanguage", defaultLanguage);
        }
        catch (RepositoryException e) {
            logger.error("Cannot get site property", (Throwable)e);
        }
    }

    @Override
    public void setLanguages(Set<String> languages) {
        try {
            if (this.getSession().getWorkspace().getName().equals("live")) {
                throw new UnsupportedOperationException("Get site in default workspace");
            }
            ArrayList<Value> l = new ArrayList<Value>();
            for (String s : languages) {
                if (!LanguageCodeConverters.LANGUAGE_PATTERN.matcher(s).matches()) continue;
                l.add(this.getSession().getValueFactory().createValue(s));
            }
            this.setProperty("j:languages", l.toArray(new Value[l.size()]));
            this.languages = null;
            this.languagesAsLocales = null;
            this.inactiveLanguages = null;
            this.inactiveLiveLanguages = null;
        }
        catch (RepositoryException e) {
            logger.error("Cannot get site property", (Throwable)e);
        }
    }

    @Override
    public void setMandatoryLanguages(Set<String> mandatoryLanguages) {
        try {
            if (this.getSession().getWorkspace().getName().equals("live")) {
                throw new UnsupportedOperationException("Get site in default workspace");
            }
            ArrayList<Value> l = new ArrayList<Value>();
            for (String s : mandatoryLanguages) {
                l.add(this.getSession().getValueFactory().createValue(s));
            }
            this.setProperty("j:mandatoryLanguages", l.toArray(new Value[l.size()]));
        }
        catch (RepositoryException e) {
            logger.error("Cannot get site property", (Throwable)e);
        }
    }

    @Override
    public void setMixLanguagesActive(boolean mixLanguagesActive) {
        try {
            if (this.getSession().getWorkspace().getName().equals("live")) {
                throw new UnsupportedOperationException("Get site in default workspace");
            }
            this.setProperty("j:mixLanguage", mixLanguagesActive);
            this.mixLanguagesActive = mixLanguagesActive;
        }
        catch (RepositoryException e) {
            logger.error("Cannot get site property", (Throwable)e);
        }
    }

    public void setAllowsUnlistedLanguages(Boolean allowsUnlistedLanguages) {
        try {
            if (this.getSession().getWorkspace().getName().equals("live")) {
                throw new UnsupportedOperationException("Get site in default workspace");
            }
            this.setProperty("j:allowsUnlistedLanguages", allowsUnlistedLanguages);
            this.allowsUnlistedLanguages = allowsUnlistedLanguages;
        }
        catch (RepositoryException e) {
            logger.error("Cannot get site property", (Throwable)e);
        }
    }

    @Override
    public String getDescription() {
        try {
            if (this.hasProperty("j:description")) {
                return this.getProperty("j:description").getString();
            }
        }
        catch (RepositoryException e) {
            logger.error("Cannot get site property", (Throwable)e);
        }
        return null;
    }

    @Override
    public boolean isDefault() {
        try {
            return this.getParent().getProperty("j:defaultSite").getString().equals(this.getIdentifier());
        }
        catch (RepositoryException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public void setDescr(String descr) {
        this.setDescription(descr);
    }

    @Override
    public void setDescription(String description) {
        try {
            if (this.getSession().getWorkspace().getName().equals("live")) {
                throw new UnsupportedOperationException("Get site in default workspace");
            }
            this.setProperty("j:description", description);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void setInactiveLanguages(Set<String> inactiveLanguages) {
        try {
            if (this.getSession().getWorkspace().getName().equals("live")) {
                throw new UnsupportedOperationException("Get site in default workspace");
            }
            ArrayList<Value> l = new ArrayList<Value>();
            for (String s : inactiveLanguages) {
                l.add(this.getSession().getValueFactory().createValue(s));
            }
            this.setProperty("j:inactiveLanguages", l.toArray(new Value[l.size()]));
        }
        catch (RepositoryException e) {
            logger.error("Cannot get site property", (Throwable)e);
        }
    }

    @Override
    public void setInactiveLiveLanguages(Set<String> inactiveLiveLanguages) {
        try {
            if (this.getSession().getWorkspace().getName().equals("live")) {
                throw new UnsupportedOperationException("Get site in default workspace");
            }
            ArrayList<Value> l = new ArrayList<Value>();
            for (String s : inactiveLiveLanguages) {
                l.add(this.getSession().getValueFactory().createValue(s));
            }
            this.setProperty("j:inactiveLiveLanguages", l.toArray(new Value[l.size()]));
        }
        catch (RepositoryException e) {
            logger.error("Cannot get site property", (Throwable)e);
        }
    }

    @Override
    public void setInstalledModules(List<String> installedModules) {
        try {
            if (this.getSession().getWorkspace().getName().equals("live")) {
                throw new UnsupportedOperationException("Get site in default workspace");
            }
            ArrayList<Value> l = new ArrayList<Value>();
            for (String s : installedModules) {
                l.add(this.getSession().getValueFactory().createValue(s));
            }
            this.setProperty("j:installedModules", l.toArray(new Value[l.size()]));
        }
        catch (RepositoryException e) {
            logger.error("Cannot get site property", (Throwable)e);
        }
    }

    @Override
    public void setAllowsUnlistedLanguages(boolean allowsUnlistedLanguages) {
        try {
            if (this.getSession().getWorkspace().getName().equals("live")) {
                throw new UnsupportedOperationException("Get site in default workspace");
            }
            this.setProperty("j:allowsUnlistedLanguages", allowsUnlistedLanguages);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void setServerName(String name) {
        try {
            if (this.getSession().getWorkspace().getName().equals("live")) {
                throw new UnsupportedOperationException("Get site in default workspace");
            }
            this.setProperty("j:serverName", name);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void setTitle(String value) {
        try {
            if (this.getSession().getWorkspace().getName().equals("live")) {
                throw new UnsupportedOperationException("Get site in default workspace");
            }
            this.setProperty("j:title", value);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getJCRLocalPath() {
        return this.getPath();
    }
}

