/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.decorator;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Binary;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.value.BinaryImpl;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRPropertyWrapperImpl;
import org.jahia.services.content.LazyPropertyIterator;
import org.jahia.services.content.decorator.JCRNodeDecorator;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.content.nodetypes.ValueImpl;
import org.jahia.services.usermanager.JahiaExternalUser;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.UserProperties;
import org.jahia.services.usermanager.UserPropertyReadOnlyException;
import org.jahia.services.usermanager.jcr.JCRUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRUserNode
extends JCRNodeDecorator {
    private static transient Logger logger = LoggerFactory.getLogger(JCRUserNode.class);
    private JahiaUser user;
    private Map<String, ExtendedPropertyDefinition> propertyDefinitionMap;
    private Map<Integer, ExtendedPropertyDefinition> unstructuredPropertyDefinitions;
    public final List<String> publicProperties = Arrays.asList("j:external", "j:externalSource", "j:publicProperties");

    public JCRUserNode(JCRNodeWrapper node) {
        super(node);
        try {
            ExtendedNodeType type = NodeTypeRegistry.getInstance().getNodeType("jnt:user");
            this.propertyDefinitionMap = type.getPropertyDefinitionsAsMap();
            this.unstructuredPropertyDefinitions = type.getUnstructuredPropertyDefinitions();
        }
        catch (NoSuchNodeTypeException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public PropertyIterator getProperties() throws RepositoryException {
        Locale locale = this.getSession().getLocale();
        return new LazyPropertyIterator(this, locale){

            @Override
            protected PropertyIterator getPropertiesIterator() {
                if (this.propertyIterator == null) {
                    if (JCRUserNode.this.user == null) {
                        JCRUserNode.this.user = JCRUserNode.this.lookupUser();
                    }
                    if (JCRUserNode.this.user == null || JCRUserNode.this.user instanceof JCRUser) {
                        this.propertyIterator = new FilteredPropertyIterator(super.getPropertiesIterator());
                    } else {
                        try {
                            this.propertyIterator = new UserPropertyIterator(this.node, new FilteredPropertyIterator(super.getPropertiesIterator()));
                        }
                        catch (RepositoryException e) {
                            logger.error("Cannot get user properties");
                            this.propertyIterator = new FilteredPropertyIterator(super.getPropertiesIterator());
                        }
                    }
                    this.propertyIterator = new FilteredPropertyIterator(super.getPropertiesIterator());
                }
                return this.propertyIterator;
            }

            @Override
            protected PropertyIterator getI18NPropertyIterator() {
                if (this.i18nPropertyIterator == null) {
                    return new FilteredPropertyIterator(super.getI18NPropertyIterator());
                }
                return this.i18nPropertyIterator;
            }
        };
    }

    @Override
    public JCRPropertyWrapper getProperty(String s) throws PathNotFoundException, RepositoryException {
        String property;
        if ("j:external".equals(s) || "j:checkinDate".equals(s)) {
            return super.getProperty(s);
        }
        if (!this.canGetProperty(s)) {
            throw new PathNotFoundException(s);
        }
        if (this.user == null) {
            this.user = this.lookupUser();
        }
        if (this.user == null || this.user instanceof JCRUser) {
            return super.getProperty(s);
        }
        boolean isExternal = this.user instanceof JahiaExternalUser;
        String string = property = isExternal ? ((JahiaExternalUser)this.user).getExternalProperties().getProperty(s) : this.user.getProperty(s);
        if (property == null && isExternal) {
            property = this.user.getUserProperties().getProperty(s);
        }
        if (null == property) {
            return super.getProperty(s);
        }
        ExtendedPropertyDefinition def = this.propertyDefinitionMap.get(s);
        if (def == null) {
            def = this.unstructuredPropertyDefinitions.get(1);
        }
        return new JCRPropertyWrapperImpl(this.node, new JCRUserProperty(s, property, def.getRequiredType()), this.node.getSession(), this.node.getJCRProvider(), def);
    }

    @Override
    public boolean hasProperty(String s) throws RepositoryException {
        String property;
        if (this.user == null) {
            this.user = this.lookupUser();
        }
        if (this.user == null || this.user instanceof JCRUser) {
            boolean b = super.hasProperty(s);
            return b && this.canGetProperty(s);
        }
        boolean isExternal = this.user instanceof JahiaExternalUser;
        String string = property = isExternal ? ((JahiaExternalUser)this.user).getExternalProperties().getProperty(s) : this.user.getProperty(s);
        if (property == null && isExternal) {
            property = this.user.getUserProperties().getProperty(s);
        }
        if (property == null) {
            return super.hasProperty(s) && this.canGetProperty(s);
        }
        return this.canGetProperty(s);
    }

    @Override
    public Map<String, String> getPropertiesAsString() throws RepositoryException {
        if (this.user == null) {
            this.user = this.lookupUser();
        }
        Set<Map.Entry<Object, Object>> entries = this.user == null || this.user instanceof JCRUser ? super.getPropertiesAsString().entrySet() : this.user.getProperties().entrySet();
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : entries) {
            if (!this.canGetProperty(entry.getKey().toString())) continue;
            map.put(entry.getKey().toString(), entry.getValue() != null ? entry.getValue().toString() : null);
        }
        return map;
    }

    @Override
    public String getPropertyAsString(String name) {
        try {
            String property;
            if ("j:external".equals(name) || "j:checkinDate".equals(name)) {
                return super.getPropertyAsString(name);
            }
            if (!this.canGetProperty(name)) {
                return null;
            }
            if (this.user == null) {
                this.user = this.lookupUser();
            }
            if (this.user == null || this.user instanceof JCRUser) {
                return super.getPropertyAsString(name);
            }
            String string = property = this.user instanceof JahiaExternalUser ? ((JahiaExternalUser)this.user).getExternalProperties().getProperty(name) : this.user.getProperty(name);
            if (null == property) {
                return super.getPropertyAsString(name);
            }
            return property;
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    @Override
    public JCRPropertyWrapper setProperty(String s, String value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.setProperty(s, value, 1);
    }

    @Override
    public JCRPropertyWrapper setProperty(String s, String value, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if ("j:external".equals(s) || "j:checkinDate".equals(s)) {
            return super.setProperty(s, value, type);
        }
        if (this.user == null) {
            this.user = this.lookupUser();
        }
        if (this.user == null || this.user instanceof JCRUser) {
            return super.setProperty(s, value, type);
        }
        if (this.user instanceof JahiaExternalUser && ((JahiaExternalUser)this.user).getExternalProperties().hasProperty(s) || !(this.user instanceof JahiaExternalUser) && this.user.getProperty(s) != null) {
            throw new AccessDeniedException("Cannot update external property");
        }
        JCRPropertyWrapper prop = super.setProperty(s, value, type);
        try {
            this.user.getUserProperties().setProperty(s, value);
        }
        catch (UserPropertyReadOnlyException e) {
            logger.warn("Cannot set read-only property {} for user {}", (Object)s, (Object)this.user.getUserKey());
        }
        return prop;
    }

    @Override
    public JCRPropertyWrapper setProperty(String s, Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if ("j:external".equals(s) || "j:checkinDate".equals(s)) {
            return super.setProperty(s, value);
        }
        if (this.user == null) {
            this.user = this.lookupUser();
        }
        if (this.user == null || this.user instanceof JCRUser) {
            return super.setProperty(s, value);
        }
        if (this.user instanceof JahiaExternalUser && ((JahiaExternalUser)this.user).getExternalProperties().hasProperty(s) || !(this.user instanceof JahiaExternalUser) && this.user.getProperty(s) != null) {
            throw new AccessDeniedException("Cannot update external property");
        }
        JCRPropertyWrapper prop = super.setProperty(s, value);
        try {
            this.user.getUserProperties().setProperty(s, value.getString());
        }
        catch (UserPropertyReadOnlyException e) {
            logger.warn("Cannot set read-only property {} for user {}", (Object)s, (Object)this.user.getUserKey());
        }
        return prop;
    }

    public boolean isPropertyEditable(String name) {
        try {
            if ("j:external".equals(name) || "j:checkinDate".equals(name)) {
                return false;
            }
            if (!this.canGetProperty(name)) {
                return false;
            }
            if (this.user == null) {
                this.user = this.lookupUser();
            }
            if (this.user == null || this.user instanceof JCRUser) {
                return true;
            }
            return this.user instanceof JahiaExternalUser && !((JahiaExternalUser)this.user).getExternalProperties().hasProperty(name);
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean isRoot() {
        if (this.user == null) {
            this.user = this.lookupUser();
        }
        return this.user.isRoot();
    }

    private boolean canGetProperty(String s) throws RepositoryException {
        Value[] values;
        if (this.publicProperties.contains(s) || this.hasPermission("jcr:write")) {
            return true;
        }
        if (!super.hasProperty("j:publicProperties")) {
            return false;
        }
        JCRPropertyWrapper p = super.getProperty("j:publicProperties");
        for (Value value : values = p.getValues()) {
            if (!s.equals(value.getString())) continue;
            return true;
        }
        return false;
    }

    protected JahiaUser lookupUser() {
        return ServicesRegistry.getInstance().getJahiaUserManagerService().lookupUser(this.node.getName());
    }

    public class JCRUserProperty
    implements Property {
        private final String key;
        private final Object value;
        private int type;

        public JCRUserProperty(String key, Object value) {
            this(key, value, 1);
        }

        public JCRUserProperty(String key, Object value, int type) {
            this.key = key;
            this.value = value;
            this.type = type;
        }

        public void setValue(Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        }

        public void setValue(Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        }

        public void setValue(String value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        }

        public void setValue(String[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        }

        public void setValue(InputStream value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        }

        public void setValue(Binary value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        }

        public void setValue(long value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        }

        public void setValue(double value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        }

        public void setValue(BigDecimal value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        }

        public void setValue(Calendar value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        }

        public void setValue(boolean value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        }

        public void setValue(Node value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        }

        public Value getValue() throws ValueFormatException, RepositoryException {
            return new ValueImpl(this.value.toString(), this.type);
        }

        public Value[] getValues() throws ValueFormatException, RepositoryException {
            throw new ValueFormatException();
        }

        public String getString() throws ValueFormatException, RepositoryException {
            return this.value.toString();
        }

        public InputStream getStream() throws ValueFormatException, RepositoryException {
            return new ByteArrayInputStream(this.value.toString().getBytes());
        }

        public Binary getBinary() throws ValueFormatException, RepositoryException {
            try {
                return new BinaryImpl((InputStream)new ByteArrayInputStream(this.value.toString().getBytes()));
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }

        public long getLong() throws ValueFormatException, RepositoryException {
            try {
                return Long.parseLong(this.value.toString());
            }
            catch (NumberFormatException e) {
                throw new ValueFormatException((Throwable)e);
            }
        }

        public double getDouble() throws ValueFormatException, RepositoryException {
            try {
                return Double.parseDouble(this.value.toString());
            }
            catch (NumberFormatException e) {
                throw new ValueFormatException((Throwable)e);
            }
        }

        public BigDecimal getDecimal() throws ValueFormatException, RepositoryException {
            return new BigDecimal(this.value.toString());
        }

        public Calendar getDate() throws ValueFormatException, RepositoryException {
            Calendar calendar = ISO8601.parse((String)this.value.toString());
            if (calendar == null) {
                throw new ValueFormatException();
            }
            return calendar;
        }

        public boolean getBoolean() throws ValueFormatException, RepositoryException {
            try {
                return Boolean.parseBoolean(this.value.toString());
            }
            catch (NumberFormatException e) {
                throw new ValueFormatException((Throwable)e);
            }
        }

        public Node getNode() throws ItemNotFoundException, ValueFormatException, RepositoryException {
            throw new ValueFormatException();
        }

        public Property getProperty() throws ItemNotFoundException, ValueFormatException, RepositoryException {
            throw new ValueFormatException();
        }

        public long getLength() throws ValueFormatException, RepositoryException {
            return this.value.toString().length();
        }

        public long[] getLengths() throws ValueFormatException, RepositoryException {
            throw new ValueFormatException();
        }

        public PropertyDefinition getDefinition() throws RepositoryException {
            throw new RepositoryException("Cannot get property definition");
        }

        public int getType() throws RepositoryException {
            return this.type;
        }

        public boolean isMultiple() throws RepositoryException {
            return false;
        }

        public String getPath() throws RepositoryException {
            return JCRUserNode.this.node.getPath() + "/" + this.getName();
        }

        public String getName() throws RepositoryException {
            return this.key;
        }

        public Item getAncestor(int depth) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
            throw new AccessDeniedException();
        }

        public Node getParent() throws ItemNotFoundException, AccessDeniedException, RepositoryException {
            return JCRUserNode.this.node;
        }

        public int getDepth() throws RepositoryException {
            return JCRUserNode.this.node.getDepth() + 1;
        }

        public Session getSession() throws RepositoryException {
            throw new RepositoryException("Cannot get session");
        }

        public boolean isNode() {
            return false;
        }

        public boolean isNew() {
            return false;
        }

        public boolean isModified() {
            return false;
        }

        public boolean isSame(Item otherItem) throws RepositoryException {
            return false;
        }

        public void accept(ItemVisitor visitor) throws RepositoryException {
        }

        public void save() throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, ReferentialIntegrityException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        }

        public void refresh(boolean keepChanges) throws InvalidItemStateException, RepositoryException {
        }

        public void remove() throws VersionException, LockException, ConstraintViolationException, AccessDeniedException, RepositoryException {
        }
    }

    public class UserPropertyIterator
    implements PropertyIterator {
        Map<String, Property> jcrProperties;
        UserProperties externalProperties;
        private Set<String> stringPropertyNames;
        private Iterator<String> iterator;
        private int index = 0;
        private final JCRNodeWrapper node;

        private UserPropertyIterator(JCRNodeWrapper node, PropertyIterator jcrPropertyIterator) throws RepositoryException {
            this.node = node;
            this.externalProperties = JCRUserNode.this.user instanceof JahiaExternalUser ? ((JahiaExternalUser)JCRUserNode.this.user).getExternalProperties() : JCRUserNode.this.user.getUserProperties();
            this.jcrProperties = new HashMap<String, Property>();
            while (jcrPropertyIterator.hasNext()) {
                Property prop = jcrPropertyIterator.nextProperty();
                if (this.externalProperties.hasProperty(prop.getName())) continue;
                this.jcrProperties.put(prop.getName(), prop);
            }
            this.stringPropertyNames = new HashSet<String>(this.jcrProperties.keySet());
            for (Object key : this.externalProperties.getProperties().keySet()) {
                this.stringPropertyNames.add(key.toString());
            }
            this.iterator = this.stringPropertyNames.iterator();
        }

        public Property nextProperty() {
            String key = this.iterator.next();
            ++this.index;
            if (this.externalProperties.hasProperty(key)) {
                String value = this.externalProperties.getProperty(key);
                try {
                    return new JCRPropertyWrapperImpl(this.node, new JCRUserProperty(key, value), this.node.getSession(), this.node.getJCRProvider(), JCRUserNode.this.propertyDefinitionMap.get(key) != null ? (ExtendedPropertyDefinition)JCRUserNode.this.propertyDefinitionMap.get(key) : (ExtendedPropertyDefinition)JCRUserNode.this.unstructuredPropertyDefinitions.get(1));
                }
                catch (RepositoryException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            } else if (this.jcrProperties.containsKey(key)) {
                return this.jcrProperties.get(key);
            }
            throw new NoSuchElementException();
        }

        public void skip(long skipNum) {
            if (skipNum < (long)this.stringPropertyNames.size()) {
                for (long j = 0L; j < skipNum; ++j) {
                    this.iterator.next();
                    ++this.index;
                }
            } else {
                throw new NoSuchElementException(skipNum + " is out of bounds for this properties size : " + this.stringPropertyNames.size());
            }
        }

        public long getSize() {
            return this.stringPropertyNames.size();
        }

        public long getPosition() {
            return this.index;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return this.nextProperty();
        }

        public void remove() {
            throw new UnsupportedOperationException("Not implemented");
        }
    }

    public class FilteredPropertyIterator
    implements PropertyIterator {
        private PropertyIterator propertyIterator;
        private Property nextProperty;

        public FilteredPropertyIterator(PropertyIterator propertyIterator) {
            this.propertyIterator = propertyIterator;
            this.prefetch();
        }

        public Property nextProperty() {
            return (Property)this.next();
        }

        public void skip(long skipNum) {
            int i = 0;
            while ((long)i < skipNum) {
                this.next();
                ++i;
            }
        }

        public long getSize() {
            return this.propertyIterator.getSize();
        }

        public long getPosition() {
            return this.propertyIterator.getPosition();
        }

        public boolean hasNext() {
            return this.nextProperty != null;
        }

        public Object next() {
            Property next = this.nextProperty;
            this.prefetch();
            return next;
        }

        private void prefetch() {
            try {
                do {
                    this.nextProperty = this.propertyIterator.hasNext() ? this.propertyIterator.nextProperty() : null;
                } while (this.nextProperty != null && !JCRUserNode.this.canGetProperty(this.nextProperty.getName()));
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }

        public void remove() {
            this.propertyIterator.remove();
        }
    }
}

