/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.decorator;

import java.util.ArrayList;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.NodeIteratorImpl;
import org.jahia.services.content.VersionIteratorImpl;
import org.jahia.services.content.decorator.JCRNodeDecorator;
import org.jahia.services.content.decorator.JCRVersion;

public class JCRVersionHistory
extends JCRNodeDecorator
implements VersionHistory {
    public JCRVersionHistory(JCRNodeWrapper node) {
        super(node);
    }

    public VersionHistory getRealNode() {
        return (VersionHistory)super.getRealNode();
    }

    public JCRNodeWrapper getNode() throws RepositoryException {
        PropertyIterator pi = this.getRealNode().getReferences();
        if (pi.hasNext()) {
            Property p = pi.nextProperty();
            return this.getProvider().getNodeWrapper(p.getParent(), this.getSession());
        }
        throw new ItemNotFoundException();
    }

    public String getVersionableUUID() throws RepositoryException {
        return this.getRealNode().getVersionableUUID();
    }

    public JCRVersion getRootVersion() throws RepositoryException {
        return (JCRVersion)this.getProvider().getNodeWrapper((Node)this.getRealNode().getRootVersion(), this.getSession());
    }

    public VersionIterator getAllVersions() throws RepositoryException {
        VersionIterator all = this.getRealNode().getAllVersions();
        ArrayList<JCRNodeWrapper> l = new ArrayList<JCRNodeWrapper>();
        while (all.hasNext()) {
            Version v = all.nextVersion();
            l.add(this.getProvider().getNodeWrapper((Node)v, this.getSession()));
        }
        return new VersionIteratorImpl(l.iterator(), (long)l.size());
    }

    public JCRVersion getVersion(String s) throws VersionException, RepositoryException {
        return (JCRVersion)this.getProvider().getNodeWrapper((Node)this.getRealNode().getVersion(s), this.getSession());
    }

    public JCRVersion getVersionByLabel(String s) throws RepositoryException {
        return (JCRVersion)this.getProvider().getNodeWrapper((Node)this.getRealNode().getVersionByLabel(s), this.getSession());
    }

    public void addVersionLabel(String s, String s1, boolean b) throws VersionException, RepositoryException {
        this.getRealNode().addVersionLabel(s, s1, b);
    }

    public void removeVersionLabel(String s) throws VersionException, RepositoryException {
        this.getRealNode().removeVersionLabel(s);
    }

    public boolean hasVersionLabel(String s) throws RepositoryException {
        return this.getRealNode().hasVersionLabel(s);
    }

    public boolean hasVersionLabel(Version version, String s) throws VersionException, RepositoryException {
        return this.getRealNode().hasVersionLabel(((JCRVersion)version).getRealNode(), s);
    }

    public String[] getVersionLabels() throws RepositoryException {
        return this.getRealNode().getVersionLabels();
    }

    public String[] getVersionLabels(Version version) throws VersionException, RepositoryException {
        return this.getRealNode().getVersionLabels(((JCRVersion)version).getRealNode());
    }

    public void removeVersion(String s) throws ReferentialIntegrityException, AccessDeniedException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        this.getRealNode().removeVersion(s);
    }

    public String getVersionableIdentifier() throws RepositoryException {
        return this.getRealNode().getVersionableIdentifier();
    }

    public VersionIterator getAllLinearVersions() throws RepositoryException {
        VersionIterator vi = this.getRealNode().getAllLinearVersions();
        ArrayList<Version> l = new ArrayList<Version>();
        while (vi.hasNext()) {
            l.add((Version)this.getProvider().getNodeWrapper((Node)vi.nextVersion(), this.getSession()));
        }
        return new VersionIteratorImpl(l.iterator(), (long)l.size());
    }

    public NodeIterator getAllLinearFrozenNodes() throws RepositoryException {
        NodeIterator vi = this.getRealNode().getAllLinearFrozenNodes();
        ArrayList<JCRNodeWrapper> l = new ArrayList<JCRNodeWrapper>();
        while (vi.hasNext()) {
            l.add(this.getProvider().getNodeWrapper(vi.nextNode(), this.getSession()));
        }
        return new NodeIteratorImpl(l.iterator(), (long)l.size());
    }

    public NodeIterator getAllFrozenNodes() throws RepositoryException {
        NodeIterator vi = this.getRealNode().getAllFrozenNodes();
        ArrayList<JCRNodeWrapper> l = new ArrayList<JCRNodeWrapper>();
        while (vi.hasNext()) {
            l.add(this.getProvider().getNodeWrapper(vi.nextNode(), this.getSession()));
        }
        return new NodeIteratorImpl(l.iterator(), (long)l.size());
    }

    @Override
    public Lock getLock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        throw new LockException("VersionHistory node are not lockable");
    }
}

