/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.files;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.Patterns;

public class StaticFileServlet
extends HttpServlet {
    private static final long serialVersionUID = 7704264638970146054L;
    private static final Pattern PATTERN_ACCEPT_HEADER_REPLACE = Pattern.compile("/.*$");
    private static final Pattern PATTERN_ACCEPT_HEADER_SPLIT = Pattern.compile("\\s*(,|;)\\s*");
    private static final Pattern PATTERN_MATCH_HEADER_SPLIT = Pattern.compile("\\s*,\\s*");
    private static final Pattern PATTERN_RANGE = Pattern.compile("^bytes=\\d*-\\d*(,\\d*-\\d*)*$");
    private static final int DEFAULT_BUFFER_SIZE = 10240;
    private static final long DEFAULT_EXPIRE_TIME = 604800000L;
    private static final String MULTIPART_BOUNDARY = "MULTIPART_BYTERANGES";
    private String basePath;
    private boolean enableGzip;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.basePath = SettingsBean.getInstance().getJahiaVarDiskPath() + File.separator + StringUtils.defaultString((String)config.getInitParameter("generated-resources-dir-name"), (String)"generated-resources");
        this.enableGzip = Boolean.valueOf(StringUtils.defaultString((String)config.getInitParameter("enable-gzip"), (String)"true"));
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response, false);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(HttpServletRequest request, HttpServletResponse response, boolean content) throws IOException {
        String requestedFile = request.getPathInfo();
        if (requestedFile == null) {
            response.sendError(404);
            return;
        }
        File file = new File(this.basePath, URLDecoder.decode(requestedFile, "UTF-8"));
        if (!file.exists()) {
            response.sendError(404);
            return;
        }
        String fileName = file.getName();
        long length = file.length();
        long lastModified = file.lastModified();
        String eTag = fileName + "_" + length + "_" + lastModified;
        long expires = System.currentTimeMillis() + 604800000L;
        String ifNoneMatch = request.getHeader("If-None-Match");
        if (ifNoneMatch != null && StaticFileServlet.matches(ifNoneMatch, eTag)) {
            response.setStatus(304);
            response.setHeader("ETag", eTag);
            response.setDateHeader("Expires", expires);
            return;
        }
        long ifModifiedSince = request.getDateHeader("If-Modified-Since");
        if (ifNoneMatch == null && ifModifiedSince != -1L && ifModifiedSince + 1000L > lastModified) {
            response.setStatus(304);
            response.setHeader("ETag", eTag);
            response.setDateHeader("Expires", expires);
            return;
        }
        String ifMatch = request.getHeader("If-Match");
        if (ifMatch != null && !StaticFileServlet.matches(ifMatch, eTag)) {
            response.sendError(412);
            return;
        }
        long ifUnmodifiedSince = request.getDateHeader("If-Unmodified-Since");
        if (ifUnmodifiedSince != -1L && ifUnmodifiedSince + 1000L <= lastModified) {
            response.sendError(412);
            return;
        }
        Range full = new Range(0L, length - 1L, length);
        ArrayList<Range> ranges = new ArrayList<Range>();
        String range = request.getHeader("Range");
        if (range != null) {
            if (!PATTERN_RANGE.matcher(range).matches()) {
                response.setHeader("Content-Range", "bytes */" + length);
                response.sendError(416);
                return;
            }
            String ifRange = request.getHeader("If-Range");
            if (ifRange != null && !ifRange.equals(eTag)) {
                try {
                    long ifRangeTime = request.getDateHeader("If-Range");
                    if (ifRangeTime != -1L && ifRangeTime + 1000L < lastModified) {
                        ranges.add(full);
                    }
                }
                catch (IllegalArgumentException ignore) {
                    ranges.add(full);
                }
            }
            if (ranges.isEmpty()) {
                for (String part : Patterns.COMMA.split(range.substring(6))) {
                    long start = StaticFileServlet.sublong(part, 0, part.indexOf("-"));
                    long end = StaticFileServlet.sublong(part, part.indexOf("-") + 1, part.length());
                    if (start == -1L) {
                        start = length - end;
                        end = length - 1L;
                    } else if (end == -1L || end > length - 1L) {
                        end = length - 1L;
                    }
                    if (start > end) {
                        response.setHeader("Content-Range", "bytes */" + length);
                        response.sendError(416);
                        return;
                    }
                    ranges.add(new Range(start, end, length));
                }
            }
        }
        String contentType = this.getServletContext().getMimeType(fileName);
        boolean acceptsGzip = false;
        String disposition = "inline";
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        if (contentType.startsWith("text")) {
            String acceptEncoding = request.getHeader("Accept-Encoding");
            acceptsGzip = this.enableGzip && acceptEncoding != null && StaticFileServlet.accepts(acceptEncoding, "gzip");
            contentType = contentType + ";charset=UTF-8";
        } else if (!contentType.startsWith("image")) {
            String accept = request.getHeader("Accept");
            disposition = accept != null && StaticFileServlet.accepts(accept, contentType) ? "inline" : "attachment";
        }
        response.reset();
        response.setBufferSize(10240);
        response.setHeader("Content-Disposition", disposition + ";filename=\"" + fileName + "\"");
        response.setHeader("Accept-Ranges", "bytes");
        response.setHeader("ETag", eTag);
        response.setDateHeader("Last-Modified", lastModified);
        response.setDateHeader("Expires", expires);
        RandomAccessFile input = null;
        Object output = null;
        try {
            input = new RandomAccessFile(file, "r");
            output = response.getOutputStream();
            if (ranges.isEmpty() || ranges.get(0) == full) {
                Range r = full;
                response.setContentType(contentType);
                response.setHeader("Content-Range", "bytes " + r.start + "-" + r.end + "/" + r.total);
                if (content) {
                    if (acceptsGzip) {
                        response.setHeader("Content-Encoding", "gzip");
                        output = new GZIPOutputStream((OutputStream)output, 10240);
                    } else {
                        response.setHeader("Content-Length", String.valueOf(r.length));
                    }
                    StaticFileServlet.copy(input, (OutputStream)output, r.start, r.length);
                }
            } else if (ranges.size() == 1) {
                Range r = (Range)ranges.get(0);
                response.setContentType(contentType);
                response.setHeader("Content-Range", "bytes " + r.start + "-" + r.end + "/" + r.total);
                response.setHeader("Content-Length", String.valueOf(r.length));
                response.setStatus(206);
                if (content) {
                    StaticFileServlet.copy(input, (OutputStream)output, r.start, r.length);
                }
            } else {
                response.setContentType("multipart/byteranges; boundary=MULTIPART_BYTERANGES");
                response.setStatus(206);
                if (content) {
                    ServletOutputStream sos = output;
                    for (Range r : ranges) {
                        sos.println();
                        sos.println("--MULTIPART_BYTERANGES");
                        sos.println("Content-Type: " + contentType);
                        sos.println("Content-Range: bytes " + r.start + "-" + r.end + "/" + r.total);
                        StaticFileServlet.copy(input, (OutputStream)output, r.start, r.length);
                    }
                    sos.println();
                    sos.println("--MULTIPART_BYTERANGES--");
                }
            }
        }
        catch (Throwable throwable) {
            StaticFileServlet.close(output);
            StaticFileServlet.close(input);
            throw throwable;
        }
        StaticFileServlet.close((Closeable)output);
        StaticFileServlet.close(input);
    }

    private static boolean accepts(String acceptHeader, String toAccept) {
        Object[] acceptValues = PATTERN_ACCEPT_HEADER_SPLIT.split(acceptHeader);
        Arrays.sort(acceptValues);
        return Arrays.binarySearch(acceptValues, toAccept) > -1 || Arrays.binarySearch(acceptValues, PATTERN_ACCEPT_HEADER_REPLACE.matcher(toAccept).replaceAll("/*")) > -1 || Arrays.binarySearch(acceptValues, "*/*") > -1;
    }

    private static boolean matches(String matchHeader, String toMatch) {
        Object[] matchValues = PATTERN_MATCH_HEADER_SPLIT.split(matchHeader);
        Arrays.sort(matchValues);
        return Arrays.binarySearch(matchValues, toMatch) > -1 || Arrays.binarySearch(matchValues, "*") > -1;
    }

    private static long sublong(String value, int beginIndex, int endIndex) {
        String substring = value.substring(beginIndex, endIndex);
        return substring.length() > 0 ? Long.parseLong(substring) : -1L;
    }

    private static void copy(RandomAccessFile input, OutputStream output, long start, long length) throws IOException {
        byte[] buffer = new byte[10240];
        if (input.length() == length) {
            int read;
            while ((read = input.read(buffer)) > 0) {
                output.write(buffer, 0, read);
            }
        } else {
            int read;
            input.seek(start);
            long toRead = length;
            while ((read = input.read(buffer)) > 0) {
                if ((toRead -= (long)read) > 0L) {
                    output.write(buffer, 0, read);
                    continue;
                }
                output.write(buffer, 0, (int)toRead + read);
                break;
            }
        }
    }

    private static void close(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected class Range {
        long start;
        long end;
        long length;
        long total;

        public Range(long start, long end, long total) {
            this.start = start;
            this.end = end;
            this.length = end - start + 1L;
            this.total = total;
        }
    }
}

