/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes;

import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Value;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeTypeExistsException;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.nodetypes.DynamicValueImpl;
import org.jahia.services.content.nodetypes.ExtendedItemDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.Lexer;
import org.jahia.services.content.nodetypes.Name;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.content.nodetypes.ParseException;
import org.jahia.services.content.nodetypes.ValueImpl;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaCndReader {
    private static Logger logger = LoggerFactory.getLogger(JahiaCndReader.class);
    private boolean hasEncounteredIssuesWithDefinitions = false;
    protected String systemId;
    protected String filename;
    protected NodeTypeRegistry registry;
    protected List<ExtendedNodeType> nodeTypesList = new LinkedList<ExtendedNodeType>();
    protected Lexer lexer;
    protected String currentToken;
    protected boolean doRegister = true;
    protected List<String> parsingErrors = new ArrayList<String>();

    protected static boolean tokenEquals(String token, String[] s) {
        for (String e : s) {
            if (!token.equals(e)) continue;
            return true;
        }
        return false;
    }

    public static int getPropertyType(String token) {
        if (JahiaCndReader.tokenEquals(token, Lexer.STRING)) {
            return 1;
        }
        if (JahiaCndReader.tokenEquals(token, Lexer.BINARY)) {
            return 2;
        }
        if (JahiaCndReader.tokenEquals(token, Lexer.LONG)) {
            return 3;
        }
        if (JahiaCndReader.tokenEquals(token, Lexer.DOUBLE)) {
            return 4;
        }
        if (JahiaCndReader.tokenEquals(token, Lexer.BOOLEAN)) {
            return 6;
        }
        if (JahiaCndReader.tokenEquals(token, Lexer.DATE)) {
            return 5;
        }
        if (JahiaCndReader.tokenEquals(token, Lexer.NAME)) {
            return 7;
        }
        if (JahiaCndReader.tokenEquals(token, Lexer.PATH)) {
            return 8;
        }
        if (JahiaCndReader.tokenEquals(token, Lexer.REFERENCE)) {
            return 9;
        }
        if (JahiaCndReader.tokenEquals(token, Lexer.WEAKREFERENCE)) {
            return 10;
        }
        if (JahiaCndReader.tokenEquals(token, Lexer.URI)) {
            return 11;
        }
        if (JahiaCndReader.tokenEquals(token, Lexer.DECIMAL)) {
            return 12;
        }
        if (JahiaCndReader.tokenEquals(token, Lexer.UNDEFINED)) {
            return 0;
        }
        return -1;
    }

    public static int getSelectorType(String token) {
        if (JahiaCndReader.tokenEquals(token, Lexer.SMALLTEXT)) {
            return 1;
        }
        if (JahiaCndReader.tokenEquals(token, Lexer.RICHTEXT)) {
            return 2;
        }
        if (JahiaCndReader.tokenEquals(token, Lexer.TEXTAREA)) {
            return 5;
        }
        if (JahiaCndReader.tokenEquals(token, Lexer.CHOICELIST)) {
            return 14;
        }
        if (JahiaCndReader.tokenEquals(token, Lexer.CRON)) {
            return 15;
        }
        if (JahiaCndReader.tokenEquals(token, Lexer.DATEPICKER)) {
            return 4;
        }
        if (JahiaCndReader.tokenEquals(token, Lexer.DATETIMEPICKER)) {
            return 3;
        }
        if (JahiaCndReader.tokenEquals(token, Lexer.CATEGORY)) {
            return 13;
        }
        if (JahiaCndReader.tokenEquals(token, Lexer.CONTENTPICKER)) {
            return 9;
        }
        if (JahiaCndReader.tokenEquals(token, Lexer.FILEUPLOAD)) {
            return 10;
        }
        if (JahiaCndReader.tokenEquals(token, Lexer.COLOR)) {
            return 12;
        }
        if (JahiaCndReader.tokenEquals(token, Lexer.CHECKBOX)) {
            return 11;
        }
        return -1;
    }

    public JahiaCndReader(Reader reader, String filename, String systemId, NodeTypeRegistry registry) {
        this.systemId = systemId;
        this.registry = registry;
        this.filename = filename;
        this.lexer = new Lexer(reader, filename);
    }

    public void setDoRegister(boolean doRegister) {
        this.doRegister = doRegister;
    }

    public List<ExtendedNodeType> getNodeTypesList() {
        return this.nodeTypesList;
    }

    public void parse() throws ParseException {
        this.nextToken();
        while (!this.currentTokenEquals("eof")) {
            try {
                if (this.doNameSpace()) continue;
                break;
            }
            catch (ParseException e) {
                this.hasEncounteredIssuesWithDefinitions = true;
                this.parsingErrors.add(e.getMessage());
                logger.error(e.getMessage(), (Throwable)e);
                this.doRegister = false;
                this.nextToken();
                while (!(this.currentTokenEquals('[') || this.currentTokenEquals("<") || this.currentTokenEquals("eof"))) {
                    this.nextToken();
                }
            }
        }
        while (!this.currentTokenEquals("eof")) {
            ExtendedNodeType ntd = new ExtendedNodeType(this.registry, this.systemId);
            try {
                this.doNodeTypeName(ntd);
                this.doSuperTypes(ntd);
                this.doOptions(ntd);
                this.doItemDefs(ntd);
                this.nodeTypesList.add(ntd);
            }
            catch (Exception e) {
                this.hasEncounteredIssuesWithDefinitions = true;
                this.parsingErrors.add(e.getMessage());
                logger.error(e.getMessage(), (Throwable)e);
                this.doRegister = false;
                this.nextToken();
                while (!this.currentTokenEquals('[') && !this.currentTokenEquals("eof")) {
                    this.nextToken();
                }
            }
        }
        if (this.doRegister) {
            for (ExtendedNodeType nodeType : this.nodeTypesList) {
                try {
                    this.registry.addNodeType(nodeType.getNameObject(), nodeType);
                }
                catch (NodeTypeExistsException e) {
                    this.hasEncounteredIssuesWithDefinitions = true;
                    this.parsingErrors.add(e.getMessage());
                }
            }
            for (ExtendedNodeType type : this.nodeTypesList) {
                try {
                    type.validate();
                    if (type.getPrefix().equals("nt") || type.isMixin() || type.isNodeType("mix:referenceable")) continue;
                    int length = type.getDeclaredSupertypeNames().length;
                    String[] newTypes = new String[length + 1];
                    System.arraycopy(type.getDeclaredSupertypeNames(), 0, newTypes, 0, length);
                    newTypes[length] = "mix:referenceable";
                    type.setDeclaredSupertypes(newTypes);
                    type.validate();
                }
                catch (NoSuchNodeTypeException e) {
                    this.hasEncounteredIssuesWithDefinitions = true;
                    this.parsingErrors.add(e.getMessage());
                }
            }
        }
    }

    private boolean doNameSpace() throws ParseException {
        if (!this.currentTokenEquals('<')) {
            return false;
        }
        this.nextToken();
        String prefix = this.currentToken;
        this.nextToken();
        if (!this.currentTokenEquals('=')) {
            this.lexer.fail("Missing = in namespace decl.");
        }
        this.nextToken();
        String uri = this.currentToken;
        this.nextToken();
        if (!this.currentTokenEquals('>')) {
            this.lexer.fail("Missing > in namespace decl.");
        }
        if (this.registry.getNamespaces().containsKey(prefix) && !StringUtils.equals((String)this.registry.getNamespaces().get(prefix), (String)uri)) {
            this.lexer.fail("Invalid namespace declaration : prefix already declared");
        }
        if (!this.registry.getNamespaces().containsKey(prefix) && this.registry.getNamespaces().containsValue(uri)) {
            this.lexer.fail("Invalid namespace declaration : uri already declared");
        }
        this.registry.getNamespaces().put(prefix, uri);
        this.nextToken();
        return true;
    }

    private void doNodeTypeName(ExtendedNodeType ntd) throws ParseException {
        if (!this.currentTokenEquals('[')) {
            this.lexer.fail("Unexpected token '" + this.currentToken + "'");
        }
        this.nextToken();
        Name name = this.parseName(this.currentToken);
        ntd.setName(name);
        this.nextToken();
        if (!this.currentTokenEquals(']')) {
            this.lexer.fail("Missing ']' delimiter for end of node type name, found " + this.currentToken);
        }
        this.nextToken();
    }

    private void doSuperTypes(ExtendedNodeType ntd) throws ParseException {
        ArrayList<String> supertypes = new ArrayList<String>();
        if (!this.currentTokenEquals('>')) {
            return;
        }
        do {
            this.nextToken();
            this.parseName(this.currentToken);
            supertypes.add(this.currentToken);
            this.nextToken();
        } while (this.currentTokenEquals(','));
        ntd.setDeclaredSupertypes(supertypes.toArray(new String[supertypes.size()]));
    }

    private void doOptions(ExtendedNodeType ntd) throws ParseException {
        boolean hasOption = true;
        while (hasOption) {
            if (this.currentTokenEquals(Lexer.ORDERABLE)) {
                this.nextToken();
                ntd.setHasOrderableChildNodes(true);
                continue;
            }
            if (this.currentTokenEquals(Lexer.MIXIN)) {
                this.nextToken();
                ntd.setMixin(true);
                continue;
            }
            if (this.currentTokenEquals(Lexer.ABSTRACT)) {
                this.nextToken();
                ntd.setAbstract(true);
                continue;
            }
            if (this.currentTokenEquals(Lexer.NOQUERY)) {
                this.nextToken();
                ntd.setQueryable(false);
                continue;
            }
            if (this.currentTokenEquals(Lexer.QUERY)) {
                this.nextToken();
                ntd.setQueryable(true);
                continue;
            }
            if (this.currentTokenEquals(Lexer.PRIMARYITEM)) {
                this.nextToken();
                ntd.setPrimaryItemName(this.currentToken);
                this.nextToken();
                continue;
            }
            if (this.currentTokenEquals(Lexer.VALIDATOR)) {
                this.nextToken();
                if (this.currentTokenEquals('=')) {
                    this.nextToken();
                    logger.warn("Warning : validator is not supported anymore");
                    this.nextToken();
                    continue;
                }
                this.lexer.fail("Invalid validator");
                continue;
            }
            if (this.currentTokenEquals(Lexer.ITEMTYPE)) {
                this.nextToken();
                if (this.currentTokenEquals('=')) {
                    this.nextToken();
                    ntd.setItemsType(this.currentToken);
                    this.nextToken();
                    continue;
                }
                this.lexer.fail("Invalid validator");
                continue;
            }
            if (this.currentTokenEquals(Lexer.MIXIN_EXTENDS)) {
                this.nextToken();
                if (this.currentTokenEquals('=')) {
                    do {
                        this.nextToken();
                        ntd.addMixinExtend(this.currentToken);
                        this.nextToken();
                    } while (this.currentTokenEquals(','));
                    continue;
                }
                this.lexer.fail("Invalid validator");
                continue;
            }
            hasOption = false;
        }
    }

    private void doItemDefs(ExtendedNodeType ntd) throws ParseException {
        while (true) {
            if (this.currentTokenEquals('-')) {
                ExtendedPropertyDefinition pdi = new ExtendedPropertyDefinition(this.registry);
                this.nextToken();
                this.doPropertyDefinition(pdi, ntd);
                pdi.setDeclaringNodeType(ntd);
                continue;
            }
            if (!this.currentTokenEquals('+')) break;
            ExtendedNodeDefinition ndi = new ExtendedNodeDefinition(this.registry);
            this.nextToken();
            this.doChildNodeDefinition(ndi, ntd);
            ndi.setDeclaringNodeType(ntd);
        }
    }

    private void doPropertyDefinition(ExtendedPropertyDefinition pdi, ExtendedNodeType ntd) throws ParseException {
        Name name = this.parseName(this.currentToken);
        pdi.setName(name);
        this.nextToken();
        this.doPropertyType(pdi);
        this.doPropertyDefaultValue(pdi);
        this.doPropertyAttributes(pdi, ntd);
        this.doPropertyValueConstraints(pdi);
    }

    private void doPropertyType(ExtendedPropertyDefinition pdi) throws ParseException {
        if (!this.currentTokenEquals('(')) {
            return;
        }
        this.nextToken();
        if (pdi.getRequiredType() == 0) {
            int propType = JahiaCndReader.getPropertyType(this.currentToken);
            if (propType >= 0) {
                pdi.setRequiredType(propType);
            } else {
                this.lexer.fail("Unknown type '" + this.currentToken + "' specified");
            }
            this.nextToken();
            if (this.currentTokenEquals(')')) {
                this.nextToken();
            } else if (this.currentTokenEquals(',')) {
                this.nextToken();
                this.doPropertySelector(pdi);
            } else {
                this.lexer.fail("Missing ')' delimiter for end of property type");
            }
        } else {
            this.doPropertySelector(pdi);
        }
    }

    private void doPropertySelector(ExtendedPropertyDefinition pdi) throws ParseException {
        int selector = JahiaCndReader.getSelectorType(this.currentToken);
        if (selector >= 0) {
            pdi.setSelector(selector);
        } else {
            this.lexer.fail("Unknown type '" + this.currentToken + "' specified");
        }
        this.nextToken();
        if (this.currentTokenEquals('[')) {
            this.doSelectorOptions(pdi);
        }
        if (this.currentTokenEquals(')')) {
            this.nextToken();
        } else {
            this.lexer.fail("Missing ')' delimiter for end of property type");
        }
    }

    private void doPropertyAttributes(ExtendedPropertyDefinition pdi, ExtendedNodeType ntd) throws ParseException {
        while (this.currentTokenEquals(Lexer.PROP_ATTRIBUTE)) {
            if (this.currentTokenEquals(Lexer.PRIMARY)) {
                ntd.setPrimaryItemName(pdi.getName());
            } else if (this.currentTokenEquals(Lexer.AUTOCREATED)) {
                pdi.setAutoCreated(true);
            } else if (this.currentTokenEquals(Lexer.MANDATORY)) {
                pdi.setMandatory(true);
            } else if (this.currentTokenEquals(Lexer.PROTECTED)) {
                pdi.setProtected(true);
            } else if (this.currentTokenEquals(Lexer.MULTIPLE)) {
                pdi.setMultiple(true);
            } else if (this.currentTokenEquals(Lexer.HIDDEN)) {
                pdi.setHidden(true);
            } else if (this.currentTokenEquals(Lexer.INTERNATIONALIZED)) {
                pdi.setInternationalized(true);
            } else if (this.currentTokenEquals(Lexer.ITEMTYPE)) {
                this.nextToken();
                if (this.currentTokenEquals('=')) {
                    this.nextToken();
                    pdi.setItemType(this.currentToken);
                } else {
                    this.lexer.fail("Invalid value for indexed " + this.currentToken);
                }
            } else if (this.currentTokenEquals(Lexer.INDEXED)) {
                this.nextToken();
                if (this.currentTokenEquals('=')) {
                    this.nextToken();
                    if (this.currentTokenEquals(Lexer.NO)) {
                        pdi.setIndex(0);
                    } else if (this.currentTokenEquals(Lexer.TOKENIZED)) {
                        pdi.setIndex(1);
                    } else if (this.currentTokenEquals(Lexer.UNTOKENIZED)) {
                        pdi.setIndex(2);
                    } else {
                        this.lexer.fail("Invalid value for indexed [ no | tokenized | untokenized ] " + this.currentToken);
                    }
                } else {
                    this.lexer.fail("Invalid value for indexed " + this.currentToken);
                }
            } else if (this.currentTokenEquals(Lexer.SCOREBOOST)) {
                this.nextToken();
                if (this.currentTokenEquals('=')) {
                    this.nextToken();
                    try {
                        pdi.setScoreboost(Double.parseDouble(this.currentToken));
                    }
                    catch (NumberFormatException e) {
                        this.lexer.fail("Invalid value for score boost " + this.currentToken);
                    }
                } else {
                    this.lexer.fail("Invalid value for score boost " + this.currentToken);
                }
            } else if (this.currentTokenEquals(Lexer.ANALYZER)) {
                this.nextToken();
                if (this.currentTokenEquals('=')) {
                    this.nextToken();
                    pdi.setAnalyzer(this.currentToken);
                } else {
                    this.lexer.fail("Invalid value for tokenizer " + this.currentToken);
                }
            } else if (this.currentTokenEquals(Lexer.SORTABLE)) {
                pdi.setQueryOrderable(true);
            } else if (this.currentTokenEquals(Lexer.FACETABLE)) {
                pdi.setFacetable(true);
            } else if (this.currentTokenEquals(Lexer.HIERARCHICAL)) {
                pdi.setHierarchical(true);
            } else if (this.currentTokenEquals(Lexer.FULLTEXTSEARCHABLE)) {
                this.nextToken();
                if (this.currentTokenEquals('=')) {
                    this.nextToken();
                    if (this.currentTokenEquals(Lexer.NO)) {
                        pdi.setFullTextSearchable(Boolean.FALSE);
                    } else if (this.currentTokenEquals(Lexer.YES)) {
                        pdi.setFullTextSearchable(Boolean.TRUE);
                    }
                }
            } else if (this.currentTokenEquals(Lexer.ONCONFLICT)) {
                this.nextToken();
                if (this.currentTokenEquals('=')) {
                    this.nextToken();
                    if (this.currentTokenEquals(Lexer.USE_LATEST)) {
                        pdi.setOnConflict(5);
                    } else if (this.currentTokenEquals(Lexer.USE_OLDEST)) {
                        pdi.setOnConflict(4);
                    } else if (this.currentTokenEquals(Lexer.NUMERIC_USE_MIN)) {
                        pdi.setOnConflict(6);
                    } else if (this.currentTokenEquals(Lexer.NUMERIC_USE_MAX)) {
                        pdi.setOnConflict(7);
                    } else if (this.currentTokenEquals(Lexer.NUMERIC_SUM)) {
                        pdi.setOnConflict(8);
                    }
                }
            } else if (this.currentTokenEquals(Lexer.COPY)) {
                pdi.setOnParentVersion(1);
            } else if (this.currentTokenEquals(Lexer.VERSION)) {
                pdi.setOnParentVersion(2);
            } else if (this.currentTokenEquals(Lexer.INITIALIZE)) {
                pdi.setOnParentVersion(3);
            } else if (this.currentTokenEquals(Lexer.COMPUTE)) {
                pdi.setOnParentVersion(4);
            } else if (this.currentTokenEquals(Lexer.IGNORE)) {
                pdi.setOnParentVersion(5);
            } else if (this.currentTokenEquals(Lexer.ABORT)) {
                pdi.setOnParentVersion(6);
            } else if (this.currentTokenEquals(Lexer.NOFULLTEXT)) {
                pdi.setFullTextSearchable(false);
            } else if (this.currentTokenEquals(Lexer.NOQUERYORDER)) {
                pdi.setQueryOrderable(false);
            } else if (this.currentTokenEquals(Lexer.QUERYOPS)) {
                this.doPropertyQueryOperators(pdi);
            }
            this.nextToken();
        }
    }

    private void doPropertyQueryOperators(ExtendedPropertyDefinition pd) throws ParseException {
        if (!this.currentTokenEquals(Lexer.QUERYOPS)) {
            return;
        }
        this.nextToken();
        String[] ops = Patterns.COMMA.split(this.currentToken);
        LinkedList<String> queryOps = new LinkedList<String>();
        for (String op : ops) {
            String s = op.trim();
            if (s.equals("=")) {
                queryOps.add("jcr.operator.equal.to");
                continue;
            }
            if (s.equals("<>")) {
                queryOps.add("jcr.operator.not.equal.to");
                continue;
            }
            if (s.equals("<")) {
                queryOps.add("jcr.operator.less.than");
                continue;
            }
            if (s.equals("<=")) {
                queryOps.add("jcr.operator.less.than.or.equal.to");
                continue;
            }
            if (s.equals(">")) {
                queryOps.add("jcr.operator.greater.than");
                continue;
            }
            if (s.equals(">=")) {
                queryOps.add("jcr.operator.greater.than.or.equal.to");
                continue;
            }
            if (s.equals("LIKE")) {
                queryOps.add("jcr.operator.like");
                continue;
            }
            this.lexer.fail("'" + s + "' is not a valid query operator");
        }
        pd.setAvailableQueryOperators(queryOps.toArray(new String[queryOps.size()]));
    }

    private void doPropertyDefaultValue(ExtendedPropertyDefinition pdi) throws ParseException {
        if (!this.currentTokenEquals('=')) {
            return;
        }
        List<Value> defaultValues = this.doValuesList(pdi, false);
        pdi.setDefaultValues(defaultValues.toArray(new Value[defaultValues.size()]));
    }

    private void doPropertyValueConstraints(ExtendedPropertyDefinition pdi) throws ParseException {
        if (!this.currentTokenEquals('<')) {
            return;
        }
        List<Value> constraints = this.doValuesList(pdi, true);
        pdi.setValueConstraints(constraints.toArray(new Value[constraints.size()]));
    }

    private List<Value> doValuesList(ExtendedPropertyDefinition pdi, boolean isConstraint) throws ParseException {
        ArrayList<Value> values = new ArrayList<Value>();
        do {
            this.nextToken();
            String v = this.currentToken;
            this.nextToken();
            if (this.currentTokenEquals('(')) {
                this.nextToken();
                ArrayList<String> params = new ArrayList<String>();
                while (!this.currentTokenEquals(')')) {
                    params.add(this.currentToken);
                    this.nextToken();
                }
                this.nextToken();
                values.add(new DynamicValueImpl(v, params, pdi.getRequiredType(), isConstraint, pdi));
                continue;
            }
            values.add(new ValueImpl(v, pdi.getRequiredType(), isConstraint));
        } while (this.currentTokenEquals(','));
        return values;
    }

    private void doChildNodeDefinition(ExtendedNodeDefinition ndi, ExtendedNodeType ntd) throws ParseException {
        Name name = this.parseName(this.currentToken);
        ndi.setName(name);
        this.nextToken();
        this.doChildNodeRequiredTypes(ndi);
        this.doChildNodeDefaultType(ndi);
        this.doChildNodeAttributes(ndi, ntd);
    }

    private void doChildNodeRequiredTypes(ExtendedNodeDefinition ndi) throws ParseException {
        if (!this.currentTokenEquals('(')) {
            return;
        }
        if (ndi.getRequiredPrimaryTypeNames() == null) {
            ArrayList<String> types = new ArrayList<String>();
            do {
                this.nextToken();
                types.add(this.currentToken);
                this.nextToken();
            } while (this.currentTokenEquals(','));
            if (this.currentTokenEquals('[')) {
                this.doSelectorOptions(ndi);
            }
            if (this.currentTokenEquals(')')) {
                this.nextToken();
            } else {
                this.lexer.fail("Missing ')' delimiter for end of child node type");
            }
            ndi.setRequiredPrimaryTypes(types.toArray(new String[types.size()]));
        } else {
            this.nextToken();
            this.doChildNodeSelector(ndi);
        }
    }

    private void doChildNodeSelector(ExtendedNodeDefinition ndi) throws ParseException {
        if (this.currentTokenEquals(Lexer.PAGE)) {
            ndi.setSelector(21);
        } else {
            this.lexer.fail("Unknown type '" + this.currentToken + "' specified");
        }
        this.nextToken();
        if (this.currentTokenEquals('[')) {
            this.doSelectorOptions(ndi);
        }
        if (this.currentTokenEquals(')')) {
            this.nextToken();
        } else {
            this.lexer.fail("Missing ')' delimiter for end of property type");
        }
    }

    private void doChildNodeDefaultType(ExtendedNodeDefinition ndi) throws ParseException {
        if (!this.currentTokenEquals('=')) {
            return;
        }
        this.nextToken();
        ndi.setDefaultPrimaryType(this.currentToken);
        this.nextToken();
    }

    private void doChildNodeAttributes(ExtendedNodeDefinition ndi, ExtendedNodeType ntd) throws ParseException {
        while (this.currentTokenEquals(Lexer.NODE_ATTRIBUTE)) {
            if (this.currentTokenEquals(Lexer.PRIMARY)) {
                ntd.setPrimaryItemName(ndi.getName());
            } else if (this.currentTokenEquals(Lexer.AUTOCREATED)) {
                ndi.setAutoCreated(true);
            } else if (this.currentTokenEquals(Lexer.MANDATORY)) {
                ndi.setMandatory(true);
            } else if (this.currentTokenEquals(Lexer.HIDDEN)) {
                ndi.setHidden(true);
            } else if (this.currentTokenEquals(Lexer.PROTECTED)) {
                ndi.setProtected(true);
            } else if (this.currentTokenEquals(Lexer.MULTIPLE)) {
                ndi.setAllowsSameNameSiblings(true);
            } else if (this.currentTokenEquals(Lexer.COPY)) {
                ndi.setOnParentVersion(1);
            } else if (this.currentTokenEquals(Lexer.VERSION)) {
                ndi.setOnParentVersion(2);
            } else if (this.currentTokenEquals(Lexer.INITIALIZE)) {
                ndi.setOnParentVersion(3);
            } else if (this.currentTokenEquals(Lexer.COMPUTE)) {
                ndi.setOnParentVersion(4);
            } else if (this.currentTokenEquals(Lexer.IGNORE)) {
                ndi.setOnParentVersion(5);
            } else if (this.currentTokenEquals(Lexer.ABORT)) {
                ndi.setOnParentVersion(6);
            } else if (this.currentTokenEquals(Lexer.ITEMTYPE)) {
                this.nextToken();
                if (this.currentTokenEquals('=')) {
                    this.nextToken();
                    ndi.setItemType(this.currentToken);
                } else {
                    this.lexer.fail("Invalid value for indexed " + this.currentToken);
                }
            } else if (this.currentTokenEquals(Lexer.WORKFLOW)) {
                this.nextToken();
                if (this.currentTokenEquals('=')) {
                    this.nextToken();
                    ndi.setWorkflow(this.currentToken);
                } else {
                    this.lexer.fail("Invalid value for workflow " + this.currentToken);
                }
            }
            this.nextToken();
        }
    }

    private void doSelectorOptions(ExtendedItemDefinition pdi) throws ParseException {
        this.nextToken();
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        while (true) {
            String key = this.currentToken;
            String value = "";
            this.nextToken();
            if (this.currentTokenEquals('=')) {
                this.nextToken();
                value = this.currentToken;
                this.nextToken();
            }
            if (key.equals("addListMixin") || key.equals("addMixin") || key.equals("availableTypes")) {
                for (String s : Patterns.COMMA.split(value)) {
                    try {
                        this.registry.getNodeType(s);
                    }
                    catch (NoSuchNodeTypeException e) {
                        this.lexer.fail("Cannot find type : " + s);
                    }
                }
            }
            options.put(key, value);
            if (this.currentTokenEquals(']')) break;
            if (!this.currentTokenEquals(',')) {
                this.lexer.fail("Missing ']' delimiter");
            }
            this.nextToken();
        }
        this.nextToken();
        pdi.setSelectorOptions(options);
    }

    protected void nextToken() throws ParseException {
        this.currentToken = this.lexer.getNextToken();
    }

    protected boolean currentTokenEquals(String[] s) {
        return JahiaCndReader.tokenEquals(this.currentToken, s);
    }

    protected boolean currentTokenEquals(char c) {
        return this.currentToken.length() == 1 && this.currentToken.charAt(0) == c;
    }

    protected boolean currentTokenEquals(String s) {
        return this.currentToken.equals(s);
    }

    protected Name parseName(String name) throws ParseException {
        Name res = new Name(name, this.registry.getNamespaces());
        if (!StringUtils.isEmpty((String)res.getPrefix()) && res.getUri() == null) {
            this.lexer.fail("Cannot parse name: " + name);
        }
        return res;
    }

    public final boolean hasEncounteredIssuesWithDefinitions() {
        return this.hasEncounteredIssuesWithDefinitions;
    }

    public List<String> getParsingErrors() {
        return this.parsingErrors;
    }
}

