/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.InvalidNodeTypeDefinitionException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeExistsException;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.nodetypes.ExtendedItemDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.JahiaCndReader;
import org.jahia.services.content.nodetypes.JahiaGroupingFileReader;
import org.jahia.services.content.nodetypes.Name;
import org.jahia.services.content.nodetypes.NodeTypesDBServiceImpl;
import org.jahia.services.content.nodetypes.ParseException;
import org.jahia.services.templates.ModuleVersion;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class NodeTypeRegistry
implements NodeTypeManager,
InitializingBean {
    public static final String SYSTEM = "system";
    private static Logger logger = LoggerFactory.getLogger(NodeTypeRegistry.class);
    private List<ExtendedNodeType> nodeTypesList = new ArrayList<ExtendedNodeType>();
    private Map<Name, ExtendedNodeType> nodetypes = new HashMap<Name, ExtendedNodeType>();
    private BidiMap namespaces = new DualHashBidiMap();
    private Map<String, List<Resource>> files = new ListOrderedMap();
    private Map<ExtendedNodeType, Set<ExtendedNodeType>> mixinExtensions = new HashMap<ExtendedNodeType, Set<ExtendedNodeType>>();
    private Map<String, Set<ExtendedItemDefinition>> typedItems = new HashMap<String, Set<ExtendedItemDefinition>>();
    private boolean propertiesLoaded = false;
    private final Properties deploymentProperties = new Properties();
    private static boolean hasEncounteredIssuesWithDefinitions = false;
    private NodeTypesDBServiceImpl nodeTypesDBService;

    public static NodeTypeRegistry getInstance() {
        return Holder.INSTANCE;
    }

    public static NodeTypeRegistry getProviderNodeTypeRegistry() {
        return ProviderNodeTypeRegistryHolder.PROVIDER_NODE_TYPE_INSTANCE;
    }

    public static void deployDefinitionsFileToProviderNodeTypeRegistry(Reader reader, String definitionName) throws ParseException, IOException {
        ProviderNodeTypeRegistryHolder.deployDefinitionsFileToProviderNodeTypeRegistry(reader, definitionName);
    }

    public void flushLabels() {
        for (ExtendedNodeType extendedNodeType : this.nodetypes.values()) {
            extendedNodeType.clearLabels();
        }
        for (Set set : this.typedItems.values()) {
            for (ExtendedItemDefinition item : set) {
                item.clearLabels();
                item.getDeclaringNodeType().clearLabels();
            }
        }
    }

    public void initSystemDefinitions() throws IOException {
        String cnddir = SettingsBean.getInstance().getJahiaEtcDiskPath() + "/repository/nodetypes";
        try {
            File f = new File(cnddir);
            TreeSet<File> cndfiles = new TreeSet<File>(Arrays.asList(f.listFiles()));
            for (File file : cndfiles) {
                this.addDefinitionsFile(file, "system-" + Patterns.DASH.split(file.getName())[1], null);
            }
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void initPropertiesFile() throws IOException {
        try {
            String propertyFile = this.nodeTypesDBService.readDefinitionPropertyFile();
            if (propertyFile != null) {
                this.deploymentProperties.load(new StringReader(propertyFile));
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.propertiesLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProperties() throws IOException {
        if (this.propertiesLoaded) {
            Properties properties = this.deploymentProperties;
            synchronized (properties) {
                StringWriter writer = new StringWriter();
                this.deploymentProperties.store(writer, "");
                try {
                    this.nodeTypesDBService.saveDefinitionPropertyFile(writer.toString());
                }
                catch (RepositoryException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public Properties getDeploymentProperties() {
        return this.deploymentProperties;
    }

    public boolean isLatestDefinitions(String systemId, ModuleVersion version) {
        ModuleVersion lastDeployed;
        String key;
        return version == null || !this.deploymentProperties.containsKey(key = systemId + ".version") || (lastDeployed = new ModuleVersion(this.deploymentProperties.getProperty(key))).compareTo(version) <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDefinitionsFile(Resource resource, String systemId, ModuleVersion version) throws IOException, ParseException {
        block11: {
            String ext;
            block12: {
                InputStreamReader resourceReader;
                block10: {
                    if (version != null) {
                        if (this.isLatestDefinitions(systemId, version)) {
                            this.deploymentProperties.put(systemId + ".version", version.toString());
                            this.saveProperties();
                        } else {
                            return;
                        }
                    }
                    if (!(ext = resource.getURL().getPath().substring(resource.getURL().getPath().lastIndexOf(46))).equalsIgnoreCase(".cnd")) break block12;
                    resourceReader = null;
                    try {
                        resourceReader = new InputStreamReader(resource.getInputStream(), Charsets.UTF_8);
                        JahiaCndReader r = new JahiaCndReader(resourceReader, resource.toString(), systemId, this);
                        r.parse();
                        if (!r.hasEncounteredIssuesWithDefinitions()) break block10;
                        hasEncounteredIssuesWithDefinitions = true;
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(resourceReader);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Reader)resourceReader);
                break block11;
            }
            if (ext.equalsIgnoreCase(".grp")) {
                InputStreamReader resourceReader = null;
                try {
                    resourceReader = new InputStreamReader(resource.getInputStream(), Charsets.UTF_8);
                    JahiaGroupingFileReader r = new JahiaGroupingFileReader(resourceReader, resource.toString(), systemId, this);
                    r.parse();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(resourceReader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)resourceReader);
            }
        }
        if (!this.files.containsKey(systemId)) {
            this.files.put(systemId, new ArrayList());
        }
        if (!this.files.get(systemId).contains(resource)) {
            this.files.get(systemId).add(resource);
        }
    }

    public void addDefinitionsFile(File file, String systemId, ModuleVersion version) throws ParseException, IOException {
        this.addDefinitionsFile((Resource)(file == null ? null : new FileSystemResource(file)), systemId, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExtendedNodeType> getDefinitionsFromFile(Resource resource, String systemId) throws ParseException, IOException {
        String ext = resource.getURL().getPath().substring(resource.getURL().getPath().lastIndexOf(46));
        if (ext.equalsIgnoreCase(".cnd")) {
            List<ExtendedNodeType> list;
            InputStreamReader resourceReader = null;
            try {
                resourceReader = new InputStreamReader(resource.getInputStream(), Charsets.UTF_8);
                JahiaCndReader r = new JahiaCndReader(resourceReader, resource.getURL().getPath(), systemId, this);
                r.setDoRegister(false);
                r.parse();
                list = r.getNodeTypesList();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(resourceReader);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)resourceReader);
            return list;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateDefinitionsFile(InputStream inputStream, String filename, String systemId) throws ParseException, IOException, RepositoryException {
        if (filename.toLowerCase().endsWith(".cnd")) {
            InputStreamReader resourceReader = null;
            try {
                resourceReader = new InputStreamReader(inputStream, Charsets.UTF_8);
                JahiaCndReader r = new JahiaCndReader(resourceReader, filename, systemId, this);
                r.parse();
                if (r.hasEncounteredIssuesWithDefinitions()) {
                    throw new RepositoryException(StringUtils.join(r.getParsingErrors(), (String)"\n"));
                }
                for (ExtendedNodeType nodeType : r.getNodeTypesList()) {
                    ExtendedNodeType existingNodeType;
                    if (!NodeTypeRegistry.getInstance().hasNodeType(nodeType.getName()) || (existingNodeType = NodeTypeRegistry.getInstance().getNodeType(nodeType.getName())).getSystemId().equals(nodeType.getSystemId())) continue;
                    throw new NodeTypeExistsException("Node type already defined : " + nodeType.getName());
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(resourceReader);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)resourceReader);
        }
    }

    public List<String> getSystemIds() {
        return new ArrayList<String>(this.files.keySet());
    }

    public List<Resource> getFiles(String systemId) {
        return this.files.get(systemId);
    }

    public ExtendedNodeType getNodeType(String name) throws NoSuchNodeTypeException {
        ExtendedNodeType res;
        ExtendedNodeType extendedNodeType = res = StringUtils.isNotEmpty((String)name) ? this.nodetypes.get(new Name(name, (Map<String, String>)this.namespaces)) : null;
        if (res == null) {
            throw new NoSuchNodeTypeException("Unknown type : " + name);
        }
        return res;
    }

    public JahiaNodeTypeIterator getAllNodeTypes() {
        return new JahiaNodeTypeIterator(this.nodeTypesList.iterator(), this.nodeTypesList.size());
    }

    public JahiaNodeTypeIterator getAllNodeTypes(List<String> systemIds) {
        ArrayList<ExtendedNodeType> res = new ArrayList<ExtendedNodeType>();
        for (ExtendedNodeType nt : this.nodetypes.values()) {
            if (systemIds != null && !systemIds.contains(nt.getSystemId())) continue;
            res.add(nt);
        }
        return new JahiaNodeTypeIterator(res.iterator(), res.size());
    }

    public JahiaNodeTypeIterator getNodeTypes(String systemId) {
        ArrayList<ExtendedNodeType> l = new ArrayList<ExtendedNodeType>();
        for (ExtendedNodeType nt : this.nodeTypesList) {
            if (!nt.getSystemId().equals(systemId)) continue;
            l.add(nt);
        }
        return new JahiaNodeTypeIterator(l.iterator(), l.size());
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public NodeTypeIterator getPrimaryNodeTypes() throws RepositoryException {
        return this.getPrimaryNodeTypes(null);
    }

    public NodeTypeIterator getPrimaryNodeTypes(List<String> systemIds) throws RepositoryException {
        ArrayList<ExtendedNodeType> res = new ArrayList<ExtendedNodeType>();
        for (ExtendedNodeType nt : this.nodetypes.values()) {
            if (nt.isMixin() || systemIds != null && !systemIds.contains(nt.getSystemId())) continue;
            res.add(nt);
        }
        return new JahiaNodeTypeIterator(res.iterator(), res.size());
    }

    public NodeTypeIterator getMixinNodeTypes() throws RepositoryException {
        return this.getMixinNodeTypes(null);
    }

    public NodeTypeIterator getMixinNodeTypes(List<String> systemIds) throws RepositoryException {
        ArrayList<ExtendedNodeType> res = new ArrayList<ExtendedNodeType>();
        for (ExtendedNodeType nt : this.nodetypes.values()) {
            if (!nt.isMixin() || systemIds != null && !systemIds.contains(nt.getSystemId())) continue;
            res.add(nt);
        }
        return new JahiaNodeTypeIterator(res.iterator(), res.size());
    }

    public void addNodeType(Name name, ExtendedNodeType nodeType) throws NodeTypeExistsException {
        if (this.nodetypes.containsKey(name)) {
            if (!this.nodetypes.get(name).getSystemId().equals(nodeType.getSystemId())) {
                throw new NodeTypeExistsException("Node type already defined : " + nodeType.getName());
            }
            this.nodeTypesList.remove(this.nodetypes.get(name));
        }
        this.nodeTypesList.add(nodeType);
        this.nodetypes.put(name, nodeType);
    }

    public void addMixinExtension(ExtendedNodeType mixin, ExtendedNodeType baseType) {
        if (!this.mixinExtensions.containsKey(baseType)) {
            this.mixinExtensions.put(baseType, new HashSet());
        }
        this.mixinExtensions.get(baseType).remove(mixin);
        this.mixinExtensions.get(baseType).add(mixin);
    }

    public Map<ExtendedNodeType, Set<ExtendedNodeType>> getMixinExtensions() {
        return this.mixinExtensions;
    }

    public void addTypedItem(ExtendedItemDefinition itemDef) {
        String type = itemDef.getItemType();
        if (!this.typedItems.containsKey(type)) {
            this.typedItems.put(type, new HashSet());
        }
        this.typedItems.get(type).add(itemDef);
    }

    public Map<String, Set<ExtendedItemDefinition>> getTypedItems() {
        return this.typedItems;
    }

    public void unregisterNodeType(Name name) {
        ExtendedNodeType nt = this.nodetypes.remove(name);
        this.nodeTypesList.remove(nt);
    }

    public void unregisterNodeTypes(String systemId) {
        for (Name n : new HashSet<Name>(this.nodetypes.keySet())) {
            ExtendedNodeType nt = this.nodetypes.get(n);
            if (!systemId.equals(nt.getSystemId())) continue;
            this.unregisterNodeType(n);
        }
        this.deploymentProperties.remove(systemId + ".version");
        try {
            this.saveProperties();
        }
        catch (IOException e) {
            logger.error("Cannot save definitions properties", (Throwable)e);
        }
    }

    public void setNodeTypesDBService(NodeTypesDBServiceImpl nodeTypesDBService) {
        this.nodeTypesDBService = nodeTypesDBService;
    }

    public NodeTypesDBServiceImpl getNodeTypesDBService() {
        return this.nodeTypesDBService;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            this.initPropertiesFile();
            this.initSystemDefinitions();
        }
        catch (IOException e) {
            logger.error("Cannot load definition deployment properties");
        }
    }

    public boolean hasNodeType(String name) {
        return this.nodetypes.get(new Name(name, (Map<String, String>)this.namespaces)) != null;
    }

    public NodeTypeTemplate createNodeTypeTemplate() throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public NodeTypeTemplate createNodeTypeTemplate(NodeTypeDefinition ntd) throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public NodeDefinitionTemplate createNodeDefinitionTemplate() throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public PropertyDefinitionTemplate createPropertyDefinitionTemplate() throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public NodeType registerNodeType(NodeTypeDefinition ntd, boolean allowUpdate) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public NodeTypeIterator registerNodeTypes(NodeTypeDefinition[] ntds, boolean allowUpdate) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void unregisterNodeType(String name) throws ConstraintViolationException {
        Name n = new Name(name, (Map<String, String>)this.namespaces);
        if (this.nodetypes.containsKey(n)) {
            for (ExtendedNodeType type : this.nodeTypesList) {
                if (type.getName().equals(name)) continue;
                for (ExtendedNodeType nt : type.getSupertypes()) {
                    if (!nt.getName().equals(name)) continue;
                    throw new ConstraintViolationException("Cannot unregister node type " + name + " because " + type.getName() + " extends it.");
                }
                for (ExtendedNodeDefinition ntd : type.getChildNodeDefinitions()) {
                    if (!Sets.newHashSet((Object[])ntd.getRequiredPrimaryTypeNames()).contains(name)) continue;
                    throw new ConstraintViolationException("Cannot unregister node type " + name + " because a child node definition of " + type.getName() + " requires it.");
                }
                for (ExtendedNodeDefinition ntd : type.getUnstructuredChildNodeDefinitions().values()) {
                    if (!Sets.newHashSet((Object[])ntd.getRequiredPrimaryTypeNames()).contains(name)) continue;
                    throw new ConstraintViolationException("Cannot unregister node type " + name + " because a child node definition of " + type.getName() + " requires it.");
                }
            }
            this.nodeTypesList.remove(this.nodetypes.remove(n));
        }
    }

    public void unregisterNodeTypes(String[] names) throws ConstraintViolationException {
        for (String name : names) {
            this.unregisterNodeType(name);
        }
    }

    public final boolean hasEncounteredIssuesWithDefinitions() {
        return hasEncounteredIssuesWithDefinitions;
    }

    public class JahiaNodeTypeIterator
    implements NodeTypeIterator,
    Iterable<ExtendedNodeType> {
        private long size;
        private long pos = 0L;
        private Iterator<ExtendedNodeType> iterator;

        JahiaNodeTypeIterator(Iterator<ExtendedNodeType> it, long size) {
            this.iterator = it;
            this.size = size;
        }

        public NodeType nextNodeType() {
            ++this.pos;
            return this.iterator.next();
        }

        public void skip(long l) {
            if (this.pos + l + 1L > this.size) {
                throw new NoSuchElementException("Tried to skip past " + l + " elements, which with current pos (" + this.pos + ") brings us past total size=" + this.size);
            }
            int i = 0;
            while ((long)i < l) {
                this.next();
                ++i;
            }
        }

        public long getSize() {
            return this.size;
        }

        public long getPosition() {
            return this.pos;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            ++this.pos;
            return this.iterator.next();
        }

        public void remove() {
            this.iterator.remove();
            --this.size;
        }

        @Override
        public Iterator<ExtendedNodeType> iterator() {
            return this;
        }
    }

    private static class ProviderNodeTypeRegistryHolder {
        static final NodeTypeRegistry PROVIDER_NODE_TYPE_INSTANCE = new NodeTypeRegistry();

        private ProviderNodeTypeRegistryHolder() {
        }

        public static void deployDefinitionsFileToProviderNodeTypeRegistry(Reader reader, String definitionName) throws ParseException, IOException {
            String systemId = StringUtils.substringBefore((String)definitionName, (String)".cnd");
            JahiaCndReader r = new JahiaCndReader(reader, definitionName, systemId, PROVIDER_NODE_TYPE_INSTANCE);
            r.parse();
        }

        static {
            NodeTypeRegistry instance = NodeTypeRegistry.getInstance();
            try {
                PROVIDER_NODE_TYPE_INSTANCE.initSystemDefinitions();
                ArrayList<Object> files = new ArrayList();
                ArrayList<String> remfiles = null;
                try {
                    remfiles = new ArrayList<String>(instance.getNodeTypesDBService().getFilesList());
                    while (!remfiles.isEmpty() && !remfiles.equals(files)) {
                        files = new ArrayList<String>(remfiles);
                        remfiles.clear();
                        for (String string : files) {
                            try {
                                if (!string.endsWith(".cnd")) continue;
                                String cndFile = instance.getNodeTypesDBService().readCndFile(string);
                                ProviderNodeTypeRegistryHolder.deployDefinitionsFileToProviderNodeTypeRegistry(new StringReader(cndFile), string);
                            }
                            catch (ParseException e) {
                                remfiles.add(string);
                            }
                        }
                    }
                }
                catch (RepositoryException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static class Holder {
        static final NodeTypeRegistry INSTANCE = new NodeTypeRegistry();

        private Holder() {
        }
    }
}

