/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes;

import java.util.List;
import javax.jcr.RepositoryException;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.jahia.services.content.nodetypes.NodeTypesDBProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTypesDBServiceImpl {
    private static Logger logger = LoggerFactory.getLogger(NodeTypesDBServiceImpl.class);
    private SessionFactory hibernateSessionFactory;
    public static final String DEFINITIONS_PROPERTIES = "definitions.properties";

    public void setHibernateSessionFactory(SessionFactory hibernateSessionFactory) {
        this.hibernateSessionFactory = hibernateSessionFactory;
    }

    public SessionFactory getHibernateSessionFactory() {
        return this.hibernateSessionFactory;
    }

    public String readDefinitionPropertyFile() throws RepositoryException {
        StatelessSession session = null;
        try {
            session = this.getHibernateSessionFactory().openStatelessSession();
            session.beginTransaction();
            NodeTypesDBProvider nodeTypesDBProvider = (NodeTypesDBProvider)session.createQuery("from NodeTypesDBProvider where filename=:filename").setString("filename", DEFINITIONS_PROPERTIES).setReadOnly(true).uniqueResult();
            if (nodeTypesDBProvider != null) {
                String string = nodeTypesDBProvider.getCndFile();
                return string;
            }
            session.getTransaction().commit();
        }
        catch (Exception e) {
            if (session != null) {
                session.getTransaction().rollback();
            }
            throw new RepositoryException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return null;
    }

    public void saveDefinitionPropertyFile(String content) throws RepositoryException {
        StatelessSession session = null;
        try {
            session = this.getHibernateSessionFactory().openStatelessSession();
            session.beginTransaction();
            NodeTypesDBProvider nodeTypesDBProvider = (NodeTypesDBProvider)session.createQuery("from NodeTypesDBProvider where filename=:filename").setString("filename", DEFINITIONS_PROPERTIES).setReadOnly(false).uniqueResult();
            if (nodeTypesDBProvider != null) {
                nodeTypesDBProvider.setCndFile(content);
                session.update((Object)nodeTypesDBProvider);
            } else {
                nodeTypesDBProvider = new NodeTypesDBProvider();
                nodeTypesDBProvider.setFilename(DEFINITIONS_PROPERTIES);
                nodeTypesDBProvider.setCndFile(content);
                session.insert((Object)nodeTypesDBProvider);
            }
            session.getTransaction().commit();
        }
        catch (Exception e) {
            if (session != null) {
                session.getTransaction().rollback();
            }
            throw new RepositoryException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public String readCndFile(String filename) throws RepositoryException {
        StatelessSession session = null;
        try {
            session = this.getHibernateSessionFactory().openStatelessSession();
            session.beginTransaction();
            NodeTypesDBProvider nodeTypesDBProvider = (NodeTypesDBProvider)session.createQuery("from NodeTypesDBProvider where filename=:filename").setString("filename", filename).setReadOnly(true).uniqueResult();
            if (nodeTypesDBProvider != null) {
                String string = nodeTypesDBProvider.getCndFile();
                return string;
            }
            session.getTransaction().commit();
        }
        catch (Exception e) {
            if (session != null) {
                session.getTransaction().rollback();
            }
            throw new RepositoryException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return null;
    }

    public List<String> getFilesList() throws RepositoryException {
        StatelessSession session = null;
        try {
            session = this.getHibernateSessionFactory().openStatelessSession();
            session.beginTransaction();
            List nodeTypesDBProviderList = session.createQuery("select filename from NodeTypesDBProvider").setReadOnly(true).list();
            if (nodeTypesDBProviderList != null) {
                List list = nodeTypesDBProviderList;
                return list;
            }
            session.getTransaction().commit();
        }
        catch (Exception e) {
            if (session != null) {
                session.getTransaction().rollback();
            }
            throw new RepositoryException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return null;
    }

    public void saveCndFile(String filename, String content) throws RepositoryException {
        StatelessSession session = null;
        try {
            session = this.getHibernateSessionFactory().openStatelessSession();
            session.beginTransaction();
            NodeTypesDBProvider nodeTypesDBProvider = (NodeTypesDBProvider)session.createQuery("from NodeTypesDBProvider where filename=:filename").setString("filename", filename).setReadOnly(false).uniqueResult();
            if (nodeTypesDBProvider != null && content != null) {
                nodeTypesDBProvider.setCndFile(content);
                session.update((Object)nodeTypesDBProvider);
            } else if (nodeTypesDBProvider != null) {
                session.delete((Object)nodeTypesDBProvider);
            } else if (content != null) {
                nodeTypesDBProvider = new NodeTypesDBProvider();
                nodeTypesDBProvider.setFilename(filename);
                nodeTypesDBProvider.setCndFile(content);
                session.insert((Object)nodeTypesDBProvider);
            }
            session.getTransaction().commit();
        }
        catch (Exception e) {
            if (session != null) {
                session.getTransaction().rollback();
            }
            throw new RepositoryException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }
}

