/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes.initializers;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.jahia.services.content.nodetypes.ValueImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChoiceListValue
implements Comparable<ChoiceListValue> {
    private static final Logger logger = LoggerFactory.getLogger(ChoiceListValue.class);
    private String displayName;
    private Value value;
    private Map<String, Object> properties;

    public ChoiceListValue(String displayName, Map<String, Object> properties, Value value) {
        this.displayName = displayName;
        this.properties = properties;
        this.value = value;
    }

    public ChoiceListValue(String displayName, String stringValue) {
        this(displayName, null, new ValueImpl(stringValue));
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Value getValue() {
        return this.value;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public void addProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Object>();
        }
        this.properties.put(key, value);
    }

    @Override
    public int compareTo(ChoiceListValue o) {
        return this.getDisplayName().compareToIgnoreCase(o.getDisplayName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChoiceListValue that = (ChoiceListValue)o;
        if (!this.displayName.equals(that.displayName)) {
            return false;
        }
        if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) {
            return false;
        }
        try {
            if (!this.value.getString().equals(that.value.getString())) {
                return false;
            }
            if (this.value.getType() != that.value.getType()) {
                return false;
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public int hashCode() {
        int result = this.displayName.hashCode();
        try {
            result = 31 * result + this.value.getString().hashCode();
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        result = 31 * result + this.value.getType();
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }
}

