/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes.initializers;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import javax.jcr.NodeIterator;
import javax.jcr.query.QueryResult;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRNodeWrapperImpl;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.initializers.ChoiceListInitializer;
import org.jahia.services.content.nodetypes.initializers.ChoiceListValue;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenusChoiceListInitializerImpl
implements ChoiceListInitializer {
    private static transient Logger logger = LoggerFactory.getLogger(MenusChoiceListInitializerImpl.class);

    @Override
    public List<ChoiceListValue> getChoiceListValues(ExtendedPropertyDefinition epd, String param, List<ChoiceListValue> values, Locale locale, Map<String, Object> context) {
        ArrayList<ChoiceListValue> listValues = new ArrayList<ChoiceListValue>();
        TreeSet<ChoiceListValue> set = new TreeSet<ChoiceListValue>();
        String nodetype = "jmix:navMenuComponent";
        try {
            QueryManagerWrapper qm = JCRSessionFactory.getInstance().getCurrentUserSession().getWorkspace().getQueryManager();
            JCRNodeWrapper node = (JCRNodeWrapper)context.get("contextNode");
            if (node == null) {
                node = (JCRNodeWrapper)context.get("contextParent");
            }
            JCRSiteNode site = node.getResolveSite();
            JahiaTemplateManagerService service = ServicesRegistry.getInstance().getJahiaTemplateManagerService();
            for (String s : site.getAllInstalledModules()) {
                JahiaTemplatesPackage module = service.getTemplatePackageById(s);
                if (module == null) continue;
                QueryResult result = qm.createQuery("select * from [" + nodetype + "] as n where isdescendantnode(n,['/modules/" + module.getIdWithVersion() + "'])", "JCR-SQL2").execute();
                NodeIterator ni = result.getNodes();
                while (ni.hasNext()) {
                    JCRNodeWrapperImpl nodeWrapper = (JCRNodeWrapperImpl)ni.nextNode();
                    String displayName = nodeWrapper.getDisplayableName();
                    set.add(new ChoiceListValue(displayName, nodeWrapper.getName()));
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        listValues.addAll(set);
        return listValues;
    }
}

