/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes.initializers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.security.Privilege;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.security.JahiaPrivilegeRegistry;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.initializers.ChoiceListInitializer;
import org.jahia.services.content.nodetypes.initializers.ChoiceListValue;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionsChoiceListInitializer
implements ChoiceListInitializer {
    private static transient Logger logger = LoggerFactory.getLogger(PermissionsChoiceListInitializer.class);

    @Override
    public List<ChoiceListValue> getChoiceListValues(ExtendedPropertyDefinition epd, String param, List<ChoiceListValue> values, Locale locale, Map<String, Object> context) {
        ArrayList<ChoiceListValue> result = new ArrayList<ChoiceListValue>();
        Privilege[] p = JahiaPrivilegeRegistry.getRegisteredPrivileges();
        try {
            for (Privilege privilege : p) {
                String jcrName = JCRContentUtils.getJCRName(privilege.getName(), JCRSessionFactory.getInstance().getNamespaceRegistry());
                String localName = jcrName;
                if (localName.contains(":")) {
                    localName = StringUtils.substringAfter((String)localName, (String)":");
                }
                String title = StringUtils.capitalize((String)localName.replaceAll("([A-Z])", " $0").replaceAll("[_-]", " ").toLowerCase());
                String rbName = localName.replaceAll("-", "_");
                result.add(new ChoiceListValue(Messages.getInternal("label.permission." + rbName, locale, title), jcrName));
            }
        }
        catch (RepositoryException e) {
            logger.error("Repository exception", (Throwable)e);
        }
        Collections.sort(result);
        return result;
    }
}

