/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.rules;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.rules.AddedNodeFact;
import org.jahia.services.content.rules.ChangedPropertyFact;
import org.jahia.services.content.rules.NodeFact;

public abstract class AbstractNodeFact
implements NodeFact {
    protected JCRNodeWrapper node;
    protected String workspace;
    protected String operationType;
    protected List<String> installedModules;

    public AbstractNodeFact(JCRNodeWrapper node) throws RepositoryException {
        this.node = node;
        if (node != null) {
            this.workspace = node.getSession().getWorkspace().getName();
        }
    }

    @Override
    public String getIdentifier() throws RepositoryException {
        return this.node.getIdentifier();
    }

    @Override
    public AddedNodeFact getParent() throws RepositoryException {
        return new AddedNodeFact(this.node.getParent());
    }

    @Override
    public String getPath() throws RepositoryException {
        return this.node.getPath();
    }

    public String getName() throws RepositoryException {
        return this.node.getName();
    }

    @Override
    public String getWorkspace() throws RepositoryException {
        return this.workspace;
    }

    @Override
    public String getLanguage() throws RepositoryException {
        return this.node.getLanguage();
    }

    @Override
    public String getOperationType() {
        return this.operationType;
    }

    @Override
    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public List<String> getInstalledModules() {
        return this.installedModules;
    }

    public void setInstalledModules(List<String> installedModules) {
        this.installedModules = installedModules;
    }

    public AddedNodeFact getContent() throws RepositoryException {
        if (this.node.hasNode("jcr:content")) {
            AddedNodeFact nodeFact = new AddedNodeFact(this.node.getNode("jcr:content"));
            nodeFact.setOperationType(this.getOperationType());
            return nodeFact;
        }
        return null;
    }

    public String getMimeType() throws RepositoryException {
        if (this.node.hasNode("jcr:content")) {
            return this.node.getNode("jcr:content").getProperty("jcr:mimeType").getString();
        }
        return null;
    }

    public List<AddedNodeFact> getChildNodes() throws RepositoryException {
        ArrayList<AddedNodeFact> results = new ArrayList<AddedNodeFact>();
        JCRNodeIteratorWrapper it = this.node.getNodes();
        while (it.hasNext()) {
            JCRNodeWrapper n = (JCRNodeWrapper)it.nextNode();
            AddedNodeFact nodeFact = new AddedNodeFact(n);
            nodeFact.setOperationType(this.getOperationType());
            results.add(nodeFact);
        }
        return results;
    }

    public List<ChangedPropertyFact> getProperties() throws RepositoryException {
        ArrayList<ChangedPropertyFact> results = new ArrayList<ChangedPropertyFact>();
        PropertyIterator it = this.node.getProperties();
        while (it.hasNext()) {
            JCRPropertyWrapper p = (JCRPropertyWrapper)it.nextProperty();
            results.add(new ChangedPropertyFact(new AddedNodeFact(this.node), p));
        }
        return results;
    }

    public ChangedPropertyFact getProperty(String propertyName) throws RepositoryException {
        return new ChangedPropertyFact(new AddedNodeFact(this.node), this.node.getProperty(propertyName));
    }

    public List<String> getTypes() throws RepositoryException {
        ArrayList<String> r = new ArrayList<String>();
        this.recurseOnTypes(r, this.node.getPrimaryNodeType());
        this.recurseOnTypes(r, this.node.getMixinNodeTypes());
        return r;
    }

    private void recurseOnTypes(List<String> res, NodeType ... nt) {
        for (NodeType nodeType : nt) {
            if (!res.contains(nodeType.getName())) {
                res.add(nodeType.getName());
            }
            this.recurseOnTypes(res, nodeType.getSupertypes());
        }
    }

    public AddedNodeFact getAncestor(String type) throws RepositoryException {
        AddedNodeFact ancestor = new AddedNodeFact(this.node);
        try {
            while ((ancestor = ancestor.getParent()) != null) {
                if (!ancestor.getNode().isNodeType(type)) continue;
                return ancestor;
            }
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public JCRNodeWrapper getNode() {
        return this.node;
    }

    public AddedNodeFact getNode(String relPath) throws RepositoryException {
        AddedNodeFact nodeFact = new AddedNodeFact(this.node.getNode(relPath));
        nodeFact.setOperationType(this.getOperationType());
        return nodeFact;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractNodeFact that = (AbstractNodeFact)o;
        if (this.node != null ? !this.node.equals(that.node) : that.node != null) {
            return false;
        }
        if (this.operationType != null ? !this.operationType.equals(that.operationType) : that.operationType != null) {
            return false;
        }
        return !(this.workspace != null ? !this.workspace.equals(that.workspace) : that.workspace != null);
    }

    public int hashCode() {
        int result = this.node != null ? this.node.hashCode() : 0;
        result = 31 * result + (this.workspace != null ? this.workspace.hashCode() : 0);
        result = 31 * result + (this.operationType != null ? this.operationType.hashCode() : 0);
        return result;
    }
}

