/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.rules;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.commons.codec.Charsets;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.value.BinaryImpl;
import org.apache.tika.io.IOUtils;
import org.apache.tika.metadata.Metadata;
import org.drools.core.WorkingMemory;
import org.drools.core.spi.KnowledgeHelper;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRFileContent;
import org.jahia.services.content.rules.AddedNodeFact;
import org.jahia.services.content.rules.ExtractedVariable;
import org.jahia.services.textextraction.TextExtractionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractionService {
    private static ExtractionService instance;
    private static Logger logger;
    private JCRTemplate jcrTemplate;
    private TextExtractionService textExtractionService;
    private Map<String, String[]> mapping = new HashMap<String, String[]>();

    public static ExtractionService getInstance() {
        if (instance == null) {
            instance = new ExtractionService();
        }
        return instance;
    }

    public boolean canHandle(JCRNodeWrapper node) throws IOException {
        if (!this.textExtractionService.isEnabled()) {
            return false;
        }
        String mimeType = null;
        try {
            mimeType = node.getProperty("jcr:mimeType").getString();
        }
        catch (PathNotFoundException e) {
        }
        catch (RepositoryException e) {
            logger.warn("Unable to get mime type for the node " + node.getPath() + ". Cause: " + e.getMessage(), (Throwable)e);
        }
        if (mimeType == null) {
            return false;
        }
        Metadata metadata = new Metadata();
        metadata.set("Content-Type", mimeType);
        return this.textExtractionService.canHandle(null, metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractProperties(AddedNodeFact node, KnowledgeHelper drools) throws Exception {
        if (!this.textExtractionService.isEnabled()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Text extraction service is disabled. Skip extracting properties for node " + node.getPath());
            }
            return;
        }
        AddedNodeFact contentNode = node.getContent();
        if (contentNode == null) {
            return;
        }
        String mimeType = null;
        try {
            mimeType = contentNode.getNode().getProperty("jcr:mimeType").getString();
        }
        catch (Exception e) {
            logger.warn("Unable to detect mime type for node " + node.getPath(), (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Extracting properties for document " + node.getPath() + " with mime type '" + mimeType + "'");
        }
        Metadata metadata = new Metadata();
        if (mimeType != null) {
            metadata.set("Content-Type", mimeType);
        }
        InputStream stream = null;
        try {
            stream = contentNode.getNode().getProperty("jcr:data").getBinary().getStream();
            this.textExtractionService.extractMetadata(stream, metadata);
        }
        catch (Exception e) {
            block17: {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.warn("Error extracting metadata for node " + node.getPath(), (Throwable)e);
                        break block17;
                    }
                    logger.warn("Error extracting metadata for node " + node.getPath() + ". Cause: " + e.getMessage() + (e.getCause() != null ? " Original cause: " + e.getCause().getMessage() : ""));
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(stream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)stream);
        }
        IOUtils.closeQuietly((InputStream)stream);
        if (metadata.size() > 0) {
            try {
                WorkingMemory memory = drools.getWorkingMemory();
                for (String key : metadata.names()) {
                    if ("Content-Type".equals(key)) continue;
                    String value = metadata.get(key);
                    if (StringUtils.isNotBlank((String)value)) {
                        String[] mappedTo = this.mapping.get(key);
                        memory.insert((Object)new ExtractedVariable(node.getPath(), key, value, mappedTo != null ? mappedTo[0] : null, mappedTo != null ? mappedTo[1] : null));
                        continue;
                    }
                    logger.debug("Ignoring blank value for metadata " + key);
                }
            }
            catch (Exception e) {
                logger.warn("Error extracting metadata for node " + node.getPath(), (Throwable)e);
            }
        }
    }

    public void extractText(JCRStoreProvider provider, final String sourcePath, final String extractionNodePath) throws IOException {
        if (!this.textExtractionService.isEnabled()) {
            return;
        }
        try {
            this.jcrTemplate.doExecuteWithSystemSession(new JCRCallback<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    JCRNodeWrapper file = session.getNode(sourcePath);
                    JCRFileContent fileContent = file.getFileContent();
                    Node n = file.getRealNode().getNode("jcr:content");
                    String type = fileContent.getContentType();
                    String encoding = fileContent.getEncoding();
                    InputStream stream = fileContent.downloadFile();
                    try {
                        Metadata metadata = new Metadata();
                        metadata.set("Content-Type", type);
                        if (encoding != null) {
                            metadata.set("Content-Encoding", encoding);
                        }
                        String content = ExtractionService.this.textExtractionService.parse(stream, metadata);
                        if (extractionNodePath != null && extractionNodePath.length() > 0) {
                            n = session.getNode(extractionNodePath);
                            session.checkout(n);
                            try {
                                n.setProperty("j:originalUuid", file.getIdentifier());
                            }
                            catch (UnsupportedRepositoryOperationException e) {}
                        } else {
                            session.checkout(n);
                        }
                        BinaryImpl contentValue = new BinaryImpl(content.getBytes(Charsets.UTF_8));
                        try {
                            n.setProperty("j:extractedText", (Binary)contentValue);
                            n.setProperty("j:lastExtractionDate", (Calendar)new GregorianCalendar());
                            session.save();
                        }
                        catch (ConstraintViolationException cve) {
                            logger.error("Extracted text property is not of the right type for node " + sourcePath + " please run patch associated for this conversion.", (Throwable)cve);
                        }
                        finally {
                            contentValue.dispose();
                        }
                    }
                    catch (Exception e) {
                        if (logger.isDebugEnabled()) {
                            logger.warn("Cannot extract content for node " + sourcePath, (Throwable)e);
                        } else {
                            logger.warn("Cannot extract content for node " + sourcePath + ". Cause: " + e.getMessage() + (e.getCause() != null ? " Original cause: " + e.getCause().getMessage() : ""));
                        }
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)stream);
                    }
                    return null;
                }
            });
        }
        catch (RepositoryException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cannot extract content: " + e.getMessage(), (Throwable)e);
            }
            logger.warn("Cannot extract content: " + e.getMessage());
        }
    }

    public boolean isEnabled() {
        return this.textExtractionService.isEnabled();
    }

    public void setJcrTemplate(JCRTemplate jcrTemplate) {
        this.jcrTemplate = jcrTemplate;
    }

    public void setTextExtractionService(TextExtractionService textExtractionService) {
        this.textExtractionService = textExtractionService;
    }

    public void setMapping(Map<String, String> mapping) {
        this.mapping = new HashMap<String, String[]>(mapping.size());
        for (Map.Entry<String, String> entry : mapping.entrySet()) {
            this.mapping.put(entry.getKey(), StringUtils.split((String)entry.getValue(), (char)'.'));
        }
    }

    static {
        logger = LoggerFactory.getLogger(ExtractionService.class);
    }
}

