/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.rules;

import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.files.FileCacheManager;
import org.jahia.services.content.rules.BaseBackgroundAction;
import org.jahia.services.render.filter.cache.ModuleCacheProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlushCacheOnNodeBackgroundAction
extends BaseBackgroundAction {
    private static Logger logger = LoggerFactory.getLogger(FlushCacheOnNodeBackgroundAction.class);
    private FileCacheManager fileCacheManager = FileCacheManager.getInstance();
    private ModuleCacheProvider cacheProvider;
    private int startLevel;
    private int levelsUp;

    public void setCacheProvider(ModuleCacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    @Override
    public void executeBackgroundAction(JCRNodeWrapper node) {
        String workspace = "live";
        try {
            JCRNodeWrapper currentNode = node;
            workspace = node.getSession().getWorkspace().getName();
            for (int level = 0; level <= this.startLevel + this.levelsUp; ++level) {
                if (level >= this.startLevel) {
                    this.cacheProvider.invalidate(currentNode.getPath());
                    if (currentNode.isFile()) {
                        this.fileCacheManager.invalidate(workspace, currentNode.getPath());
                    }
                }
                currentNode = currentNode.getParent();
            }
        }
        catch (RepositoryException e) {
            String currentNode = node.getPath();
            for (int level = 0; level <= this.startLevel + this.levelsUp; ++level) {
                if (level >= this.startLevel) {
                    this.cacheProvider.invalidate(currentNode);
                    this.fileCacheManager.invalidate(workspace, currentNode);
                }
                currentNode = StringUtils.substringBeforeLast((String)currentNode, (String)"/");
            }
        }
    }

    public void setStartLevel(int startLevel) {
        this.startLevel = startLevel;
    }

    public void setLevelsUp(int endLevel) {
        this.levelsUp = endLevel;
    }
}

