/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.rules;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.RepositoryException;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.drools.core.spi.KnowledgeHelper;
import org.jahia.bin.Jahia;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.rules.AbstractNodeFact;
import org.jahia.services.content.rules.AddedNodeFact;
import org.jahia.services.content.rules.ChangedPropertyFact;
import org.jahia.services.content.rules.User;
import org.jahia.services.mail.MailService;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.LanguageCodeConverters;
import org.jahia.utils.Patterns;
import org.jahia.utils.ScriptEngineUtils;
import org.jahia.utils.i18n.ResourceBundles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesNotificationService {
    private static Logger logger = LoggerFactory.getLogger(RulesNotificationService.class);
    private ScriptEngineUtils scriptEngineUtils;
    private MailService notificationService;

    public void setScriptEngineUtils(ScriptEngineUtils scriptEngineUtils) {
        this.scriptEngineUtils = scriptEngineUtils;
    }

    public static RulesNotificationService getInstance() {
        return Holder.INSTANCE;
    }

    private RulesNotificationService() {
    }

    public void setNotificationService(MailService notificationService) {
        this.notificationService = notificationService;
    }

    public void notifyNewUser(AddedNodeFact node, String template, KnowledgeHelper drools) throws RepositoryException, ScriptException, IOException {
        if (!this.notificationService.isEnabled()) {
            return;
        }
        JCRNodeWrapper userNode = node.getNode();
        if (userNode.hasProperty("j:email") && !userNode.getProperty("j:external").getBoolean()) {
            Locale locale;
            String toMail = userNode.getProperty("j:email").getString();
            String ccList = null;
            String bcclist = null;
            try {
                locale = LanguageCodeConverters.languageCodeToLocale(userNode.getProperty("preferredLanguage").getString());
            }
            catch (RepositoryException e) {
                locale = SettingsBean.getInstance().getDefaultLocale();
            }
            this.sendMail(template, userNode, toMail, null, ccList, bcclist, locale, drools);
        }
    }

    public void notifyCurrentUser(User user, String template, String fromMail, String ccList, String bccList, KnowledgeHelper drools) throws RepositoryException, ScriptException, IOException {
        if (!this.notificationService.isEnabled()) {
            return;
        }
        JahiaUser userNode = user.getJahiaUser();
        if (userNode.getProperty("j:email") != null) {
            String toMail = userNode.getProperty("j:email");
            Locale locale = this.getLocale(userNode);
            this.sendMail(template, userNode, toMail, fromMail, ccList, bccList, locale, drools);
        }
    }

    public void notifyCurrentUser(User user, String template, String fromMail, KnowledgeHelper drools) throws RepositoryException, ScriptException, IOException {
        if (!this.notificationService.isEnabled()) {
            return;
        }
        JahiaUser userNode = user.getJahiaUser();
        if (userNode.getProperty("j:email") != null) {
            String toMail = userNode.getProperty("j:email");
            Locale locale = this.getLocale(userNode);
            this.sendMail(template, userNode, toMail, fromMail, null, null, locale, drools);
        }
    }

    private Locale getLocale(JahiaUser userNode) {
        String property = userNode.getProperty("preferredLanguage");
        Locale locale = property != null ? LanguageCodeConverters.languageCodeToLocale(property) : SettingsBean.getInstance().getDefaultLocale();
        return locale;
    }

    public void notifyUser(String user, String template, String fromMail, KnowledgeHelper drools) throws RepositoryException, ScriptException, IOException {
        if (!this.notificationService.isEnabled()) {
            return;
        }
        JahiaUser userNode = ServicesRegistry.getInstance().getJahiaUserManagerService().lookupUser(user);
        if (userNode != null && userNode.getProperty("j:email") != null) {
            String toMail = userNode.getProperty("j:email");
            this.sendMail(template, userNode, toMail, fromMail, null, null, this.getLocale(userNode), drools);
        }
    }

    public void notifyUser(String user, String template, ChangedPropertyFact fromMail, KnowledgeHelper drools) throws RepositoryException, ScriptException, IOException {
        if (!this.notificationService.isEnabled()) {
            return;
        }
        JahiaUser userNode = ServicesRegistry.getInstance().getJahiaUserManagerService().lookupUser(user);
        if (userNode != null && userNode.getProperty("j:email") != null) {
            String toMail = userNode.getProperty("j:email");
            this.sendMail(template, userNode, toMail, fromMail.getStringValue(), null, null, this.getLocale(userNode), drools);
        }
    }

    public void notifyUser(String user, String template, String fromMail, String ccList, String bccList, KnowledgeHelper drools) throws RepositoryException, ScriptException, IOException {
        if (!this.notificationService.isEnabled()) {
            return;
        }
        JahiaUser userNode = ServicesRegistry.getInstance().getJahiaUserManagerService().lookupUser(user);
        if (userNode.getProperty("j:email") != null) {
            String toMail = userNode.getProperty("j:email");
            this.sendMail(template, userNode, toMail, fromMail, ccList, bccList, this.getLocale(userNode), drools);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMail(String template, Object user, String toMail, String fromMail, String ccList, String bcclist, Locale locale, KnowledgeHelper drools) throws RepositoryException, ScriptException {
        InputStream scriptInputStream;
        if (!this.notificationService.isEnabled()) {
            return;
        }
        if (StringUtils.isEmpty((String)toMail)) {
            logger.warn("A mail couldn't be sent because to: has no recipient");
            return;
        }
        String extension = StringUtils.substringAfterLast((String)template, (String)".");
        ScriptEngine scriptEngine = this.scriptEngineUtils.scriptEngine(extension);
        SimpleScriptContext scriptContext = new SimpleScriptContext();
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("currentUser", user);
        bindings.put("contextPath", (Object)Jahia.getContextPath());
        Object object = drools.getMatch().getTuple().getHandle().getObject();
        JCRNodeWrapper node = null;
        if (object instanceof AbstractNodeFact) {
            node = ((AbstractNodeFact)object).getNode();
            bindings.put("currentNode", (Object)node);
            int siteURLPortOverride = SettingsBean.getInstance().getSiteURLPortOverride();
            bindings.put("servername", (Object)("http" + (siteURLPortOverride == 443 ? "s" : "") + "://" + node.getResolveSite().getServerName() + (siteURLPortOverride != 0 && siteURLPortOverride != 80 && siteURLPortOverride != 443 ? ":" + siteURLPortOverride : "")));
        }
        if ((scriptInputStream = JahiaContextLoaderListener.getServletContext().getResourceAsStream(template)) != null) {
            String subject;
            block13: {
                String resourceBundleName = StringUtils.substringBeforeLast((String)Patterns.SLASH.matcher(StringUtils.substringAfter((String)Patterns.WEB_INF.matcher(template).replaceAll(""), (String)"/")).replaceAll("."), (String)".");
                subject = "";
                try {
                    ResourceBundle resourceBundle = ResourceBundles.get(resourceBundleName, locale);
                    bindings.put("bundle", (Object)resourceBundle);
                    subject = resourceBundle.getString("subject");
                }
                catch (MissingResourceException e) {
                    JCRValueWrapper[] values;
                    if (node == null) break block13;
                    for (JCRValueWrapper value : values = node.getResolveSite().getProperty("j:installedModules").getValues()) {
                        try {
                            ResourceBundle resourceBundle = ResourceBundles.get(ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(value.getString()).getName(), locale);
                            subject = resourceBundle.getString(drools.getRule().getName().toLowerCase().replaceAll(" ", ".") + ".subject");
                            bindings.put("bundle", (Object)resourceBundle);
                        }
                        catch (MissingResourceException ee) {
                            // empty catch block
                        }
                    }
                }
            }
            InputStreamReader scriptContent = null;
            try {
                scriptContent = new InputStreamReader(scriptInputStream);
                scriptContext.setWriter(new StringWriter());
                bindings.put("out", (Object)new PrintWriter(scriptContext.getWriter()));
                scriptContext.setBindings(bindings, 100);
                scriptContext.setBindings(scriptEngine.getContext().getBindings(200), 200);
                scriptEngine.eval((Reader)scriptContent, (ScriptContext)scriptContext);
                StringWriter writer = (StringWriter)scriptContext.getWriter();
                String body = writer.toString();
                this.notificationService.sendMessage(fromMail, toMail, ccList, bcclist, subject, null, body);
            }
            finally {
                if (scriptContent != null) {
                    IOUtils.closeQuietly((Reader)scriptContent);
                }
            }
        }
    }

    private static class Holder {
        static final RulesNotificationService INSTANCE = new RulesNotificationService();

        private Holder() {
        }
    }
}

