/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.rules.Group;
import org.jahia.services.content.rules.UserProperty;
import org.jahia.services.usermanager.JahiaGroup;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUser;

public class User {
    private String username;
    private JahiaUser user;

    public User(JahiaUser user) {
        this.user = user;
    }

    public User(String username) {
        this.username = username;
    }

    public String getName() {
        if (this.username != null) {
            return this.username;
        }
        if (this.user != null) {
            return this.user.getUsername();
        }
        return null;
    }

    public List<UserProperty> getProperties() {
        ArrayList<UserProperty> r = new ArrayList<UserProperty>();
        JahiaUser jahiaUser = this.getJahiaUser();
        if (jahiaUser != null) {
            Properties p = jahiaUser.getProperties();
            for (String string : p.keySet()) {
                String v = p.getProperty(string);
                r.add(new UserProperty(this, string, v));
            }
        }
        return r;
    }

    public List<Group> getGroups() {
        ArrayList<Group> r = new ArrayList<Group>();
        JahiaGroupManagerService grpManager = ServicesRegistry.getInstance().getJahiaGroupManagerService();
        JahiaUser jahiaUser = this.getJahiaUser();
        if (jahiaUser != null) {
            List<String> groups = grpManager.getUserMembership(jahiaUser);
            for (String groupname : groups) {
                JahiaGroup group = grpManager.lookupGroup(groupname);
                r.add(new Group(group));
            }
        }
        return r;
    }

    public JahiaUser getJahiaUser() {
        if (this.user == null && this.username != null && !this.username.equals(" system ") && !this.username.equals(" guest ")) {
            this.user = ServicesRegistry.getInstance().getJahiaUserManagerService().lookupUser(this.username);
        }
        return this.user;
    }
}

