/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.textextraction;

import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.rules.ExtractionService;
import org.jahia.services.scheduler.BackgroundJob;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextExtractorJob
extends BackgroundJob {
    public static final String JOB_PATH = "path";
    public static final String JOB_PROVIDER = "provider";
    public static final String JOB_EXTRACTNODE_PATH = "extractnode-path";
    private static Logger logger = LoggerFactory.getLogger(TextExtractorJob.class);

    @Override
    public void executeJahiaJob(JobExecutionContext jobExecutionContext) throws Exception {
        JobDataMap data = jobExecutionContext.getJobDetail().getJobDataMap();
        String path = (String)data.get((Object)JOB_PATH);
        String providerPath = (String)data.get((Object)JOB_PROVIDER);
        String extractNodePath = (String)data.get((Object)JOB_EXTRACTNODE_PATH);
        JCRStoreProvider provider = JCRSessionFactory.getInstance().getProvider(providerPath);
        if (logger.isDebugEnabled()) {
            logger.debug("Start text extraction job for provider '" + provider.getKey() + "' path " + path + " and extractNodePath " + extractNodePath);
        } else {
            logger.info("Start text extraction job for node " + path);
        }
        ExtractionService.getInstance().extractText(provider, path, extractNodePath);
        logger.info("... finished text extraction job for node " + path);
    }
}

