/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.deamons.filewatcher;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jahia.services.deamons.filewatcher.FileListener;
import org.jahia.services.deamons.filewatcher.FileMonitorCallback;
import org.jahia.services.deamons.filewatcher.FileMonitorResult;

public class FileMonitor
implements Serializable {
    private static final long DEFAULT_DELAY = 1000L;
    private static final int DEFAULT_MAX_FILES = 1000;
    private static final long serialVersionUID = -7377571336405032918L;
    private final Stack<File> addStack = new Stack();
    private final FileMonitorCallback callback;
    private int checksPerRun = 1000;
    private long delay = 1000L;
    private final Stack<File> deleteStack = new Stack();
    private Set<String> filesToIgnore;
    private final Map<File, FileMonitorAgent> monitorMap = new HashMap<File, FileMonitorAgent>();
    private boolean onlyFiles;
    private boolean recursive;

    public FileMonitor() {
        this(null);
    }

    public FileMonitor(FileMonitorCallback callback) {
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(File file) {
        Map<File, FileMonitorAgent> map = this.monitorMap;
        synchronized (map) {
            if (this.monitorMap.get(file) == null && !this.isIgnored(file)) {
                this.monitorMap.put(file, new FileMonitorAgent(this, file));
                if (this.recursive && file.isDirectory()) {
                    File[] children = file.listFiles();
                    for (int i = 0; i < children.length; ++i) {
                        this.addFile(children[i]);
                    }
                }
            }
        }
    }

    public int getChecksPerRun() {
        return this.checksPerRun;
    }

    public long getDelay() {
        return this.delay;
    }

    public Set<String> getFilesToIgnore() {
        return this.filesToIgnore;
    }

    protected boolean isIgnored(File file) {
        return this.filesToIgnore != null && this.filesToIgnore.contains(file.getName());
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    protected void queueAddFile(File file) {
        this.addStack.push(file);
    }

    protected void queueRemoveFile(File file) {
        this.deleteStack.push(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFile(File file) {
        Map<File, FileMonitorAgent> map = this.monitorMap;
        synchronized (map) {
            if (this.monitorMap.get(file) != null) {
                FileMonitorAgent parentAgent;
                File parent = file.getParentFile();
                this.monitorMap.remove(file);
                if (parent != null && (parentAgent = this.monitorMap.get(parent)) != null) {
                    parentAgent.resetChildrenList();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object[] fileNames;
        FileMonitorResult result = new FileMonitorResult();
        while (!this.deleteStack.empty()) {
            this.removeFile(this.deleteStack.pop());
        }
        Map<File, FileMonitorAgent> map = this.monitorMap;
        synchronized (map) {
            fileNames = this.monitorMap.keySet().toArray();
        }
        for (int iterFileNames = 0; iterFileNames < fileNames.length; ++iterFileNames) {
            FileMonitorAgent agent;
            File fileName = (File)fileNames[iterFileNames];
            Map<File, FileMonitorAgent> map2 = this.monitorMap;
            synchronized (map2) {
                agent = this.monitorMap.get(fileName);
            }
            if (agent != null) {
                agent.check(result);
            }
            if (this.getChecksPerRun() <= 0 || this.delay <= 0L || iterFileNames == 0 || iterFileNames % this.getChecksPerRun() != 0) continue;
            try {
                Thread.sleep(this.delay);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        while (!this.addStack.empty()) {
            this.addFile(this.addStack.pop());
        }
        if (!result.isEmpty() && this.callback != null) {
            this.callback.process(result);
        }
    }

    public void setChecksPerRun(int checksPerRun) {
        this.checksPerRun = checksPerRun;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public void setFilesToIgnore(Set<String> filesToIgnore) {
        this.filesToIgnore = filesToIgnore != null && filesToIgnore.isEmpty() ? null : filesToIgnore;
    }

    public void setFilesToIgnore(String ... filesToIgnore) {
        if (filesToIgnore == null || filesToIgnore.length == 0) {
            this.setFilesToIgnore((Set<String>)null);
        } else {
            this.setFilesToIgnore(new HashSet<String>(Arrays.asList(filesToIgnore)));
        }
    }

    public void setOnlyFiles(boolean onlyFiles) {
        this.onlyFiles = onlyFiles;
    }

    public void setRecursive(boolean newRecursive) {
        this.recursive = newRecursive;
    }

    private static final class FileMonitorAgent
    implements Serializable {
        private static final long serialVersionUID = -4615339614778628865L;
        private Map<File, Object> children;
        private boolean exists;
        private final File file;
        private final FileMonitor fm;
        private boolean isFile;
        private long timestamp;
        private long length;

        private FileMonitorAgent(FileMonitor fm, File file) {
            this.fm = fm;
            this.file = file;
            this.resetChildrenList();
            this.exists = this.file.exists();
            if (this.exists) {
                this.timestamp = this.file.lastModified();
                this.length = this.file.length();
                this.isFile = file.isFile();
            }
        }

        private void check(FileListener listener) {
            if (this.exists && !this.file.exists()) {
                this.exists = this.file.exists();
                this.timestamp = -1L;
                this.length = 0L;
                if (!this.fm.onlyFiles || this.isFile) {
                    listener.fileDeleted(this.file);
                }
                this.fm.queueRemoveFile(this.file);
            } else if (this.exists && this.file.exists()) {
                long lastModified = this.file.lastModified();
                long length = this.file.length();
                if (this.timestamp != lastModified || this.length != length) {
                    this.timestamp = lastModified;
                    this.length = length;
                    if (!this.file.isDirectory()) {
                        listener.fileChanged(this.file);
                    }
                }
            } else if (!this.exists && this.file.exists()) {
                this.exists = this.file.exists();
                this.timestamp = this.file.lastModified();
                this.length = this.file.length();
                if (!this.file.isDirectory()) {
                    listener.fileCreated(this.file);
                }
            }
            this.checkForNewChildren(listener);
        }

        private void checkForNewChildren(FileListener listener) {
            block4: {
                File[] newChildren;
                block5: {
                    if (!this.file.isDirectory()) break block4;
                    newChildren = this.file.listFiles();
                    if (this.children == null) break block5;
                    HashMap<File, Object> newChildrenMap = new HashMap<File, Object>();
                    Stack<File> missingChildren = new Stack<File>();
                    for (File newChild : newChildren) {
                        if (this.fm.isIgnored(newChild)) continue;
                        newChildrenMap.put(newChild, new Object());
                        if (this.children.containsKey(newChild)) continue;
                        missingChildren.push(newChild);
                    }
                    this.children = newChildrenMap;
                    if (missingChildren.empty()) break block4;
                    while (!missingChildren.empty()) {
                        File child = (File)missingChildren.pop();
                        this.fireAllCreate(child, listener);
                    }
                    break block4;
                }
                if (newChildren.length > 0) {
                    this.children = new HashMap<File, Object>();
                }
                for (File newChild : newChildren) {
                    if (this.fm.isIgnored(newChild)) continue;
                    this.children.put(newChild, new Object());
                    this.fireAllCreate(newChild, listener);
                }
            }
        }

        private void fireAllCreate(File child, FileListener listener) {
            if (!this.fm.onlyFiles || child.isFile()) {
                listener.fileCreated(child);
            }
            this.fm.queueAddFile(child);
            if (this.fm.isRecursive() && child.isDirectory()) {
                File[] newChildren = child.listFiles();
                for (int i = 0; i < newChildren.length; ++i) {
                    this.fireAllCreate(newChildren[i], listener);
                }
            }
        }

        private void resetChildrenList() {
            if (this.file.isDirectory()) {
                this.children = new HashMap<File, Object>();
                File[] childrenList = this.file.listFiles();
                for (int i = 0; i < childrenList.length; ++i) {
                    this.children.put(childrenList[i], new Object());
                }
            }
        }
    }
}

