/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.deamons.filewatcher;

import org.jahia.registries.ServicesRegistry;
import org.jahia.services.deamons.filewatcher.FileMonitor;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.StatefulJob;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMonitorJob
implements StatefulJob {
    private static final Logger logger = LoggerFactory.getLogger(FileMonitorJob.class);

    public static void schedule(String jobName, long interval, FileMonitor monitor) {
        JobDetail jobDetail = new JobDetail(jobName, "DEFAULT", FileMonitorJob.class);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put((Object)"fileMonitor", (Object)monitor);
        jobDetail.setJobDataMap(jobDataMap);
        SimpleTrigger trigger = new SimpleTrigger(jobName + "_Trigger", "DEFAULT", -1, interval);
        trigger.setVolatility(true);
        jobDetail.setRequestsRecovery(false);
        jobDetail.setDurability(false);
        jobDetail.setVolatility(true);
        try {
            ServicesRegistry.getInstance().getSchedulerService().getRAMScheduler().deleteJob(jobName, "DEFAULT");
        }
        catch (SchedulerException e) {
            logger.warn("Unable to delete the job " + jobName + ". Cause: " + e.getMessage());
        }
        try {
            ServicesRegistry.getInstance().getSchedulerService().getRAMScheduler().scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (SchedulerException je) {
            logger.error("Error while scheduling file monitor job " + jobName, (Throwable)je);
        }
    }

    public static void unschedule(String jobName) {
        try {
            ServicesRegistry.getInstance().getSchedulerService().getRAMScheduler().deleteJob(jobName, "DEFAULT");
        }
        catch (SchedulerException e) {
            logger.warn("Unable to delete the job " + jobName + ". Cause: " + e.getMessage());
        }
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        FileMonitor monitor = (FileMonitor)jobDataMap.get((Object)"fileMonitor");
        monitor.run();
    }
}

