/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.history;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.persistence.pool.BundleDbPersistenceManager;
import org.apache.jackrabbit.core.persistence.pool.DerbyPersistenceManager;
import org.apache.jackrabbit.core.persistence.util.NodeInfo;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.version.InternalVersionManager;
import org.apache.jackrabbit.core.version.InternalVersionManagerImpl;
import org.apache.jackrabbit.core.version.InternalXAVersionManager;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.history.NodeVersionHistoryHelper;
import org.jahia.services.history.OrphanedVersionHistoryCheckStatus;
import org.jahia.services.history.OutWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OrphanedVersionHistoryChecker {
    private static int loadVersionBundleBatchSize;
    private static final Logger logger;
    private int checkOrphanedBatchSize;
    private final boolean deleteOrphans;
    private boolean forceStop;
    private final long maxOrphans;
    private final List<NodeId> nodesToCheck = new LinkedList<NodeId>();
    private final List<NodeId> orphans = new LinkedList<NodeId>();
    private final OutWrapper out;
    private BundleDbPersistenceManager persistenceManager;
    private final OrphanedVersionHistoryCheckStatus status;

    OrphanedVersionHistoryChecker(OrphanedVersionHistoryCheckStatus status, long maxOrphans, boolean deleteOrphans, OutWrapper out) {
        this.status = status;
        this.maxOrphans = maxOrphans;
        this.deleteOrphans = deleteOrphans;
        this.out = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOrphaned(JCRSessionWrapper session) throws RepositoryException {
        try {
            long timer = System.currentTimeMillis();
            Map existsReferencesToNodes = this.persistenceManager.existsReferencesToNodes(this.nodesToCheck);
            if (logger.isDebugEnabled()) {
                logger.debug("persistenceManager.existsReferencesToNodes took {} ms", (Object)(System.currentTimeMillis() - timer));
            }
            this.status.checked += (long)this.nodesToCheck.size();
            for (Map.Entry ref : existsReferencesToNodes.entrySet()) {
                if (!((Boolean)ref.getValue()).booleanValue()) {
                    ++this.status.orphaned;
                    if (this.deleteOrphans) {
                        this.orphans.add((NodeId)ref.getKey());
                    }
                    if (this.status.orphaned >= this.maxOrphans) {
                        this.out.echo("{} version histories checked and the limit of {} orphaned version histories is reached. Stopping checks.", this.status.checked, this.maxOrphans);
                        break;
                    }
                    if (this.deleteOrphans && this.status.orphaned > 0L && this.orphans.size() >= NodeVersionHistoryHelper.PURGE_HISTORY_CHUNK) {
                        this.delete(session);
                    }
                }
                if (!this.forceStop) continue;
                return;
            }
        }
        catch (ItemStateException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        finally {
            this.nodesToCheck.clear();
            if (this.status.orphaned < this.maxOrphans) {
                this.out.echo(this.status.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete(JCRSessionWrapper session) {
        this.out.echo("Start deleting version history for {} nodes", this.orphans.size());
        try {
            long nb = this.status.deleted;
            long timer = System.currentTimeMillis();
            NodeVersionHistoryHelper.purgeVersionHistories(this.orphans, session, this.status);
            this.out.echo("deleted {} version histories in {} ms", this.status.deleted - nb, System.currentTimeMillis() - timer);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.out.echo("Error deleting version histories. Cause: {}", e.getMessage());
        }
        finally {
            this.orphans.clear();
        }
    }

    private Map<NodeId, NodeInfo> getAllNodeInfos(NodeId bigger) {
        Map batch = Collections.emptyMap();
        try {
            batch = this.persistenceManager.getAllNodeInfos(bigger, loadVersionBundleBatchSize);
        }
        catch (ItemStateException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return batch;
    }

    private void initBatchSizeLimits() {
        this.checkOrphanedBatchSize = Integer.getInteger("org.jahia.services.history.checkOrphanedBatchSize", 0);
        if (this.checkOrphanedBatchSize == 0) {
            this.checkOrphanedBatchSize = this.persistenceManager instanceof DerbyPersistenceManager ? 100 : (this.persistenceManager.getStorageModel() == 2 ? 500 : 1000);
        }
        loadVersionBundleBatchSize = Integer.getInteger("org.jahia.services.history.loadVersionBundleBatchSize", 8000);
    }

    void perform(JCRSessionWrapper session) throws RepositoryException {
        SessionImpl providerSession = (SessionImpl)session.getProviderSession(session.getNode("/").getProvider());
        InternalVersionManager vm = providerSession.getInternalVersionManager();
        PersistenceManager pm = null;
        if (vm instanceof InternalVersionManagerImpl) {
            pm = ((InternalVersionManagerImpl)vm).getPersistenceManager();
        } else if (vm instanceof InternalXAVersionManager) {
            pm = ((InternalXAVersionManager)vm).getPersistenceManager();
        } else {
            logger.warn("Unknown implemmentation of the InternalVersionManager: {}.", (Object)vm.getClass().getName());
        }
        if (pm == null || !(pm instanceof BundleDbPersistenceManager)) {
            this.out.echo("The provided PersistenceManager {} is not an instance of BundleDbPersistenceManager. Unable to proceed.", pm);
            return;
        }
        this.persistenceManager = (BundleDbPersistenceManager)pm;
        this.initBatchSizeLimits();
        this.traverse(session);
        if (this.forceStop) {
            this.out.echo("Request received to stop checking nodes.");
        } else if (this.deleteOrphans && this.orphans.size() > 0) {
            this.delete(session);
        }
    }

    void stop() {
        this.forceStop = true;
    }

    private void traverse(JCRSessionWrapper session) throws RepositoryException {
        Map<Object, Object> batch = this.getAllNodeInfos(null);
        while (!batch.isEmpty()) {
            NodeId lastId = null;
            for (NodeInfo info : batch.values()) {
                lastId = info.getId();
                if (NameConstants.NT_VERSIONHISTORY.equals(info.getNodeTypeName())) {
                    this.nodesToCheck.add(info.getId());
                    if (this.nodesToCheck.size() >= this.checkOrphanedBatchSize) {
                        this.checkOrphaned(session);
                    }
                }
                if (this.status.orphaned >= this.maxOrphans) break;
                if (!this.forceStop) continue;
                return;
            }
            batch = this.status.orphaned < this.maxOrphans ? this.getAllNodeInfos(lastId) : Collections.emptyMap();
        }
        if (this.nodesToCheck.size() > 0) {
            this.checkOrphaned(session);
        }
        if (this.deleteOrphans && this.orphans.size() > 0) {
            this.delete(session);
        }
    }

    static {
        logger = LoggerFactory.getLogger(OrphanedVersionHistoryChecker.class);
    }
}

