/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.history;

import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.persistence.pool.BundleDbPersistenceManager;
import org.apache.jackrabbit.core.persistence.pool.DerbyPersistenceManager;
import org.apache.jackrabbit.core.persistence.util.NodeInfo;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.version.InternalVersionManager;
import org.apache.jackrabbit.core.version.InternalVersionManagerImpl;
import org.apache.jackrabbit.core.version.InternalXAVersionManager;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.util.ISO8601;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.history.NodeVersionHistoryHelper;
import org.jahia.services.history.OutWrapper;
import org.jahia.services.history.UnusedVersionCheckStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UnusedVersionChecker {
    private static int loadVersionBundleBatchSize;
    private static final Logger logger;
    private static Integer purgeVersionsBatchSize;
    private int checkUnusedBatchSize;
    private final boolean deleteUnused;
    private boolean forceStop;
    private final long maxUnused;
    private final List<NodeId> nodesToCheck = new LinkedList<NodeId>();
    private final OutWrapper out;
    private BundleDbPersistenceManager persistenceManager;
    private final UnusedVersionCheckStatus status;
    private final List<NodeId> unused = new LinkedList<NodeId>();

    UnusedVersionChecker(UnusedVersionCheckStatus status, long maxUnused, boolean deleteUnused, OutWrapper out) {
        this.status = status;
        this.maxUnused = maxUnused;
        this.deleteUnused = deleteUnused;
        this.out = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUnused(JCRSessionWrapper session) throws RepositoryException {
        try {
            long timer = System.currentTimeMillis();
            Map existsReferencesToNodes = this.persistenceManager.existsReferencesToNodes(this.nodesToCheck);
            if (logger.isDebugEnabled()) {
                logger.debug("persistenceManager.existsReferencesToNodes took {} ms", (Object)(System.currentTimeMillis() - timer));
            }
            this.status.checked += (long)this.nodesToCheck.size();
            for (Map.Entry ref : existsReferencesToNodes.entrySet()) {
                if (!((Boolean)ref.getValue()).booleanValue()) {
                    ++this.status.orphaned;
                    if (this.deleteUnused) {
                        this.unused.add((NodeId)ref.getKey());
                    }
                    if (this.status.orphaned >= this.maxUnused) {
                        this.out.echo("{} versions checked and the limit of {} versions is reached. Stopping checks.", this.status.checked, this.maxUnused);
                        break;
                    }
                    if (this.deleteUnused && this.status.orphaned > 0L && this.unused.size() >= purgeVersionsBatchSize) {
                        this.delete(session);
                    }
                }
                if (!this.forceStop) continue;
                return;
            }
        }
        catch (ItemStateException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        finally {
            this.nodesToCheck.clear();
            if (this.status.orphaned < this.maxUnused) {
                this.out.echo(this.status.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete(JCRSessionWrapper session) {
        this.out.echo("Start deleting {} versions", this.unused.size());
        try {
            long nb = this.status.deletedVersionItems;
            long timer = System.currentTimeMillis();
            NodeVersionHistoryHelper.purgeUnusedVersions(this.unused, session, this.status);
            this.out.echo("deleted {} version items in {} ms", this.status.deletedVersionItems - nb, System.currentTimeMillis() - timer);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.out.echo("Error deleting version histories. Cause: {}", e.getMessage());
        }
        finally {
            this.unused.clear();
        }
    }

    private Map<NodeId, NodeInfo> getAllNodeInfos(NodeId bigger) {
        Map batch = Collections.emptyMap();
        try {
            batch = this.persistenceManager.getAllNodeInfos(bigger, loadVersionBundleBatchSize);
        }
        catch (ItemStateException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return batch;
    }

    private void initBatchSizeLimits() {
        this.checkUnusedBatchSize = Integer.getInteger("org.jahia.services.history.checkUnusedBatchSize", 0);
        if (this.checkUnusedBatchSize == 0) {
            this.checkUnusedBatchSize = this.persistenceManager instanceof DerbyPersistenceManager ? 100 : (this.persistenceManager.getStorageModel() == 2 ? 500 : 1000);
        }
        loadVersionBundleBatchSize = Integer.getInteger("org.jahia.services.history.loadVersionBundleBatchSize", 8000);
        purgeVersionsBatchSize = Integer.getInteger("org.jahia.services.history.purgeVersionsBatchSize", 100);
    }

    private boolean isOlder(NodeInfo info, long purgeOlderThanTimestamp) {
        if (purgeOlderThanTimestamp <= 0L) {
            return true;
        }
        Calendar created = null;
        if (info.getCreated() != null) {
            try {
                created = ISO8601.parse((String)info.getCreated());
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.warn("Error parsing creation date " + info.getCreated() + " for node " + info.getId(), (Throwable)e);
                }
                logger.warn("Error parsing creation date " + info.getCreated() + " for node " + info.getId());
            }
        }
        return created != null && created.getTimeInMillis() < purgeOlderThanTimestamp;
    }

    private boolean isRootVersion(NodeInfo info) {
        List predecessors = (List)info.getReferences().get(NameConstants.JCR_PREDECESSORS);
        return predecessors == null || predecessors.isEmpty();
    }

    void perform(JCRSessionWrapper session, long purgeOlderThanTimestamp) throws RepositoryException {
        SessionImpl providerSession = (SessionImpl)session.getProviderSession(session.getNode("/").getProvider());
        InternalVersionManager vm = providerSession.getInternalVersionManager();
        PersistenceManager pm = null;
        if (vm instanceof InternalVersionManagerImpl) {
            pm = ((InternalVersionManagerImpl)vm).getPersistenceManager();
        } else if (vm instanceof InternalXAVersionManager) {
            pm = ((InternalXAVersionManager)vm).getPersistenceManager();
        } else {
            logger.warn("Unknown implemmentation of the InternalVersionManager: {}.", (Object)vm.getClass().getName());
        }
        if (pm == null || !(pm instanceof BundleDbPersistenceManager)) {
            this.out.echo("The provided PersistenceManager {} is not an instance of BundleDbPersistenceManager. Unable to proceed.", pm);
            return;
        }
        this.persistenceManager = (BundleDbPersistenceManager)pm;
        this.initBatchSizeLimits();
        this.traverse(session, purgeOlderThanTimestamp);
        if (this.forceStop) {
            this.out.echo("Request received to stop checking nodes.");
        } else if (this.deleteUnused && this.unused.size() > 0) {
            this.delete(session);
        }
    }

    void stop() {
        this.forceStop = true;
    }

    private void traverse(JCRSessionWrapper session, long purgeOlderThanTimestamp) throws RepositoryException {
        Map<Object, Object> batch = this.getAllNodeInfos(null);
        while (!batch.isEmpty()) {
            NodeId lastId = null;
            for (NodeInfo info : batch.values()) {
                lastId = info.getId();
                if (NameConstants.NT_VERSION.equals(info.getNodeTypeName())) {
                    if (this.isRootVersion(info)) continue;
                    if (this.isOlder(info, purgeOlderThanTimestamp)) {
                        this.nodesToCheck.add(info.getId());
                    }
                    if (this.nodesToCheck.size() >= this.checkUnusedBatchSize) {
                        this.checkUnused(session);
                    }
                }
                if (this.status.orphaned >= this.maxUnused) break;
                if (!this.forceStop) continue;
                return;
            }
            batch = this.status.orphaned < this.maxUnused ? this.getAllNodeInfos(lastId) : Collections.emptyMap();
        }
        if (this.nodesToCheck.size() > 0) {
            this.checkUnused(session);
        }
        if (this.deleteUnused && this.unused.size() > 0) {
            this.delete(session);
        }
    }

    static {
        logger = LoggerFactory.getLogger(UnusedVersionChecker.class);
    }
}

