/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.image;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import org.jahia.services.image.AbstractImageService;
import org.jahia.services.image.AbstractJava2DImageService;
import org.jahia.services.image.BufferImage;
import org.jahia.services.image.Image;
import org.jahia.services.image.JahiaImageService;

public class Java2DProgressiveBilinearImageService
extends AbstractJava2DImageService {
    @Override
    public boolean resizeImage(Image image, File outputFile, int newWidth, int newHeight, JahiaImageService.ResizeType resizeType) throws IOException {
        BufferedImage originalImage = ((BufferImage)image).getOriginalImage();
        BufferedImage dest = this.resizeImage(originalImage, newWidth, newHeight, resizeType);
        if (dest == null) {
            return false;
        }
        this.saveImageToFile(dest, ((BufferImage)image).getMimeType(), outputFile);
        return true;
    }

    @Override
    public BufferedImage resizeImage(BufferedImage image, int width, int height, JahiaImageService.ResizeType resizeType) {
        int startHeight;
        AbstractImageService.ResizeCoords resizeCoords = this.getResizeCoords(resizeType, image.getWidth(), image.getHeight(), width, height);
        if (JahiaImageService.ResizeType.ADJUST_SIZE.equals((Object)resizeType)) {
            width = resizeCoords.getTargetWidth();
            height = resizeCoords.getTargetHeight();
        }
        int currentWidth = resizeCoords.getSourceWidth();
        int currentHeight = resizeCoords.getSourceHeight();
        int targetWidth = resizeCoords.getTargetWidth();
        int targetHeight = resizeCoords.getTargetHeight();
        BufferedImage dest = this.getDestImage(width, height, image);
        Graphics2D graphics2D = this.getGraphics2D(dest, AbstractJava2DImageService.OperationType.RESIZE);
        if (width * 2 >= resizeCoords.getSourceWidth() && height * 2 >= resizeCoords.getSourceHeight()) {
            graphics2D.drawImage(image, resizeCoords.getTargetStartPosX(), resizeCoords.getTargetStartPosY(), resizeCoords.getTargetStartPosX() + resizeCoords.getTargetWidth(), resizeCoords.getTargetStartPosY() + resizeCoords.getTargetHeight(), resizeCoords.getSourceStartPosX(), resizeCoords.getSourceStartPosY(), resizeCoords.getSourceStartPosX() + resizeCoords.getSourceWidth(), resizeCoords.getSourceStartPosY() + resizeCoords.getSourceHeight(), null);
            graphics2D.dispose();
            return dest;
        }
        BufferedImage tempImage = new BufferedImage(currentWidth, currentHeight, dest.getType());
        Graphics2D g = this.getGraphics2D(tempImage, AbstractJava2DImageService.OperationType.RESIZE);
        g.setComposite(AlphaComposite.Src);
        int startWidth = resizeCoords.getTargetWidth();
        for (startHeight = resizeCoords.getTargetHeight(); startWidth < currentWidth && startHeight < currentHeight; startWidth *= 2, startHeight *= 2) {
        }
        currentWidth = startWidth / 2;
        currentHeight = startHeight / 2;
        g.drawImage(image, 0, 0, currentWidth, currentHeight, resizeCoords.getSourceStartPosX(), resizeCoords.getSourceStartPosY(), resizeCoords.getSourceStartPosX() + resizeCoords.getSourceWidth(), resizeCoords.getSourceStartPosY() + resizeCoords.getSourceHeight(), null);
        while (currentWidth >= targetWidth * 2 && currentHeight >= targetHeight * 2) {
            currentHeight /= 2;
            if ((currentWidth /= 2) < targetWidth) {
                currentWidth = targetWidth;
            }
            if (currentHeight < targetHeight) {
                currentHeight = targetHeight;
            }
            g.drawImage(tempImage, 0, 0, currentWidth, currentHeight, 0, 0, currentWidth * 2, currentHeight * 2, null);
        }
        g.dispose();
        graphics2D.drawImage(tempImage, resizeCoords.getTargetStartPosX(), resizeCoords.getTargetStartPosY(), resizeCoords.getTargetStartPosX() + targetWidth, resizeCoords.getTargetStartPosY() + targetHeight, 0, 0, currentWidth, currentHeight, null);
        graphics2D.dispose();
        return dest;
    }

    @Override
    protected Graphics2D getGraphics2D(BufferedImage dest, AbstractJava2DImageService.OperationType operationType) {
        Graphics2D graphics2D = dest.createGraphics();
        if (dest.getColorModel() instanceof IndexColorModel) {
            if (AbstractJava2DImageService.OperationType.RESIZE.equals((Object)operationType)) {
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            }
            graphics2D.setComposite(AlphaComposite.getInstance(2));
            IndexColorModel indexColorModel = (IndexColorModel)dest.getColorModel();
            int transparentPixelIndex = indexColorModel.getTransparentPixel();
            if (transparentPixelIndex > -1) {
                int transparentRGB = indexColorModel.getRGB(transparentPixelIndex);
                Color transparentColor = new Color(transparentRGB, true);
                graphics2D.setBackground(transparentColor);
                graphics2D.setColor(transparentColor);
                graphics2D.setPaint(transparentColor);
                graphics2D.fillRect(0, 0, dest.getWidth(), dest.getHeight());
            }
        } else if (AbstractJava2DImageService.OperationType.RESIZE.equals((Object)operationType)) {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DEFAULT);
        }
        return graphics2D;
    }
}

