/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.jcr.RepositoryException;
import org.jahia.exceptions.JahiaException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.categories.Category;
import org.jahia.services.categories.CategoryService;
import org.jahia.utils.LanguageCodeConverters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CategoriesImportHandler
extends DefaultHandler {
    private static Logger logger = LoggerFactory.getLogger(CategoriesImportHandler.class);
    private Stack<Category> cats = new Stack();
    private CategoryService cs;
    private List<String[]> uuidProps = new ArrayList<String[]>();
    private Category rootCategory = null;

    public CategoriesImportHandler() {
        this.cs = ServicesRegistry.getInstance().getCategoryService();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            if (localName.equals("category")) {
                String parentPath;
                String key = attributes.getValue("http://www.jahia.org/", "key");
                if (this.cats.isEmpty()) {
                    this.cats.push(this.rootCategory);
                    return;
                }
                Category parent = this.cats.peek();
                if (parent == null) {
                    try {
                        parentPath = this.cs.getCategoriesRoot().getPath();
                    }
                    catch (RepositoryException e) {
                        throw new SAXException((Exception)((Object)e));
                    }
                } else {
                    parentPath = parent.getCategoryPath();
                }
                Category cat = this.cs.getCategoryByPath(parentPath + "/" + key);
                Category c = cat == null ? Category.createCategory(key, parent) : cat;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String k = attributes.getLocalName(i);
                    if (!k.startsWith("title_")) continue;
                    c.setTitle(LanguageCodeConverters.languageCodeToLocale(k.substring(6)), attributes.getValue(i));
                }
                String acl = attributes.getValue("http://www.jahia.org/", "acl");
                if (acl != null) {
                    // empty if block
                }
                this.cats.push(c);
            }
            if (localName.equals("property")) {
                String key = attributes.getValue("http://www.jahia.org/", "key");
                String value = attributes.getValue("http://www.jahia.org/", "value");
                if (!this.cats.empty()) {
                    Category c = this.cats.peek();
                    if (key != null && value != null) {
                        if (key.startsWith("homepage")) {
                            this.uuidProps.add(new String[]{c.getKey(), key, value});
                        }
                        c.setProperty(key, value);
                    }
                }
            }
        }
        catch (JahiaException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("category")) {
            this.cats.pop();
        }
    }

    public List<String[]> getUuidProps() {
        return this.uuidProps;
    }

    public void setUuidProps(List<String[]> p) {
        if (p == null) {
            return;
        }
        Iterator<String[]> iterator = p.iterator();
        while (iterator.hasNext()) {
            try {
                String[] s = iterator.next();
                Category c = Category.getCategory(s[0]);
            }
            catch (JahiaException e) {
                logger.error("Cannot set property for category ", (Throwable)e);
            }
        }
    }

    public void setRootCategory(Category cat) {
        this.rootCategory = cat;
    }
}

